/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid.editors;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.editors.DialogCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ColorCellEditor
extends DialogCellEditor {
    private static final int DEFAULT_EXTENT = 16;
    private static final int GAP = 6;
    private Composite composite;
    private Label colorLabel;
    private Label rgbLabel;
    private Image image;

    public ColorCellEditor(AgileGrid agileGrid) {
        this(agileGrid, 0);
    }

    public ColorCellEditor(AgileGrid agileGrid, int style) {
        super(agileGrid, style);
        this.doSetValue(new RGB(0, 0, 0));
    }

    private ImageData createColorImage(Control w, RGB color) {
        GC gc = new GC((Drawable)w);
        FontMetrics fm = gc.getFontMetrics();
        int size = fm.getAscent();
        gc.dispose();
        int indent = 6;
        int extent = 16;
        if (w instanceof AgileGrid) {
            extent = ((AgileGrid)w).getLayoutAdvisor().getRowHeight(0) - 1;
        }
        if (size > extent) {
            size = extent;
        }
        int width = indent + size;
        int height = extent;
        int xoffset = indent;
        int yoffset = (height - size) / 2;
        RGB black = new RGB(0, 0, 0);
        PaletteData dataPalette = new PaletteData(new RGB[]{black, black, color});
        ImageData data = new ImageData(width, height, 4, dataPalette);
        data.transparentPixel = 0;
        int end = size - 1;
        int y = 0;
        while (y < size) {
            int x = 0;
            while (x < size) {
                if (x == 0 || y == 0 || x == end || y == end) {
                    data.setPixel(x + xoffset, y + yoffset, 1);
                } else {
                    data.setPixel(x + xoffset, y + yoffset, 2);
                }
                ++x;
            }
            ++y;
        }
        return data;
    }

    protected Control createContents(Composite parent) {
        Color bg = parent.getBackground();
        this.composite = new Composite(parent, this.getStyle());
        this.composite.setBackground(bg);
        this.composite.setLayout((Layout)new ColorCellLayout());
        this.colorLabel = new Label(this.composite, 16384);
        this.colorLabel.setBackground(bg);
        this.rgbLabel = new Label(this.composite, 16384);
        this.rgbLabel.setBackground(bg);
        this.rgbLabel.setFont(parent.getFont());
        return this.composite;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
        super.dispose();
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        ColorDialog dialog = new ColorDialog(cellEditorWindow.getShell());
        Object value = this.getValue();
        if (value != null) {
            dialog.setRGB((RGB)value);
        }
        value = dialog.open();
        return dialog.getRGB();
    }

    protected void updateContents(Object value) {
        RGB rgb = (RGB)value;
        if (rgb == null) {
            rgb = new RGB(0, 0, 0);
        }
        if (this.image != null) {
            this.image.dispose();
        }
        ImageData id = this.createColorImage((Control)this.colorLabel.getParent().getParent(), rgb);
        ImageData mask = id.getTransparencyMask();
        this.image = new Image((Device)this.colorLabel.getDisplay(), id, mask);
        this.colorLabel.setImage(this.image);
        this.rgbLabel.setText("(" + rgb.red + "," + rgb.green + "," + rgb.blue + ")");
    }

    private class ColorCellLayout
    extends Layout {
        private ColorCellLayout() {
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Point colorSize = ColorCellEditor.this.colorLabel.computeSize(-1, -1, force);
            Point rgbSize = ColorCellEditor.this.rgbLabel.computeSize(-1, -1, force);
            return new Point(colorSize.x + 6 + rgbSize.x, Math.max(colorSize.y, rgbSize.y));
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            Point colorSize = ColorCellEditor.this.colorLabel.computeSize(-1, -1, force);
            Point rgbSize = ColorCellEditor.this.rgbLabel.computeSize(-1, -1, force);
            int ty = (bounds.height - rgbSize.y) / 2;
            if (ty < 0) {
                ty = 0;
            }
            ColorCellEditor.this.colorLabel.setBounds(-1, 0, colorSize.x, colorSize.y);
            ColorCellEditor.this.rgbLabel.setBounds(colorSize.x + 6 - 1, ty, bounds.width - colorSize.x - 6, bounds.height);
        }
    }
}

