/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.Cell;
import org.agilemore.agilegrid.ColumnSortComparator;
import org.agilemore.agilegrid.ICompositorStrategy;
import org.agilemore.agilegrid.ILayoutAdvisor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;

public class ColumnSortOnClick
extends MouseAdapter {
    private AgileGrid agileGrid;
    private ColumnSortComparator sortComparator;

    public ColumnSortOnClick(AgileGrid agileGrid, ColumnSortComparator sortComparator) {
        this.agileGrid = agileGrid;
        this.sortComparator = sortComparator;
    }

    public void mouseDown(MouseEvent e) {
        if (e.button != 1) {
            return;
        }
        Cell cell = this.agileGrid.getTopHeaderCell(e.x, e.y);
        if (cell == Cell.NULLCELL || !this.isSortable(cell.column)) {
            return;
        }
        int left = this.agileGrid.getColumnLeft(cell.column);
        int right = left + this.agileGrid.getColumnWidth(cell.column) - 1;
        int pad = this.agileGrid.getResizeAreaSize() / 2;
        if (e.x - left < pad || right - e.x < pad) {
            return;
        }
        ILayoutAdvisor layoutAdvisor = this.agileGrid.getLayoutAdvisor();
        ICompositorStrategy compositorStrategy = layoutAdvisor.getCompositorStrategy();
        if (compositorStrategy != null) {
            int type = 1;
            if (compositorStrategy.getSortColumn() == cell.column) {
                if (compositorStrategy.getSortState() == 1) {
                    type = 2;
                } else if (compositorStrategy.getSortState() == 2) {
                    type = -1;
                }
            }
            this.sortComparator.setColumnToCompare(cell.column);
            this.sortComparator.setSortDirection(type);
            compositorStrategy.sort(this.sortComparator);
            if (this.agileGrid.isCellEditorActive()) {
                this.agileGrid.getAgileGridEditor().cancelEditing();
            }
            this.agileGrid.redraw();
        }
    }

    public boolean isSortable(int col) {
        Cell cell = null;
        ILayoutAdvisor layoutAdvisor = this.agileGrid.getLayoutAdvisor();
        int totalRowCount = layoutAdvisor.getRowCount();
        int row = 0;
        while (row < totalRowCount) {
            cell = layoutAdvisor.mergeInto(row, col);
            if (cell != null && (cell.row != row || cell.column != col)) {
                return false;
            }
            ++row;
        }
        return true;
    }
}

