/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid.renderers;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.renderers.AbstractCellRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ButtonCellRenderer
extends AbstractCellRenderer {
    public ButtonCellRenderer(AgileGrid agileGrid) {
        super(agileGrid);
    }

    public ButtonCellRenderer(AgileGrid agileGrid, int style) {
        super(agileGrid, style);
    }

    protected Rectangle drawCellBorder(GC gc, Rectangle rect, int row, int col) {
        Color bottomBorderColor = COLOR_LINE_DARKGRAY;
        Color rightBorderColor = COLOR_LINE_DARKGRAY;
        if (this.agileGrid.isHeaderHighlighted(row, col)) {
            if ((this.style & 0x10) != 0) {
                bottomBorderColor = COLOR_TEXT;
                rightBorderColor = COLOR_TEXT;
            }
            if ((this.style & 0x20) != 0) {
                bottomBorderColor = COLOR_BGROWSELECTION;
                rightBorderColor = COLOR_BGROWSELECTION;
            }
        }
        boolean isPressed = this.agileGrid.isCellPressed(row, col);
        if ((this.style & 4) != 0) {
            if (isPressed) {
                Color pressedColor = display.getSystemColor(16);
                gc.setForeground(pressedColor);
                gc.drawRectangle(rect.x, rect.y, rect.width, 1);
                gc.drawRectangle(rect.x, rect.y, 1, rect.height);
                ++rect.x;
                ++rect.y;
                --rect.width;
                --rect.height;
                return rect;
            }
            rect = this.drawDefaultCellLine(gc, rect, bottomBorderColor, rightBorderColor);
        } else {
            this.drawCellButton(gc, rect, "", isPressed && (this.style & 0x40) != 0);
            rect.x += 2;
            rect.y += 2;
            rect.width -= 4;
            rect.height -= 4;
        }
        return rect;
    }

    protected void drawCellButton(GC gc, Rectangle rect, String text, boolean pressed) {
        ++rect.height;
        ++rect.width;
        gc.setForeground(display.getSystemColor(24));
        if (pressed) {
            this.drawButtonDown(gc, text, this.getAlignment(), null, this.getAlignment(), rect);
        } else {
            this.drawButtonUp(gc, text, this.getAlignment(), null, this.getAlignment(), rect);
        }
    }

    public void drawButtonUp(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int w, int h, Color face) {
        this.drawButtonUp(gc, text, textAlign, image, imageAlign, x, y, w, h, face, display.getSystemColor(20), display.getSystemColor(18), display.getSystemColor(17), 2, 2);
    }

    public void drawButtonUp(GC gc, String text, int textAlign, Image image, int imageAlign, Rectangle rect, int leftMargin, int topMargin) {
        this.drawButtonUp(gc, text, textAlign, image, imageAlign, rect.x, rect.y, rect.width, rect.height, display.getSystemColor(22), display.getSystemColor(20), display.getSystemColor(18), display.getSystemColor(17), leftMargin, topMargin);
    }

    public void drawButtonUp(GC gc, String text, int textAlign, Image image, int imageAlign, Rectangle rect) {
        this.drawButtonUp(gc, text, textAlign, image, imageAlign, rect.x, rect.y, rect.width, rect.height, display.getSystemColor(22), display.getSystemColor(20), display.getSystemColor(18), display.getSystemColor(17), 2, 2);
    }

    protected void drawButtonUp(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int width, int height, Color face, Color shadowHigh, Color shadowNormal, Color shadowDark, int leftMargin, int topMargin) {
        Color prevForeground = gc.getForeground();
        Color prevBackground = gc.getBackground();
        Rectangle clip = gc.getClipping();
        ++clip.height;
        ++clip.width;
        gc.setClipping(clip);
        try {
            gc.setBackground(face);
            gc.setForeground(shadowHigh);
            gc.drawLine(x, y, x, y + height - 1);
            gc.drawLine(x, y, x + width - 2, y);
            gc.setForeground(shadowDark);
            gc.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            gc.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            gc.setForeground(shadowNormal);
            gc.drawLine(x + width - 2, y + 1, x + width - 2, y + height - 2);
            gc.drawLine(x + 1, y + height - 2, x + width - 2, y + height - 2);
            gc.fillRectangle(x + 1, y + 1, width - 3, height - 3);
            gc.setForeground(prevForeground);
            this.drawTextImage(gc, text, textAlign, image, imageAlign, x + 1 + leftMargin, y + 1 + topMargin, width - 3 - leftMargin, height - 3 - topMargin);
        }
        finally {
            gc.setForeground(prevForeground);
            gc.setBackground(prevBackground);
        }
    }

    public void drawButtonDown(GC gc, String text, int textAlign, Image image, int imageAlign, Rectangle rect) {
        this.drawButtonDown(gc, text, textAlign, image, imageAlign, rect.x, rect.y, rect.width, rect.height, display.getSystemColor(22), display.getSystemColor(18), 2, 2);
    }

    protected void drawButtonDown(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int width, int height, Color face, Color shadowNormal, int leftMargin, int topMargin) {
        Color prevForeground = gc.getForeground();
        Color prevBackground = gc.getBackground();
        try {
            gc.setBackground(face);
            gc.setForeground(shadowNormal);
            Rectangle clip = gc.getClipping();
            ++clip.height;
            ++clip.width;
            gc.setClipping(clip);
            gc.drawRectangle(x, y, width - 1, height - 1);
            gc.fillRectangle(x + 1, y + 1, width - 2, height - 2);
            gc.setForeground(prevForeground);
            this.drawTextImage(gc, text, textAlign, image, imageAlign, x + 2 + leftMargin, y + 2 + topMargin, width - 3 - leftMargin, height - 3 - topMargin);
        }
        finally {
            gc.setForeground(prevForeground);
            gc.setBackground(prevBackground);
        }
    }

    protected void drawButtonDeepDown(GC gc, String text, int textAlign, Image image, int imageAlign, Rectangle rect) {
        gc.setForeground(display.getSystemColor(2));
        gc.drawLine(rect.x, rect.y, rect.x + rect.width - 2, rect.y);
        gc.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 2);
        gc.setForeground(display.getSystemColor(1));
        gc.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.y + rect.height - 1);
        gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
        gc.setForeground(display.getSystemColor(22));
        gc.drawLine(rect.x + 1, rect.y + rect.height - 2, rect.x + rect.width - 2, rect.y + rect.height - 2);
        gc.drawLine(rect.x + rect.width - 2, rect.y + rect.height - 2, rect.x + rect.width - 2, rect.y + 1);
        gc.setForeground(display.getSystemColor(21));
        gc.setBackground(display.getSystemColor(22));
        gc.fillRectangle(rect.x + 2, rect.y + 2, rect.width - 4, 1);
        gc.fillRectangle(rect.x + 1, rect.y + 2, 2, rect.height - 4);
        gc.setBackground(display.getSystemColor(22));
        this.drawTextImage(gc, text, textAlign, image, imageAlign, rect.x + 2 + 1, rect.y + 2 + 1, rect.width - 4, rect.height - 3 - 1);
    }

    protected void drawFlatButtonUp(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int width, int height, Color face, Color shadowLight, Color shadowNormal, int leftMargin, int topMargin) {
        Color prevForeground = gc.getForeground();
        Color prevBackground = gc.getBackground();
        try {
            gc.setForeground(shadowLight);
            gc.drawLine(x, y, x + width - 1, y);
            gc.drawLine(x, y, x, y + height);
            gc.setForeground(shadowNormal);
            gc.drawLine(x + width, y, x + width, y + height);
            gc.drawLine(x + 1, y + height, x + width, y + height);
            gc.setBackground(face);
            gc.fillRectangle(x + 1, y + 1, leftMargin, height - 1);
            gc.fillRectangle(x + 1, y + 1, width - 1, topMargin);
            gc.setBackground(face);
            gc.setForeground(prevForeground);
            this.drawTextImage(gc, text, textAlign, image, imageAlign, x + 1 + leftMargin, y + 1 + topMargin, width - 1 - leftMargin, height - 1 - topMargin);
        }
        finally {
            gc.setForeground(prevForeground);
            gc.setBackground(prevBackground);
        }
    }
}

