/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.Cell;
import org.agilemore.agilegrid.CellColumn;
import org.agilemore.agilegrid.CellNavigationStrategy;
import org.agilemore.agilegrid.CellRow;
import org.agilemore.agilegrid.FocusCellChangedEvent;
import org.agilemore.agilegrid.ICellNavigationStrategy;
import org.agilemore.agilegrid.IFocusCellChangedListener;
import org.agilemore.agilegrid.ILayoutAdvisor;
import org.agilemore.agilegrid.ISelectionChangedListener;
import org.agilemore.agilegrid.SelectionChangedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellSelectionManager {
    private AgileGrid agileGrid;
    private Set<Cell> selections;
    private Set<Cell> tbdSelection;
    private Cell focusCell;
    private Cell shiftCell;
    private ICellNavigationStrategy navigationStrategy;
    private ArrayList<ISelectionChangedListener> selectionChangedListeners;
    private ArrayList<IFocusCellChangedListener> focusCellChangedListeners;

    public CellSelectionManager(AgileGrid agileGrid, CellNavigationStrategy navigationStrategy) {
        this.agileGrid = agileGrid;
        this.focusCell = Cell.NULLCELL;
        this.selections = new HashSet<Cell>();
        this.tbdSelection = new HashSet<Cell>();
        this.selectionChangedListeners = new ArrayList(7);
        this.focusCellChangedListeners = new ArrayList(7);
        this.navigationStrategy = navigationStrategy;
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                CellSelectionManager.this.processEvent(event);
            }
        };
        this.hookEventListener(agileGrid, listener);
        this.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CellSelectionManager.this.onSelectionChanged(event);
            }
        });
        this.addFocusCellChangedListener(new IFocusCellChangedListener(){

            public void focusChanged(FocusCellChangedEvent event) {
                CellSelectionManager.this.onFocusChanged(event);
            }
        });
    }

    ICellNavigationStrategy getNavigationStrategy() {
        return this.navigationStrategy;
    }

    void setNavigationStrategy(ICellNavigationStrategy navigationStrategy) {
        this.navigationStrategy = navigationStrategy;
    }

    protected void processEvent(Event event) {
        Cell selectedCell = null;
        if (this.navigationStrategy.isNavigationEvent(this.agileGrid, event)) {
            this.agileGrid.forceFocus();
            Cell currentCell = this.focusCell;
            if (!this.tbdSelection.isEmpty()) {
                currentCell = this.shiftCell;
            }
            if ((selectedCell = this.navigationStrategy.findSelectedCell(this.agileGrid, currentCell, event)) != null && selectedCell != Cell.NULLCELL) {
                int stateMask = event.stateMask;
                if (event.keyCode == 9) {
                    stateMask &= 0xFFFDFFFF;
                }
                boolean isCellSelected = this.isCellSelected(selectedCell.row, selectedCell.column);
                if (event.type == 4) {
                    this.focusCell(selectedCell, stateMask, true);
                } else if (isCellSelected) {
                    if ((event.stateMask & 0x40000) == 262144 || (event.stateMask & 0x20000) == 131072) {
                        this.doSelectCell(selectedCell, stateMask);
                    } else {
                        this.focusCell(selectedCell, stateMask, false);
                    }
                } else {
                    this.focusCell(selectedCell, stateMask, true);
                }
                if (!this.agileGrid.isCellFullyVisible(this.focusCell.row, this.focusCell.column)) {
                    this.agileGrid.scrollToFocus(false);
                }
            }
        }
        if (this.navigationStrategy.shouldCancelEvent(this.agileGrid, event)) {
            event.doit = false;
        }
    }

    protected void hookEventListener(AgileGrid agileGrid, Listener listener) {
        agileGrid.addListener(1, listener);
        agileGrid.addListener(15, listener);
        agileGrid.addListener(29, listener);
        agileGrid.addListener(3, listener);
        agileGrid.addListener(4, listener);
        agileGrid.addListener(5, listener);
        agileGrid.addListener(8, listener);
        agileGrid.addListener(32, listener);
        agileGrid.addListener(7, listener);
    }

    protected void onFocusChanged(FocusCellChangedEvent event) {
        Cell newCell;
        Cell cell = event.getOldFocusCell();
        if (cell != Cell.NULLCELL) {
            this.agileGrid.redrawCells(new Cell[]{cell});
        }
        if ((newCell = event.getNewFocusCell()) != Cell.NULLCELL) {
            this.agileGrid.redrawCells(new Cell[]{newCell});
        }
    }

    protected void onSelectionChanged(SelectionChangedEvent event) {
        Set<Cell> needRedraw = event.getRemovedSelections();
        needRedraw.addAll(event.getAddedSelections());
        this.agileGrid.redrawCells(needRedraw.toArray(new Cell[0]));
    }

    Cell getFocusCell() {
        return this.focusCell;
    }

    boolean isFocusCell(int row, int col) {
        if (this.focusCell == Cell.NULLCELL || row <= -1 || col <= -1) {
            return false;
        }
        return this.focusCell.row == row && this.focusCell.column == col;
    }

    void focusCell(Cell cell, int stateMask, boolean setSelection) {
        if (cell == null) {
            cell = Cell.NULLCELL;
        }
        Cell oldFocusCell = this.focusCell;
        if (setSelection) {
            this.doSelectCell(cell, stateMask);
        } else {
            this.focusCell = cell;
        }
        Cell newFocusCell = this.focusCell;
        if (!newFocusCell.equals(oldFocusCell)) {
            this.fireFocusCellChanged(newFocusCell, oldFocusCell);
        }
    }

    void focusCell(Cell cell, int stateMask) {
        this.focusCell(cell, stateMask, true);
    }

    private void doSelectCell(Cell cell, int stateMask) {
        this.agileGrid.applyEditorValue();
        if (cell == null || cell == Cell.NULLCELL) {
            this.focusCell = Cell.NULLCELL;
            return;
        }
        Cell valid = this.agileGrid.getValidCell(cell.row, cell.column);
        if (valid == null || valid == Cell.NULLCELL) {
            return;
        }
        HashSet<Cell> oldSelections = null;
        Set<Cell> newSelections = null;
        int style = this.agileGrid.getStyle();
        if ((stateMask & 0x40000) != 0) {
            if (!this.agileGrid.isMultiSelectMode()) {
                return;
            }
            this.selections.addAll(this.tbdSelection);
            this.tbdSelection.clear();
            this.shiftCell = null;
            oldSelections = new HashSet<Cell>(this.selections);
            this.toggleSelection(valid);
            newSelections = this.selections;
            this.focusCell = valid;
            this.fireSelectionChanged(newSelections, oldSelections);
        } else if ((stateMask & 0x20000) != 0) {
            if (!this.agileGrid.isMultiSelectMode()) {
                return;
            }
            HashSet<Cell> oldTBDSelection = new HashSet<Cell>(this.tbdSelection);
            this.tbdSelection.clear();
            this.shiftCell = valid;
            int startRow = Math.min(valid.row, this.focusCell.row);
            int startCol = Math.min(valid.column, this.focusCell.column);
            int endRow = Math.max(valid.row, this.focusCell.row);
            int endCol = Math.max(valid.column, this.focusCell.column);
            if ((style & 0x8000000) != 0) {
                CellRow cellRow = null;
                int i = startRow;
                while (i <= endRow) {
                    cellRow = new CellRow(this.agileGrid, i);
                    this.tbdSelection.add(cellRow);
                    ++i;
                }
            } else if ((style & 0x10000000) != 0) {
                CellColumn cellColumn = null;
                int i = startCol;
                while (i <= endCol) {
                    cellColumn = new CellColumn(this.agileGrid, i);
                    this.tbdSelection.add(cellColumn);
                    ++i;
                }
            } else {
                if (startRow < 0) {
                    startRow = endRow;
                }
                if (startCol < 0) {
                    startCol = endCol;
                }
                int i = startRow;
                while (i <= endRow) {
                    int j = startCol;
                    while (j <= endCol) {
                        this.tbdSelection.add(new Cell(this.agileGrid, i, j));
                        ++j;
                    }
                    ++i;
                }
            }
            if (!this.tbdSelection.equals(oldTBDSelection)) {
                oldSelections = new HashSet<Cell>(this.selections);
                oldSelections.addAll(oldTBDSelection);
                newSelections = new HashSet<Cell>(this.selections);
                newSelections.addAll(this.tbdSelection);
                this.fireSelectionChanged(newSelections, oldSelections);
            }
        } else {
            oldSelections = new HashSet<Cell>(this.selections);
            oldSelections.addAll(this.tbdSelection);
            this.clearSelectionWithoutRedraw();
            this.addSelectionWithoutRedraw(valid);
            newSelections = this.selections;
            this.focusCell = valid;
            this.shiftCell = null;
            this.fireSelectionChanged(newSelections, oldSelections);
        }
        if (this.isCellSelected(cell.row, cell.column)) {
            Cell oldFocus = this.focusCell;
            this.focusCell = valid;
            if (oldFocus.equals(this.focusCell)) {
                this.fireFocusCellChanged(this.focusCell, oldFocus);
            }
        }
    }

    protected void clearSelectionWithoutRedraw() {
        this.selections.clear();
        this.tbdSelection.clear();
        this.focusCell = Cell.NULLCELL;
    }

    void clearSelection() {
        HashSet<Cell> oldSelections = null;
        HashSet<Cell> newSelections = null;
        Cell oldFocusCell = this.focusCell;
        oldSelections = new HashSet<Cell>(this.selections);
        newSelections = new HashSet<Cell>();
        this.clearSelectionWithoutRedraw();
        this.agileGrid.redraw();
        this.fireFocusCellChanged(this.focusCell, oldFocusCell);
        this.fireSelectionChanged(newSelections, oldSelections);
    }

    private void toggleSelection(Cell cell) {
        int style = this.agileGrid.getStyle();
        if ((style & 0x8000000) != 0) {
            CellRow cellRow = new CellRow(this.agileGrid, cell.row);
            if (this.selections.contains(cellRow)) {
                this.selections.remove(cellRow);
            } else {
                this.selections.add(cellRow);
            }
            Cell[] overlappedCells = this.agileGrid.getOverlappedCell(cell);
            int i = 0;
            while (i < overlappedCells.length) {
                if (overlappedCells[i].row != cell.row) {
                    cellRow = new CellRow(this.agileGrid, overlappedCells[i].row);
                    if (this.selections.contains(cellRow)) {
                        this.selections.remove(cellRow);
                    } else {
                        this.selections.add(cellRow);
                    }
                }
                ++i;
            }
        } else if ((style & 0x10000000) != 0) {
            CellColumn cellColumn = new CellColumn(this.agileGrid, cell.column);
            if (this.selections.contains(cellColumn)) {
                this.selections.remove(cellColumn);
            } else {
                this.selections.add(cellColumn);
            }
            Cell[] overlappedCells = this.agileGrid.getOverlappedCell(cell);
            int i = 0;
            while (i < overlappedCells.length) {
                if (overlappedCells[i].column != cell.column) {
                    cellColumn = new CellColumn(this.agileGrid, overlappedCells[i].column);
                    if (this.selections.contains(cellColumn)) {
                        this.selections.remove(cellColumn);
                    } else {
                        this.selections.add(cellColumn);
                    }
                }
                ++i;
            }
        } else if (this.selections.contains(cell)) {
            this.selections.remove(cell);
        } else {
            this.selections.add(cell);
        }
    }

    protected void addSelectionWithoutRedraw(Cell cell) {
        int style = this.agileGrid.getStyle();
        if ((style & 0x8000000) != 0) {
            this.selections.add(new CellRow(this.agileGrid, cell.row));
            Cell[] overCells = this.agileGrid.getOverlappedCell(cell);
            int i = 0;
            while (i < overCells.length) {
                if (overCells[i].row != cell.row) {
                    this.selections.add(new CellRow(this.agileGrid, overCells[i].row));
                }
                ++i;
            }
        } else if ((style & 0x10000000) != 0) {
            this.selections.add(new CellColumn(this.agileGrid, cell.column));
            Cell[] overCells = this.agileGrid.getOverlappedCell(cell);
            int i = 0;
            while (i < overCells.length) {
                if (overCells[i].column != cell.column) {
                    this.selections.add(new CellColumn(this.agileGrid, overCells[i].column));
                }
                ++i;
            }
        } else {
            this.selections.add(cell);
        }
    }

    void selectCells(Cell[] selections) {
        if (selections == null || selections.length < 1) {
            this.clearSelection();
            return;
        }
        try {
            ILayoutAdvisor layoutAdvisor = this.agileGrid.getLayoutAdvisor();
            this.agileGrid.setRedraw(false);
            if (this.agileGrid.isMultiSelectMode()) {
                int i = 0;
                while (i < selections.length) {
                    if (selections[i].column < layoutAdvisor.getColumnCount() && selections[i].column >= 0 && selections[i].row < layoutAdvisor.getRowCount() && selections[i].row >= 0) {
                        this.addSelectionWithoutRedraw(selections[i]);
                    }
                    ++i;
                }
            } else {
                this.addSelectionWithoutRedraw(selections[0]);
            }
        }
        finally {
            this.agileGrid.setRedraw(true);
        }
    }

    boolean isCellSelected(int row, int col) {
        Cell valid = this.agileGrid.getValidCell(row, col);
        int style = this.agileGrid.getStyle();
        if ((style & 0x8000000) != 0) {
            valid = new CellRow(this.agileGrid, valid.row);
        } else if ((style & 0x10000000) != 0) {
            valid = new CellColumn(this.agileGrid, valid.column);
        }
        if (this.tbdSelection.contains(valid)) {
            return true;
        }
        return this.selections.contains(valid);
    }

    Cell[] getCellSelection() {
        HashSet<Cell> cells = new HashSet<Cell>(this.selections);
        cells.addAll(this.tbdSelection);
        return cells.toArray(new Cell[0]);
    }

    protected boolean clickInSelectedCells(Point click) {
        Cell[] selection = this.getCellSelection();
        if (selection == null || selection.length < 0) {
            return false;
        }
        int i = 0;
        while (i < selection.length) {
            if (this.agileGrid.getCellRect(selection[i].row, selection[i].column).contains(click)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.selectionChangedListeners.contains(listener)) {
            this.selectionChangedListeners.add(listener);
        }
    }

    boolean removeSelectionChangedListener(ISelectionChangedListener listener) {
        return this.selectionChangedListeners.remove(listener);
    }

    private void fireSelectionChanged(Set<Cell> newSelections, Set<Cell> oldSelections) {
        SelectionChangedEvent event = new SelectionChangedEvent(this, newSelections, oldSelections);
        this.fireSelectionChanged(event);
    }

    private void fireSelectionChanged(SelectionChangedEvent event) {
        int i = 0;
        while (i < this.selectionChangedListeners.size()) {
            this.selectionChangedListeners.get(i).selectionChanged(event);
            ++i;
        }
    }

    void addFocusCellChangedListener(IFocusCellChangedListener listener) {
        if (!this.focusCellChangedListeners.contains(listener)) {
            this.focusCellChangedListeners.add(listener);
        }
    }

    boolean removeFocusCellChangedListener(IFocusCellChangedListener listener) {
        return this.focusCellChangedListeners.remove(listener);
    }

    private void fireFocusCellChanged(Cell newFocusCell, Cell oldFocusCell) {
        FocusCellChangedEvent event = new FocusCellChangedEvent(this, newFocusCell, oldFocusCell);
        this.fireFocusCellChanged(event);
    }

    private void fireFocusCellChanged(FocusCellChangedEvent event) {
        int i = 0;
        while (i < this.focusCellChangedListeners.size()) {
            this.focusCellChangedListeners.get(i).focusChanged(event);
            ++i;
        }
    }
}

