/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid.renderers;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.SWTResourceManager;
import org.agilemore.agilegrid.renderers.AbstractCellRenderer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class CheckboxCellRenderer
extends AbstractCellRenderer {
    public static final int SIGN_IMAGE = Integer.MIN_VALUE;
    public static final int SIGN_X = 0x40000000;
    public static final int SIGN_CHECK = 0x20000000;
    public static final Image IMAGE_CHECKED = SWTResourceManager.getImage(CheckboxCellRenderer.class, "/icons/checked.png");
    public static final Image IMAGE_UNCHECKED = SWTResourceManager.getImage(CheckboxCellRenderer.class, "/icons/unchecked.png");
    public static final Image IMAGE_CHECKED_CLICKED = SWTResourceManager.getImage(CheckboxCellRenderer.class, "/icons/checked_clicked.png");
    public static final Image IMAGE_UNCHECKED_CLICKED = SWTResourceManager.getImage(CheckboxCellRenderer.class, "/icons/unchecked_clicked.png");
    public static final Color COLOR_FILL = SWTResourceManager.getColor(206, 206, 206);
    public static final Color BORDER_DARK = SWTResourceManager.getColor(90, 90, 57);
    public static final Color BORDER_LIGHT = SWTResourceManager.getColor(156, 156, 123);

    public CheckboxCellRenderer(AgileGrid agileGrid, int style) {
        super(agileGrid, style);
    }

    public int getOptimalWidth(GC gc, int row, int col) {
        return CheckboxCellRenderer.IMAGE_CHECKED.getBounds().x + 6;
    }

    protected void initialColor(int row, int col) {
        if (this.agileGrid.isCellSelected(row, col)) {
            if ((this.style & 0x10) != 0) {
                this.background = COLOR_BGSELECTION;
            } else if ((this.style & 0x20) != 0) {
                this.foreground = COLOR_FGROWSELECTION;
                this.background = COLOR_BGROWSELECTION;
            }
        }
    }

    protected void doDrawCellContent(GC gc, Rectangle rect, int row, int col) {
        Object content = this.agileGrid.getContentAt(row, col);
        if (!(content instanceof Boolean)) {
            if (content.toString().equalsIgnoreCase("true")) {
                content = new Boolean(true);
            } else if (content.toString().equalsIgnoreCase("false")) {
                content = new Boolean(false);
            }
        }
        if (!(content instanceof Boolean)) {
            String text = "?";
            if ((this.style & 0x200) != 0) {
                this.drawVerticalTextImage(gc, rect, text, null, this.foreground, this.background);
            } else {
                int alignment = this.getAlignment();
                this.drawTextImage(gc, text, alignment, null, alignment, rect.x + 3, rect.y + 2, rect.width - 6, rect.height - 4);
            }
        } else {
            boolean isClicked = this.agileGrid.isCellPressed(row, col);
            if ((this.style & Integer.MIN_VALUE) != 0) {
                boolean checked = (Boolean)content;
                if (checked) {
                    if (isClicked && (this.style & 0x40) != 0) {
                        this.drawImage(gc, rect, IMAGE_CHECKED_CLICKED, this.background);
                    } else {
                        this.drawImage(gc, rect, IMAGE_CHECKED, this.background);
                    }
                } else if (isClicked && (this.style & 0x40) != 0) {
                    this.drawImage(gc, rect, IMAGE_UNCHECKED_CLICKED, this.background);
                } else {
                    this.drawImage(gc, rect, IMAGE_UNCHECKED, this.background);
                }
            } else {
                boolean checked = (Boolean)content;
                if (isClicked && (this.style & 0x40) != 0) {
                    this.drawCheckedSymbol(gc, rect, checked, this.background, COLOR_FILL);
                } else {
                    this.drawCheckedSymbol(gc, rect, checked, this.background, this.background);
                }
            }
        }
    }

    protected void drawImage(GC gc, Rectangle rect, Image image, Color background) {
        gc.setForeground(background);
        gc.setBackground(background);
        gc.fillRectangle(rect);
        this.drawTextImage(gc, "", this.getAlignment(), image, this.getAlignment(), rect.x + 3, rect.y, rect.width - 3, rect.height);
    }

    protected void drawCheckedSymbol(GC gc, Rectangle rect, boolean checked, Color background, Color fillColor) {
        Rectangle bound = this.getAlignedLocation(rect, IMAGE_CHECKED);
        gc.setForeground(BORDER_LIGHT);
        gc.drawLine(bound.x, bound.y, bound.x + bound.width, bound.y);
        gc.drawLine(bound.x, bound.y, bound.x, bound.y + bound.height);
        gc.setForeground(BORDER_DARK);
        gc.drawLine(bound.x + bound.width, bound.y + 1, bound.x + bound.width, bound.y + bound.height - 1);
        gc.drawLine(bound.x, bound.y + bound.height, bound.x + bound.width, bound.y + bound.height);
        if (!background.equals((Object)fillColor)) {
            gc.setBackground(fillColor);
            gc.fillRectangle(bound.x + 1, bound.y + 1, bound.width - 1, bound.height - 1);
        }
        if (checked) {
            this.drawCheckSymbol(gc, bound);
        }
    }

    private void drawCheckSymbol(GC gc, Rectangle bound) {
        if ((this.style & 0x40000000) != 0) {
            gc.setForeground(BORDER_LIGHT);
            gc.drawLine(bound.x + 3, bound.y + 2, bound.x - 2 + bound.width, bound.y - 3 + bound.height);
            gc.drawLine(bound.x + 2, bound.y + 3, bound.x - 3 + bound.width, bound.y - 2 + bound.height);
            gc.drawLine(bound.x + 3, bound.y - 2 + bound.height, bound.x - 2 + bound.width, bound.y + 3);
            gc.drawLine(bound.x + 2, bound.y - 3 + bound.height, bound.x - 3 + bound.width, bound.y + 2);
            gc.setForeground(COLOR_TEXT);
            gc.drawLine(bound.x + 2, bound.y + 2, bound.x - 2 + bound.width, bound.y - 2 + bound.height);
            gc.drawLine(bound.x + 2, bound.y - 2 + bound.height, bound.x - 2 + bound.width, bound.y + 2);
        } else {
            gc.setForeground(this.getForeground());
            gc.drawLine(bound.x + 2, bound.y + bound.height - 4, bound.x + 4, bound.y + bound.height - 2);
            gc.drawLine(bound.x + 2, bound.y + bound.height - 5, bound.x + 5, bound.y + bound.height - 3);
            gc.drawLine(bound.x + 2, bound.y + bound.height - 6, bound.x + 4, bound.y + bound.height - 4);
            int i = 1;
            while (i < 4) {
                gc.drawLine(bound.x + 2 + i, bound.y + bound.height - 3, bound.x + bound.width - 2, bound.y + 1 + i);
                ++i;
            }
        }
    }

    protected Rectangle getAlignedLocation(Rectangle rect, Image img) {
        Rectangle bounds = img.getBounds();
        bounds.x -= 2;
        bounds.y -= 2;
        bounds.height -= 4;
        bounds.width -= 4;
        bounds.x = (this.getAlignment() & 7) != 0 ? rect.x + (rect.width - bounds.width) / 2 : ((this.getAlignment() & 4) != 0 ? rect.x + rect.width - bounds.width - 2 : rect.x + 2);
        bounds.y = (this.getAlignment() & 0x30) != 0 ? rect.y + (rect.height - bounds.height) / 2 : ((this.getAlignment() & 0x20) != 0 ? rect.y + rect.height - bounds.height - 2 : rect.y + 2);
        return bounds;
    }
}

