/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid.renderers;

import java.util.HashMap;
import java.util.Map;
import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.ICellRenderer;
import org.agilemore.agilegrid.ILayoutAdvisor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractCellRenderer
implements ICellRenderer {
    protected static final Display display = Display.getCurrent();
    protected int style = 0;
    protected int alignment = 49;
    protected Color background;
    protected Color foreground;
    protected Color defaultForeground;
    protected Color defaultBackground;
    protected Font gcFont = null;
    protected Font tmpFont = null;
    protected Font font;
    protected AgileGrid agileGrid = null;
    private static GC lastGCFromExtent;
    private static Map<String, Point> stringExtentCache;

    static {
        stringExtentCache = new HashMap<String, Point>();
    }

    public AbstractCellRenderer(AgileGrid agileGrid) {
        this(agileGrid, 148);
    }

    public AbstractCellRenderer(AgileGrid agileGrid, int style) {
        this.agileGrid = agileGrid;
        this.style |= style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public int getStyle() {
        return this.style;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setForeground(Color fgcolor) {
        this.foreground = fgcolor;
    }

    public void setDefaultForeground(Color fgcolor) {
        this.defaultForeground = fgcolor;
    }

    public Color getDefaultForeground() {
        if (this.defaultForeground == null) {
            this.defaultForeground = COLOR_TEXT;
        }
        return this.defaultForeground;
    }

    public void setBackground(Color bgcolor) {
        this.background = bgcolor;
    }

    public void setDefaultBackground(Color bgcolor) {
        this.defaultBackground = bgcolor;
    }

    public Color getDefaultBackground() {
        if (this.defaultBackground == null) {
            this.defaultBackground = COLOR_BACKGROUND;
        }
        return this.defaultBackground;
    }

    public Color getForeground() {
        return this.foreground != null ? this.foreground : this.defaultForeground;
    }

    public Color getBackground() {
        return this.background != null ? this.background : this.defaultBackground;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public void setCommentIndication(boolean value) {
        this.style = value ? (this.style |= 0x80) : (this.style &= 0xFFFFFF7F);
    }

    public int getOptimalWidth(GC gc, int row, int col) {
        Object content = this.agileGrid.getContentAt(row, col);
        if (content == null) {
            return 0;
        }
        this.applyFont(gc);
        int result = 0;
        if ((this.style & 0x200) != 0) {
            ILayoutAdvisor layoutAdvisor = this.agileGrid.getLayoutAdvisor();
            String text = this.wrapText(gc, content.toString(), layoutAdvisor.getRowHeight(row) - 6);
            result = AbstractCellRenderer.getCachedStringExtent((GC)gc, (String)text).y;
            result += 6;
        } else {
            result = AbstractCellRenderer.getCachedStringExtent((GC)gc, (String)content.toString()).x;
            result += 8;
        }
        this.resetFont(gc);
        return result;
    }

    public void drawCell(GC gc, Rectangle rect, int row, int col) {
        this.applyFont(gc);
        this.drawGridLines(gc, rect, row, col);
        Rectangle leftRect = this.drawCellBorder(gc, rect, row, col);
        this.drawCellContent(gc, leftRect, row, col);
        if ((this.style & 0x80) != 0 && this.agileGrid.getLayoutAdvisor().getTooltip(row, col) != null) {
            this.drawCommentSign(gc, rect);
        }
        if (this.agileGrid.isFocusCell(row, col) && !this.agileGrid.isCellEditorActive()) {
            gc.drawFocus(rect.x, rect.y, rect.width, rect.height);
        }
        this.resetFont(gc);
    }

    protected void drawGridLines(GC gc, Rectangle rect, int row, int col) {
        Color vBorderColor = COLOR_LINE_LIGHTGRAY;
        Color hBorderColor = COLOR_LINE_LIGHTGRAY;
        if ((this.style & 0x20) != 0) {
            vBorderColor = COLOR_BGROWSELECTION;
            hBorderColor = COLOR_BGROWSELECTION;
        }
        if ((this.agileGrid.getStyle() & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            vBorderColor = COLOR_BACKGROUND;
            hBorderColor = COLOR_BACKGROUND;
        }
        this.drawDefaultCellLine(gc, rect, vBorderColor, hBorderColor);
    }

    protected Rectangle drawCellBorder(GC gc, Rectangle rect, int row, int col) {
        return rect;
    }

    protected Rectangle drawDefaultCellLine(GC gc, Rectangle rect, Color vBorderColor, Color hBorderColor) {
        int pxLine = this.agileGrid.getLinePixels();
        gc.setBackground(hBorderColor);
        gc.fillRectangle(rect.x, rect.y + rect.height, rect.width + pxLine, pxLine);
        gc.setBackground(vBorderColor);
        gc.fillRectangle(rect.x + rect.width, rect.y, pxLine, rect.height);
        return rect;
    }

    protected void applyFont(GC gc) {
        this.gcFont = gc.getFont();
        if (this.font == null) {
            this.font = display.getSystemFont();
        }
        if ((this.style & 1) != 0 || (this.style & 2) != 0) {
            FontData[] fd = this.font.getFontData();
            int s = 0;
            if ((this.style & 1) != 0) {
                s |= 1;
            }
            if ((this.style & 2) != 0) {
                s |= 2;
            }
            int i = 0;
            while (i < fd.length) {
                fd[i].setStyle(s);
                ++i;
            }
            this.tmpFont = new Font((Device)display, fd);
            gc.setFont(this.tmpFont);
        } else {
            gc.setFont(this.font);
        }
    }

    protected void resetFont(GC gc) {
        if (this.tmpFont != null) {
            this.tmpFont.dispose();
            this.tmpFont = null;
        }
        gc.setFont(this.gcFont);
    }

    protected void drawCellContent(GC gc, Rectangle rect, int row, int col) {
        this.foreground = this.getDefaultForeground();
        this.background = this.getDefaultBackground();
        this.initialColor(row, col);
        this.clearCellContentRect(gc, rect);
        this.doDrawCellContent(gc, rect, row, col);
    }

    protected void doDrawCellContent(GC gc, Rectangle rect, int row, int col) {
        Object content = this.agileGrid.getContentAt(row, col);
        if ((this.style & 0x200) != 0) {
            this.drawVerticalTextImage(gc, rect, content.toString(), null, this.foreground, this.background);
        } else {
            int alignment = this.getAlignment();
            this.drawTextImage(gc, content.toString(), alignment, null, alignment, rect.x + 3, rect.y + 2, rect.width - 6, rect.height - 4);
        }
    }

    protected void initialColor(int row, int col) {
    }

    protected void clearCellContentRect(GC gc, Rectangle rect) {
        gc.setForeground(this.foreground);
        gc.setBackground(this.background);
        gc.fillRectangle(rect);
    }

    protected void drawTextImage(GC gc, String text, int textAlign, Image image, int imageAlign, int x, int y, int width, int height) {
        Point imageSize;
        Point textSize = AbstractCellRenderer.getCachedStringExtent(gc, text);
        if (image != null) {
            Rectangle bound = image.getBounds();
            imageSize = new Point(bound.width, bound.height);
        } else {
            imageSize = new Point(0, 0);
        }
        if (image == null && (textAlign & 0xF) == 7) {
            Point p = AbstractCellRenderer.getCachedStringExtent(gc, text);
            int offset = (width - p.x) / 2;
            if (offset > 0) {
                this.drawTextVerticalAlign(gc, text, textAlign, x + offset, y, width, height);
            } else {
                this.drawTextVerticalAlign(gc, text, textAlign, x, y, width, height);
            }
            return;
        }
        if ((text == null || text.length() == 0) && (imageAlign & 0xF) == 7) {
            int offset = (width - imageSize.x) / 2;
            this.drawImageVerticalAlign(gc, image, imageAlign, x + offset, y, height);
            return;
        }
        if ((textAlign & 0xF) == 1) {
            switch (imageAlign & 0xF) {
                case 0: {
                    textSize.x = this.drawTextVerticalAlign(gc, text, textAlign, x, y, width, height);
                    break;
                }
                case 1: {
                    textSize.x = this.drawTextVerticalAlign(gc, text, textAlign, x + imageSize.x, y, width - imageSize.x, height);
                    this.drawImageVerticalAlign(gc, image, imageAlign, x, y, height);
                    break;
                }
                case 4: {
                    textSize.x = this.drawTextVerticalAlign(gc, text, textAlign, x, y, width - imageSize.x, height);
                    this.drawImageVerticalAlign(gc, image, imageAlign, x + width - imageSize.x, y, height);
                    break;
                }
                case 5: {
                    textSize.x = this.drawTextVerticalAlign(gc, text, textAlign, x, y, width - imageSize.x, height);
                    this.drawImageVerticalAlign(gc, image, imageAlign, x + textSize.x, y, height);
                    break;
                }
                case 6: {
                    textSize.x = this.drawTextVerticalAlign(gc, text, textAlign, x, y, width - imageSize.x, height);
                    int xOffset = (width - textSize.x - imageSize.x) / 2;
                    this.drawImageVerticalAlign(gc, image, imageAlign, x + textSize.x + xOffset, y, height);
                    break;
                }
                default: {
                    throw new SWTException("Unknown alignment for text: " + (imageAlign & 0xF));
                }
            }
            return;
        }
        if ((textAlign & 0xF) == 4) {
            switch (imageAlign & 0xF) {
                case 0: {
                    textSize.x = this.drawTextVerticalAlign(gc, text, textAlign, x, -1000, width, height);
                    this.drawTextVerticalAlign(gc, text, textAlign, x + width - textSize.x, y, width, height);
                    break;
                }
                case 1: {
                    textSize.x = this.drawTextVerticalAlign(gc, text, textAlign, x, -1000, width - imageSize.x, height);
                    this.drawTextVerticalAlign(gc, text, textAlign, x + width - textSize.x, y, width - imageSize.x, height);
                    this.drawImageVerticalAlign(gc, image, imageAlign, x, y, height);
                    break;
                }
                case 2: {
                    textSize.x = this.drawTextVerticalAlign(gc, text, textAlign, x, -1000, width - imageSize.x, height);
                    this.drawTextVerticalAlign(gc, text, textAlign, x + width - textSize.x, y, width - imageSize.x, height);
                    this.drawImageVerticalAlign(gc, image, imageAlign, x + width - (textSize.x + imageSize.x), y, height);
                    break;
                }
                case 3: {
                    textSize.x = this.drawTextVerticalAlign(gc, text, textAlign, x, -1000, width - imageSize.x, height);
                    this.drawTextVerticalAlign(gc, text, textAlign, x + width - textSize.x, y, width - imageSize.x, height);
                    int xOffset = (width - textSize.x - imageSize.x) / 2;
                    this.drawImageVerticalAlign(gc, image, imageAlign, x + xOffset, y, height);
                    break;
                }
                case 4: {
                    textSize.x = this.drawTextVerticalAlign(gc, text, textAlign, x, -1000, width - imageSize.x, height);
                    this.drawTextVerticalAlign(gc, text, textAlign, x + width - (textSize.x + imageSize.x), y, width - imageSize.x, height);
                    this.drawImageVerticalAlign(gc, image, imageAlign, x + width - imageSize.x, y, height);
                    break;
                }
                default: {
                    throw new SWTException("Unknown alignment for text: " + (imageAlign & 0xF));
                }
            }
        }
        throw new SWTException("Unknown alignment for text: " + (textAlign & 0xF));
    }

    protected void drawVerticalTextImage(GC gc, Rectangle rect, String text, Image img, Color textColor, Color backColor) {
        if (rect.height <= 0) {
            rect.height = 1;
        }
        if (rect.width <= 0) {
            rect.width = 1;
        }
        Image vImg = new Image((Device)display, rect.height, rect.width);
        GC gcImg = new GC((Drawable)vImg);
        this.applyFont(gcImg);
        gcImg.setForeground(textColor);
        gcImg.setBackground(backColor);
        gcImg.fillRectangle(vImg.getBounds());
        int alignment = this.mirrorAlignment();
        this.drawTextImage(gcImg, text, alignment, img, alignment, 3, 3, rect.height - 6, rect.width - 6);
        gcImg.dispose();
        Image mirrorImg = this.mirrorImage(vImg);
        vImg.dispose();
        gc.setForeground(textColor);
        gc.setBackground(backColor);
        gc.drawImage(mirrorImg, rect.x, rect.y);
        vImg.dispose();
        mirrorImg.dispose();
    }

    private int mirrorAlignment() {
        int align = this.getAlignment();
        int result = 0;
        result = (align & 0xF) == 7 ? 48 : ((align & 0xF) == 4 ? 16 : 32);
        result = (align & 0xF0) == 48 ? (result |= 7) : ((align & 0xF0) == 16 ? (result |= 4) : (result |= 1));
        return result |= 0xF00 & align;
    }

    protected Image mirrorImage(Image source) {
        Rectangle bounds = source.getBounds();
        ImageData sourceData = source.getImageData();
        ImageData resultData = new ImageData(sourceData.height, sourceData.width, sourceData.depth, sourceData.palette);
        int x = 0;
        while (x < bounds.width) {
            int y = 0;
            while (y < bounds.height) {
                resultData.setPixel(sourceData.height - y - 1, x, sourceData.getPixel(x, y));
                ++y;
            }
            ++x;
        }
        return new Image((Device)display, resultData);
    }

    protected void drawCommentSign(GC gc, Rectangle rect) {
        gc.setBackground(COLOR_COMMENTSIGN);
        gc.fillPolygon(new int[]{rect.x + rect.width - 4, rect.y, rect.x + rect.width, rect.y, rect.x + rect.width, rect.y + 4});
    }

    public int drawTextVerticalAlign(GC gc, String text, int textAlign, int x, int y, int width, int height) {
        if (text == null) {
            text = "";
        }
        if ((textAlign & 0xF00) == 2304) {
            text = this.wrapText(gc, text, width);
            text = this.cropWrappedTextForHeight(gc, text, height);
        }
        Rectangle oldClip = gc.getClipping();
        Rectangle newClip = new Rectangle(x, y, width, height);
        newClip.intersect(oldClip);
        gc.setClipping(newClip);
        Point textSize = AbstractCellRenderer.getCachedStringExtent(gc, text);
        if ((textAlign & 0xF0) == 16) {
            gc.drawText(text, x, y);
        } else if ((textAlign & 0xF0) == 32) {
            gc.drawText(text, x, y + height - textSize.y);
        } else if ((textAlign & 0xF0) == 48) {
            int yOffset = (height - textSize.y) / 2;
            gc.drawText(text, x, y + yOffset);
        } else {
            gc.drawText(text, x, y);
        }
        gc.setClipping(oldClip);
        return textSize.x;
    }

    protected String wrapText(GC gc, String text, int width) {
        Point textSize = AbstractCellRenderer.getCachedStringExtent(gc, text);
        if (textSize.x > width) {
            StringBuffer wrappedText = new StringBuffer();
            String[] lines = text.split("\n");
            int cutoffLength = width / gc.getFontMetrics().getAverageCharWidth();
            if (cutoffLength < 3) {
                return text;
            }
            int i = 0;
            while (i < lines.length) {
                int breakOffset = 0;
                while (breakOffset < lines[i].length()) {
                    String lPart = lines[i].substring(breakOffset, Math.min(breakOffset + cutoffLength, lines[i].length()));
                    Point lineSize = AbstractCellRenderer.getCachedStringExtent(gc, lPart);
                    while (lPart.length() > 0 && lineSize.x >= width) {
                        lPart = lPart.substring(0, Math.max(lPart.length() - 1, 0));
                        lineSize = AbstractCellRenderer.getCachedStringExtent(gc, lPart);
                    }
                    wrappedText.append(lPart);
                    breakOffset += lPart.length();
                    wrappedText.append('\n');
                }
                ++i;
            }
            return wrappedText.substring(0, Math.max(wrappedText.length() - 1, 0));
        }
        return text;
    }

    protected String cropWrappedTextForHeight(GC gc, String text, int height) {
        String[] lines = text.split("\n");
        int linesToTake = height / gc.getFontMetrics().getHeight();
        if (linesToTake < 1) {
            linesToTake = 1;
        }
        if (lines.length <= linesToTake) {
            return text;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < linesToTake) {
            buffer.append(lines[i]);
            buffer.append('\n');
            ++i;
        }
        return buffer.substring(0, Math.max(buffer.length() - 1, 0));
    }

    protected void drawImageVerticalAlign(GC gc, Image image, int imageAlign, int x, int y, int height) {
        if (image == null) {
            return;
        }
        Rectangle imageBounds = image.getBounds();
        Point imageSize = new Point(imageBounds.width, imageBounds.height);
        if ((imageAlign & 0xF0) == 16) {
            gc.drawImage(image, x, y);
            return;
        }
        if ((imageAlign & 0xF0) == 32) {
            gc.drawImage(image, x, y + height - imageSize.y);
            return;
        }
        if ((imageAlign & 0xF0) == 48) {
            int yOffset = (height - imageSize.y) / 2;
            gc.drawImage(image, x, y + yOffset);
            return;
        }
        throw new SWTException("Unknown alignment for image: " + (imageAlign & 0xF0));
    }

    protected void drawShadowImage(GC gc, Image image, int x, int y, int alpha) {
        Rectangle imageBounds = image.getBounds();
        Point imageSize = new Point(imageBounds.width, imageBounds.height);
        ImageData imgData = new ImageData(imageSize.x, imageSize.y, 24, new PaletteData(255, 255, 255));
        imgData.alpha = alpha;
        Image img = new Image((Device)display, imgData);
        GC imgGC = new GC((Drawable)img);
        imgGC.drawImage(image, 0, 0);
        gc.drawImage(img, x, y);
        imgGC.dispose();
        img.dispose();
    }

    public static synchronized Point getCachedStringExtent(GC gc, String text) {
        Point p;
        if (lastGCFromExtent != gc) {
            stringExtentCache.clear();
            lastGCFromExtent = gc;
        }
        if ((p = stringExtentCache.get(text)) == null) {
            if (text == null) {
                return new Point(0, 0);
            }
            p = gc.textExtent(text);
            stringExtentCache.put(text, p);
        }
        return new Point(p.x, p.y);
    }
}

