/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.annotations;

import java.lang.reflect.Method;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.reviews.ui.annotations.ReviewAnnotationModel;
import org.eclipse.mylyn.internal.reviews.ui.annotations.ReviewCompareInputListener;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.ITopic;
import org.eclipse.swt.widgets.Display;

public class ReviewCompareAnnotationModel {
    final ReviewAnnotationModel leftAnnotationModel;
    private final ReviewAnnotationModel rightAnnotationModel;
    private ReviewCompareInputListener leftViewerListener;
    private ReviewCompareInputListener rightViewerListener;
    private final ITopic commentToFocus;
    private TextMergeViewer fMergeViewer;
    private MergeSourceViewer fRightSourceViewer;
    private MergeSourceViewer fLeftSourceViewer;

    static SourceViewer getSourceViewer(MergeSourceViewer sourceViewer) {
        if (SourceViewer.class.isInstance(sourceViewer)) {
            return (SourceViewer)SourceViewer.class.cast(sourceViewer);
        }
        try {
            Method getSourceViewerRefl = MergeSourceViewer.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            getSourceViewerRefl.setAccessible(true);
            Object returnValue = getSourceViewerRefl.invoke((Object)sourceViewer, new Object[0]);
            if (returnValue instanceof SourceViewer) {
                return (SourceViewer)returnValue;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public ReviewCompareAnnotationModel(IFileItem crucibleFile, ITopic commentToFocus) {
        this.leftAnnotationModel = new ReviewAnnotationModel(null, null, null, crucibleFile, crucibleFile.getBase());
        this.rightAnnotationModel = new ReviewAnnotationModel(null, null, null, crucibleFile, crucibleFile.getTarget());
        this.commentToFocus = commentToFocus;
    }

    public void attachToViewer(TextMergeViewer viewer, MergeSourceViewer fLeft, MergeSourceViewer fRight) {
        this.fMergeViewer = viewer;
        this.fLeftSourceViewer = fLeft;
        this.fRightSourceViewer = fRight;
        if (!this.isListenerFor(this.leftViewerListener, fLeft, this.leftAnnotationModel)) {
            this.leftViewerListener = this.addTextInputListener(fLeft, this.leftAnnotationModel, false);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        ReviewCompareAnnotationModel.this.leftViewerListener.forceCustomAnnotationHover();
                    }
                    catch (Exception e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Error attaching annotation hover", (Throwable)e));
                    }
                }
            });
        }
        if (!this.isListenerFor(this.rightViewerListener, fRight, this.rightAnnotationModel)) {
            this.rightViewerListener = this.addTextInputListener(fRight, this.rightAnnotationModel, true);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    try {
                        ReviewCompareAnnotationModel.this.rightViewerListener.forceCustomAnnotationHover();
                    }
                    catch (Exception e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Error attaching annotation hover", (Throwable)e));
                    }
                }
            });
        }
    }

    private boolean isListenerFor(ReviewCompareInputListener listener, MergeSourceViewer viewer, ReviewAnnotationModel annotationModel) {
        if (listener == null) {
            return false;
        }
        return listener.isListenerFor(viewer, annotationModel);
    }

    private ReviewCompareInputListener addTextInputListener(MergeSourceViewer sourceViewer, ReviewAnnotationModel crucibleAnnotationModel, boolean oldFile) {
        ReviewCompareInputListener listener = new ReviewCompareInputListener(sourceViewer, crucibleAnnotationModel, oldFile);
        SourceViewer viewer = ReviewCompareAnnotationModel.getSourceViewer(sourceViewer);
        if (viewer != null) {
            viewer.addTextInputListener((ITextInputListener)listener);
        }
        return listener;
    }

    public void focusOnComment() {
        this.focusOnComment(this.commentToFocus);
    }

    public void focusOnComment(ITopic commentToFocus) {
    }

    private void setActiveViewer(MergeSourceViewer focusViewer) {
        try {
            Method setActiveViewer = TextMergeViewer.class.getDeclaredMethod("setActiveViewer", MergeSourceViewer.class, Boolean.TYPE);
            setActiveViewer.setAccessible(true);
            setActiveViewer.invoke((Object)this.fMergeViewer, focusViewer, true);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.reviews.ui", "Failed to activate viewer", (Throwable)e));
        }
    }

    public void registerContextMenu() {
        this.rightViewerListener.registerContextMenu();
        this.leftViewerListener.registerContextMenu();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.leftAnnotationModel == null ? 0 : this.leftAnnotationModel.hashCode());
        result = 31 * result + (this.rightAnnotationModel == null ? 0 : this.rightAnnotationModel.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReviewCompareAnnotationModel other = (ReviewCompareAnnotationModel)obj;
        if (this.leftAnnotationModel == null ? other.leftAnnotationModel != null : !this.leftAnnotationModel.equals(other.leftAnnotationModel)) {
            return false;
        }
        return !(this.rightAnnotationModel == null ? other.rightAnnotationModel != null : !this.rightAnnotationModel.equals(other.rightAnnotationModel));
    }
}

