/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.annotations;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationHoverExtension2;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.ISourceViewerExtension2;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.AnnotationBag;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotation;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotationHoverInput;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentInformationControlCreator;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentPopupDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentAnnotationHover
implements IAnnotationHover,
IAnnotationHoverExtension,
IAnnotationHoverExtension2 {
    private final IAnnotationHover parentHover;
    private final IInformationControlCreator informationControlCreator;
    private static ISourceViewer currentSourceViewer;
    private static CommentAnnotationHover currentAnnotationHover;

    public CommentAnnotationHover(IAnnotationHover hover) {
        this.parentHover = hover;
        this.informationControlCreator = new CommentInformationControlCreator();
    }

    public void dispose() {
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List<CommentAnnotation> commentAnnotations = this.getCrucibleAnnotationsForLine(sourceViewer, lineNumber);
        if (commentAnnotations != null && commentAnnotations.size() > 0) {
            if (commentAnnotations.size() == 1) {
                CommentAnnotation annotation = commentAnnotations.get(0);
                String message = annotation.getText();
                if (message != null && message.trim().length() > 0) {
                    return this.formatSingleMessage(message);
                }
            } else {
                ArrayList<String> messages = new ArrayList<String>();
                for (CommentAnnotation annotation : commentAnnotations) {
                    String message = annotation.getText();
                    if (message == null || message.trim().length() <= 0) continue;
                    messages.add(message.trim());
                }
                if (messages.size() == 1) {
                    return this.formatSingleMessage((String)messages.get(0));
                }
                if (messages.size() > 1) {
                    return this.formatMultipleMessages(messages);
                }
            }
        } else if (this.parentHover != null) {
            return this.parentHover.getHoverInfo(sourceViewer, lineNumber);
        }
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        return this.informationControlCreator;
    }

    public boolean canHandleMouseCursor() {
        return true;
    }

    public boolean canHandleMouseWheel() {
        return true;
    }

    public Object getHoverInfo(ISourceViewer sourceViewer, ILineRange lineRange, int visibleNumberOfLines) {
        List<CommentAnnotation> annotationsForLine = this.getCrucibleAnnotationsForLine(sourceViewer, lineRange.getStartLine());
        if (annotationsForLine == null || annotationsForLine.size() == 0) {
            return this.getHoverInfo(sourceViewer, lineRange.getStartLine());
        }
        return new CommentAnnotationHoverInput(annotationsForLine);
    }

    public ILineRange getHoverLineRange(ISourceViewer viewer, int lineNumber) {
        currentAnnotationHover = this;
        currentSourceViewer = viewer;
        List<CommentAnnotation> commentAnnotations = this.getCrucibleAnnotationsForLine(viewer, lineNumber);
        if (commentAnnotations != null && commentAnnotations.size() > 0) {
            IDocument document = viewer.getDocument();
            int lowestStart = Integer.MAX_VALUE;
            int highestEnd = 0;
            for (Annotation annotation : commentAnnotations) {
                if (!(annotation instanceof CommentAnnotation)) continue;
                Position p = ((CommentAnnotation)annotation).getPosition();
                try {
                    int start = document.getLineOfOffset(p.offset);
                    int end = document.getLineOfOffset(p.offset + p.length);
                    if (start < lowestStart) {
                        lowestStart = start;
                    }
                    if (end <= highestEnd) continue;
                    highestEnd = end;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (lowestStart != Integer.MAX_VALUE) {
                return new LineRange(lowestStart, highestEnd - lowestStart);
            }
            return new LineRange(lineNumber, 1);
        }
        return new LineRange(lineNumber, 1);
    }

    protected String formatSingleMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog((StringBuffer)buffer);
        HTMLPrinter.addParagraph((StringBuffer)buffer, (String)HTMLPrinter.convertToHTMLContent((String)message));
        HTMLPrinter.addPageEpilog((StringBuffer)buffer);
        return buffer.toString();
    }

    protected String formatMultipleMessages(List<String> messages) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.addPageProlog((StringBuffer)buffer);
        HTMLPrinter.addParagraph((StringBuffer)buffer, (String)HTMLPrinter.convertToHTMLContent((String)"There are multiple comments on this line"));
        HTMLPrinter.startBulletList((StringBuffer)buffer);
        for (String message : messages) {
            HTMLPrinter.addBullet((StringBuffer)buffer, (String)HTMLPrinter.convertToHTMLContent((String)message));
        }
        HTMLPrinter.endBulletList((StringBuffer)buffer);
        HTMLPrinter.addPageEpilog((StringBuffer)buffer);
        return buffer.toString();
    }

    private boolean isRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                return line == document.getLineOfOffset(position.getOffset());
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    private IAnnotationModel getAnnotationModel(ISourceViewer viewer) {
        if (viewer instanceof ISourceViewerExtension2) {
            ISourceViewerExtension2 extension = (ISourceViewerExtension2)viewer;
            return extension.getVisualAnnotationModel();
        }
        return viewer.getAnnotationModel();
    }

    private boolean includeAnnotation(Annotation annotation, Position position, List<CommentAnnotation> annotations) {
        if (!(annotation instanceof CommentAnnotation)) {
            return false;
        }
        return annotation != null && !annotations.contains(annotation);
    }

    private List<CommentAnnotation> getCrucibleAnnotationsForLine(ISourceViewer viewer, int line) {
        IAnnotationModel model = this.getAnnotationModel(viewer);
        if (model == null) {
            return null;
        }
        IDocument document = viewer.getDocument();
        ArrayList<CommentAnnotation> commentAnnotations = new ArrayList<CommentAnnotation>();
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            Annotation annotation2 = (Annotation)iterator.next();
            Position position = model.getPosition(annotation2);
            if (position == null || !this.isRulerLine(position, document, line)) continue;
            if (annotation2 instanceof AnnotationBag) {
                AnnotationBag bag = (AnnotationBag)annotation2;
                for (Annotation annotation2 : bag) {
                    position = model.getPosition(annotation2);
                    if (position == null || !this.includeAnnotation(annotation2, position, commentAnnotations) || !(annotation2 instanceof CommentAnnotation)) continue;
                    commentAnnotations.add((CommentAnnotation)annotation2);
                }
                continue;
            }
            if (!this.includeAnnotation(annotation2, position, commentAnnotations) || !(annotation2 instanceof CommentAnnotation)) continue;
            commentAnnotations.add((CommentAnnotation)annotation2);
        }
        return commentAnnotations;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean makeAnnotationHoverFocusable() {
        if (currentSourceViewer == null || currentSourceViewer.getTextWidget().isDisposed() || currentAnnotationHover == null) {
            return false;
        }
        CompositeRuler info = null;
        try {
            Method declaredMethod2 = SourceViewer.class.getDeclaredMethod("getVerticalRuler", new Class[0]);
            declaredMethod2.setAccessible(true);
            info = (CompositeRuler)declaredMethod2.invoke((Object)currentSourceViewer, new Object[0]);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Error getting CompareEditor's vertical ruler. ", (Throwable)e));
        }
        if (info == null) {
            return false;
        }
        int line = info.getLineOfLastMouseButtonActivity();
        if (line == -1) {
            return false;
        }
        try {
            Object hoverInfo;
            if (currentAnnotationHover instanceof IAnnotationHoverExtension) {
                CommentAnnotationHover extension = currentAnnotationHover;
                ILineRange hoverLineRange = extension.getHoverLineRange(currentSourceViewer, line);
                if (hoverLineRange == null) {
                    return false;
                }
                hoverInfo = extension.getHoverInfo(currentSourceViewer, hoverLineRange, Integer.MAX_VALUE);
            } else {
                hoverInfo = currentAnnotationHover.getHoverInfo(currentSourceViewer, line);
            }
            IDocument document = currentSourceViewer.getDocument();
            int offset = document.getLineOffset(line);
            String partitioning = new TextSourceViewerConfiguration().getConfiguredDocumentPartitioning(currentSourceViewer);
            String contentType = TextUtilities.getContentType((IDocument)document, (String)partitioning, (int)offset, (boolean)true);
            IInformationControlCreator controlCreator = null;
            if (currentAnnotationHover instanceof IInformationProviderExtension2) {
                IInformationProviderExtension2 provider = (IInformationProviderExtension2)currentAnnotationHover;
                controlCreator = provider.getInformationPresenterControlCreator();
            } else if (currentAnnotationHover instanceof IAnnotationHoverExtension) {
                controlCreator = currentAnnotationHover.getHoverControlCreator();
            }
            InformationProvider informationProvider = new InformationProvider((IRegion)new Region(offset, 0), hoverInfo, controlCreator);
            CommentPopupDialog dialog = CommentPopupDialog.getCurrentPopupDialog();
            if (dialog == null) return false;
            InformationPresenter fInformationPresenter = dialog.getInformationControl().getInformationPresenter();
            fInformationPresenter.setSizeConstraints(100, 12, true, true);
            fInformationPresenter.install((ITextViewer)currentSourceViewer);
            fInformationPresenter.setDocumentPartitioning(partitioning);
            fInformationPresenter.setOffset(offset);
            fInformationPresenter.setAnchor(AbstractInformationControlManager.ANCHOR_RIGHT);
            fInformationPresenter.setMargins(4, 0);
            fInformationPresenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
            fInformationPresenter.showInformation();
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command showInfoCommand = commandService.getCommand("org.eclipse.ui.edit.text.showInformation");
            showInfoCommand.setHandler(null);
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static final class InformationProvider
    implements IInformationProvider,
    IInformationProviderExtension,
    IInformationProviderExtension2 {
        private final IRegion fHoverRegion;
        private final Object fHoverInfo;
        private final IInformationControlCreator fControlCreator;

        InformationProvider(IRegion hoverRegion, Object hoverInfo, IInformationControlCreator controlCreator) {
            this.fHoverRegion = hoverRegion;
            this.fHoverInfo = hoverInfo;
            this.fControlCreator = controlCreator;
        }

        public IRegion getSubject(ITextViewer textViewer, int invocationOffset) {
            return this.fHoverRegion;
        }

        @Deprecated
        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return this.fHoverInfo.toString();
        }

        public Object getInformation2(ITextViewer textViewer, IRegion subject) {
            return this.fHoverInfo;
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return this.fControlCreator;
        }
    }
}

