/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.provisional.commons.ui.WorkbenchUtil;
import org.eclipse.mylyn.internal.reviews.ui.ReviewUiUtil;
import org.eclipse.mylyn.internal.reviews.ui.actions.AbstractReviewAction;
import org.eclipse.mylyn.internal.reviews.ui.annotations.IReviewCompareSourceViewer;
import org.eclipse.mylyn.internal.reviews.ui.dialogs.AddCommentDialog;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILineRange;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsFactory;
import org.eclipse.mylyn.reviews.ui.ReviewUi;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class AddLineCommentToFileAction
extends AbstractReviewAction {
    private IReviewCompareSourceViewer compareSourceViewer;
    private IEditorInput editorInput;
    private LineRange selectedRange;
    private IFileItem item;

    public AddLineCommentToFileAction() {
        super("Add Comment...");
    }

    public AddLineCommentToFileAction(IReviewCompareSourceViewer compareSourceViewer, IFileItem item) {
        this();
        this.compareSourceViewer = compareSourceViewer;
        this.item = item;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        this.editorInput = this.getEditorInputFromSelection(selection);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (this.compareSourceViewer != null) {
            this.selectedRange = this.compareSourceViewer.getSelection();
            if (this.selectedRange != null) {
                return true;
            }
        }
        return false;
    }

    private LineRange getJavaEditorSelection(IEditorInput editorInput) {
        LineRange lines = null;
        IEditorPart editorPart = this.getActiveEditor();
        if (editorPart != null && editorInput != null && (lines = ReviewUiUtil.getSelectedLineNumberRangeFromEditorInput(editorPart, editorInput)) == null) {
            StatusHandler.log((IStatus)new Status(1, "org.eclipse.mylyn.reviews.ui", "Editor is not an ITextEditor or there's no text selection available."));
        }
        return lines;
    }

    public String getToolTipText() {
        return "Adds a Review Comment For the Selected Line";
    }

    protected LineRange getSelectedRange() {
        if (this.compareSourceViewer != null) {
            return this.compareSourceViewer.getSelection();
        }
        return this.getJavaEditorSelection(this.getEditorInput());
    }

    protected IEditorInput getEditorInput() {
        return this.editorInput;
    }

    public ILocation getLocation() {
        LineRange selectedRange = this.getSelectedRange();
        ILineLocation location = ReviewsFactory.eINSTANCE.createLineLocation();
        ILineRange range = ReviewsFactory.eINSTANCE.createLineRange();
        range.setStart(selectedRange.getStartLine());
        range.setEnd(selectedRange.getStartLine() + selectedRange.getNumberOfLines());
        location.getRanges().add(range);
        return location;
    }

    public void run(IAction action) {
        AddCommentDialog dialog = new AddCommentDialog(WorkbenchUtil.getShell(), ReviewUi.getActiveReview(), (IReviewItem)this.item, this.getLocation());
        dialog.open();
    }
}

