/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.editor;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.mylyn.internal.gerrit.core.GerritTaskSchema;
import org.eclipse.mylyn.internal.gerrit.ui.editor.PatchSetSection;
import org.eclipse.mylyn.internal.gerrit.ui.editor.ReviewSection;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.ui.editors.AbstractAttributeEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPage;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorPart;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.LayoutHint;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorPartDescriptor;
import org.eclipse.ui.services.IServiceLocator;

public class GerritTaskEditorPage
extends AbstractTaskEditorPage {
    public GerritTaskEditorPage(TaskEditor editor) {
        super(editor, "org.eclipse.mylyn.gerrit");
        this.setNeedsPrivateSection(true);
        this.setNeedsSubmitButton(false);
    }

    protected AttributeEditorFactory createAttributeEditorFactory() {
        return new AttributeEditorFactory(this.getModel(), this.getTaskRepository(), (IServiceLocator)this.getEditorSite()){

            public AbstractAttributeEditor createEditor(String type, TaskAttribute taskAttribute) {
                if (taskAttribute.getId().equals(GerritTaskSchema.getDefault().CHANGE_ID.getKey())) {
                    AbstractAttributeEditor editor = super.createEditor(type, taskAttribute);
                    editor.setLayoutHint(new LayoutHint(LayoutHint.RowSpan.SINGLE, LayoutHint.ColumnSpan.MULTIPLE));
                    return editor;
                }
                return super.createEditor(type, taskAttribute);
            }
        };
    }

    protected Set<TaskEditorPartDescriptor> createPartDescriptors() {
        Set descriptors = super.createPartDescriptors();
        Iterator it = descriptors.iterator();
        while (it.hasNext()) {
            TaskEditorPartDescriptor descriptor = (TaskEditorPartDescriptor)it.next();
            if ("actions".equals(descriptor.getPath())) {
                it.remove();
            }
            if (!"people".equals(descriptor.getPath())) continue;
            it.remove();
        }
        descriptors.add(new TaskEditorPartDescriptor(ReviewSection.class.getName()){

            public AbstractTaskEditorPart createPart() {
                return new ReviewSection();
            }
        });
        descriptors.add(new TaskEditorPartDescriptor(PatchSetSection.class.getName()){

            public AbstractTaskEditorPart createPart() {
                return new PatchSetSection();
            }
        });
        return descriptors;
    }
}

