/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui;

import com.google.gerrit.reviewdb.Patch;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.gerrit.core.GerritOperationFactory;
import org.eclipse.mylyn.internal.gerrit.core.operations.GerritOperation;
import org.eclipse.mylyn.internal.gerrit.core.operations.SaveDraftRequest;
import org.eclipse.mylyn.internal.gerrit.ui.GerritUiPlugin;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ITopic;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.tasks.core.ITask;

public class GerritReviewBehavior
extends ReviewBehavior {
    private final IFileItem fileItem;

    public GerritReviewBehavior(ITask task, IFileItem fileItem) {
        super(task);
        this.fileItem = fileItem;
    }

    public GerritOperationFactory getOperationFactory() {
        return GerritUiPlugin.getDefault().getOperationFactory();
    }

    public IStatus addTopic(ITopic topic, IProgressMonitor monitor) {
        Patch.Key key = Patch.Key.parse((String)this.fileItem.getId());
        short side = topic.getItem() == this.fileItem.getBase() ? (short)0 : 1;
        SaveDraftRequest request = new SaveDraftRequest(key, ((ILineLocation)topic.getLocation()).getTotalMin(), side);
        request.setMessage(topic.getDescription());
        GerritOperation operation = this.getOperationFactory().createSaveDraftOperation(this.getTask(), request);
        return operation.run(monitor);
    }
}

