/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritSystemInfo;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class GerritRepositorySettingsPage
extends AbstractRepositorySettingsPage {
    private Label statusLabel;

    public GerritRepositorySettingsPage(TaskRepository taskRepository) {
        super("Gerrit Repository Settings", "Web based code review and project management for Git based projects.", taskRepository);
        this.setNeedsAnonymousLogin(true);
        this.setNeedsHttpAuth(false);
        this.setNeedsAdvanced(false);
        this.setNeedsEncoding(false);
        this.setNeedsTimeZone(false);
        this.setNeedsValidation(true);
    }

    public void applyTo(TaskRepository repository) {
        super.applyTo(repository);
        repository.setProperty("category", "org.eclipse.mylyn.category.review");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.addRepositoryTemplatesToServerUrlCombo();
    }

    protected void applyValidatorResult(AbstractRepositorySettingsPage.Validator validator) {
        super.applyValidatorResult(validator);
        if (validator.getStatus() != null && validator.getStatus().isOK()) {
            GerritValidator gerritValidator = (GerritValidator)validator;
            this.statusLabel.setText(NLS.bind((String)"Logged in as {0}.", (Object)gerritValidator.getInfo().getFullName()));
        } else {
            this.statusLabel.setText(" ");
        }
        this.statusLabel.getParent().layout();
    }

    protected void createContributionControls(Composite parent) {
        this.statusLabel = new Label(parent, 64);
        this.statusLabel.setText(" ");
        GridDataFactory.fillDefaults().indent(0, 10).grab(true, false).span(3, -1).applyTo((Control)this.statusLabel);
    }

    protected void createAdditionalControls(Composite parent) {
    }

    protected void repositoryTemplateSelected(RepositoryTemplate template) {
        this.repositoryLabelEditor.setStringValue(template.label);
        this.setUrl(template.repositoryUrl);
        this.getContainer().updateButtons();
    }

    public String getConnectorKind() {
        return "org.eclipse.mylyn.gerrit";
    }

    protected AbstractRepositorySettingsPage.Validator getValidator(TaskRepository repository) {
        return new GerritValidator(repository);
    }

    protected boolean isValidUrl(String url) {
        if (url.startsWith("https://") || url.startsWith("http://")) {
            try {
                new URL(url);
                return true;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return false;
    }

    public class GerritValidator
    extends AbstractRepositorySettingsPage.Validator {
        final TaskRepository repository;
        private GerritSystemInfo info;

        public GerritValidator(TaskRepository repository) {
            super((AbstractRepositorySettingsPage)GerritRepositorySettingsPage.this);
            this.repository = repository;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            GerritConnector connector = (GerritConnector)GerritRepositorySettingsPage.this.getConnector();
            this.info = connector.validate(this.repository, monitor);
        }

        public GerritSystemInfo getInfo() {
            return this.info;
        }
    }
}

