/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.egit;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;

public class GerritProjectToGitRepositoryMapping {
    private final String gerritHostName;
    private final String gerritProjectName;

    public GerritProjectToGitRepositoryMapping(String gerritHostName, String gerritProjectName) {
        this.gerritHostName = gerritHostName;
        this.gerritProjectName = gerritProjectName;
    }

    public Repository findRepository() throws IOException {
        RepositoryUtil repoUtil = this.getRepositoryUtil();
        RepositoryCache repoCache = this.getRepositoryCache();
        for (String dirs : repoUtil.getConfiguredRepositories()) {
            Repository repo = repoCache.lookupRepository(new File(dirs));
            if (!this.isMatchingRepository(repo)) continue;
            return repo;
        }
        return null;
    }

    RepositoryUtil getRepositoryUtil() {
        Activator egit = Activator.getDefault();
        return egit.getRepositoryUtil();
    }

    RepositoryCache getRepositoryCache() {
        Activator egit = Activator.getDefault();
        return egit.getRepositoryCache();
    }

    private boolean isMatchingRepository(Repository repo) {
        List remotes;
        try {
            remotes = RemoteConfig.getAllRemoteConfigs((Config)repo.getConfig());
        }
        catch (URISyntaxException e) {
            GerritCorePlugin.logWarning("Invalid URI in remote configuration", e);
            return false;
        }
        for (RemoteConfig remote : remotes) {
            if (!this.isMatchingRemoteConfig(remote)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchingRemoteConfig(RemoteConfig remoteConfig) {
        List remoteUris = remoteConfig.getURIs();
        return !remoteUris.isEmpty() && this.isMatchingUri((URIish)remoteUris.get(0));
    }

    private boolean isMatchingUri(URIish uri) {
        String host = uri.getHost();
        return this.gerritHostName.equalsIgnoreCase(host) && this.gerritProjectName.equals(GerritProjectToGitRepositoryMapping.calcProjectNameFromUri(uri));
    }

    static String calcProjectNameFromUri(URIish uri) {
        String path = uri.getPath();
        path = GerritProjectToGitRepositoryMapping.cleanTrailingDotGit(path);
        if (GerritProjectToGitRepositoryMapping.isHttpUri(uri)) {
            path = GerritProjectToGitRepositoryMapping.cleanGerritHttpPrefix(path);
        }
        return GerritProjectToGitRepositoryMapping.cleanLeadingSlash(path);
    }

    private static String cleanTrailingDotGit(String path) {
        int dotGitIndex = path.lastIndexOf(".git");
        if (dotGitIndex >= 0) {
            return path.substring(0, dotGitIndex);
        }
        return path;
    }

    private static boolean isHttpUri(URIish fetchUri) {
        return fetchUri.getScheme().toLowerCase().startsWith("http");
    }

    private static String cleanGerritHttpPrefix(String path) {
        String httpPathPrefix = "/p/";
        int httpPathPrefixIndex = path.indexOf(httpPathPrefix);
        if (httpPathPrefixIndex >= 0) {
            return path.substring(httpPathPrefixIndex + httpPathPrefix.length());
        }
        return path;
    }

    private static String cleanLeadingSlash(String path) {
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }
}

