/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwtjsonrpc.client.RemoteJsonService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpClient;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;

public class GerritService
implements InvocationHandler {
    private final String uri;
    protected GerritHttpClient client;

    public static <T extends RemoteJsonService> T create(Class<T> serviceClass, GerritHttpClient gerritHttpClient) {
        GerritService handler = new GerritService(gerritHttpClient, "/gerrit/rpc/" + serviceClass.getSimpleName());
        return (T)((RemoteJsonService)serviceClass.cast(Proxy.newProxyInstance(GerritService.class.getClassLoader(), new Class[]{serviceClass}, (InvocationHandler)handler)));
    }

    public GerritService(GerritHttpClient client, String uri) {
        this.client = client;
        this.uri = uri;
    }

    public String getServiceUri() {
        return this.uri;
    }

    @Override
    public Object invoke(Object proxy, final Method method, Object[] args) {
        final JSonSupport json = new JSonSupport();
        final ArrayList<Object> parameters = new ArrayList<Object>(args.length - 1);
        int i = 0;
        while (i < args.length - 1) {
            parameters.add(args[i]);
            ++i;
        }
        AsyncCallback callback = (AsyncCallback)args[args.length - 1];
        try {
            GerritRequest request = GerritRequest.getCurrentRequest();
            IProgressMonitor monitor = request != null ? request.getMonitor() : null;
            String responseMessage = this.client.postJsonRequest(this.getServiceUri(), new GerritHttpClient.JsonEntity(){

                @Override
                public String getContent() {
                    return json.createRequest(GerritService.this.client.getId(), GerritService.this.client.getXsrfKey(), method.getName(), parameters);
                }
            }, monitor);
            Type[] types = method.getGenericParameterTypes();
            Type resultType = ((ParameterizedType)types[types.length - 1]).getActualTypeArguments()[0];
            Object result = json.parseResponse(responseMessage, resultType);
            callback.onSuccess(result);
        }
        catch (Throwable e) {
            callback.onFailure(e);
        }
        return null;
    }

    public static class GerritRequest {
        private static ThreadLocal<GerritRequest> currentRequest = new ThreadLocal();
        private final IProgressMonitor monitor;

        public static GerritRequest getCurrentRequest() {
            return currentRequest.get();
        }

        public static void setCurrentRequest(GerritRequest request) {
            currentRequest.set(request);
        }

        public GerritRequest(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public IProgressMonitor getMonitor() {
            return this.monitor;
        }
    }
}

