/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.gerrit.common.data.AccountDashboardInfo;
import com.google.gerrit.common.data.AccountInfoCache;
import com.google.gerrit.common.data.AccountService;
import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.ChangeInfo;
import com.google.gerrit.common.data.ChangeListService;
import com.google.gerrit.common.data.ChangeManageService;
import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.common.data.PatchDetailService;
import com.google.gerrit.common.data.PatchScript;
import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.common.data.PatchSetPublishDetail;
import com.google.gerrit.common.data.ReviewerResult;
import com.google.gerrit.common.data.SingleListChangeInfo;
import com.google.gerrit.common.data.SystemInfoService;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.AccountDiffPreference;
import com.google.gerrit.reviewdb.ApprovalCategoryValue;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.ContributorAgreement;
import com.google.gerrit.reviewdb.Patch;
import com.google.gerrit.reviewdb.PatchLineComment;
import com.google.gerrit.reviewdb.PatchSet;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwtjsonrpc.client.RemoteJsonService;
import com.google.gwtjsonrpc.client.VoidResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.html.HTML;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.HtmlStreamTokenizer;
import org.eclipse.mylyn.commons.net.HtmlTag;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritPatchSetContent;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritService;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritSystemInfo;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ChangeDetailService;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileRevision;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.ILineRange;
import org.eclipse.mylyn.reviews.core.model.ILocation;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.core.model.ITopic;
import org.eclipse.mylyn.reviews.core.model.IUser;
import org.eclipse.mylyn.reviews.internal.core.model.ReviewsFactory;
import org.eclipse.osgi.util.NLS;

public class GerritClient {
    private static final ReviewsFactory FACTORY = ReviewsFactory.eINSTANCE;
    private final GerritHttpClient client;
    private volatile GerritConfig config;
    private Account myAcount;
    private AccountDiffPreference myDiffPreference;
    private final Map<Class<? extends RemoteJsonService>, RemoteJsonService> serviceByClass;
    private volatile boolean configRefreshed;

    public static GerritConfig configFromString(String token) {
        try {
            JSonSupport support = new JSonSupport();
            return (GerritConfig)support.getGson().fromJson(token, GerritConfig.class);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", "Failed to deserialize configration: '" + token + "'", (Throwable)e));
            return null;
        }
    }

    public static String configToString(GerritConfig config) {
        try {
            JSonSupport support = new JSonSupport();
            return support.getGson().toJson((Object)config);
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.core", "Failed to serialize configration", (Throwable)e));
            return null;
        }
    }

    private static String getText(HtmlStreamTokenizer tokenizer) throws IOException, ParseException {
        StringBuilder sb = new StringBuilder();
        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
            if (token.getType() == HtmlStreamTokenizer.Token.TEXT) {
                sb.append(token.toString());
            } else if (token.getType() != HtmlStreamTokenizer.Token.COMMENT) break;
            token = tokenizer.nextToken();
        }
        return StringEscapeUtils.unescapeHtml((String)sb.toString());
    }

    public GerritClient(AbstractWebLocation location) {
        this(location, null);
    }

    public GerritClient(AbstractWebLocation location, GerritConfig config) {
        this.client = new GerritHttpClient(location);
        this.serviceByClass = new HashMap<Class<? extends RemoteJsonService>, RemoteJsonService>();
        this.config = config;
    }

    public PatchLineComment saveDraft(Patch.Key patchKey, String message, int line, short side, String parentUuid, IProgressMonitor monitor) throws GerritException {
        PatchLineComment.Key id = new PatchLineComment.Key(patchKey, null);
        final PatchLineComment comment = new PatchLineComment(id, line, this.getAccount(monitor).getId(), parentUuid);
        comment.setMessage(message);
        comment.setSide(side);
        return this.execute(monitor, new Operation<PatchLineComment>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getPatchDetailService().saveDraft(comment, (AsyncCallback)this);
            }
        });
    }

    public ChangeDetail abondon(String reviewId, int patchSetId, final String message, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        return this.execute(monitor, new Operation<ChangeDetail>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getChangeManageService().abandonChange(id, message, (AsyncCallback)this);
            }
        });
    }

    public ChangeDetail getChangeDetail(int reviewId, IProgressMonitor monitor) throws GerritException {
        final Change.Id id = new Change.Id(reviewId);
        return this.execute(monitor, new Operation<ChangeDetail>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getChangeDetailService().changeDetail(id, this);
            }
        });
    }

    public GerritPatchSetContent getPatchSetContent(String reviewId, int patchSetId, IProgressMonitor monitor) throws GerritException {
        HashMap<Patch.Key, PatchScript> patchScriptByPatchKey = new HashMap<Patch.Key, PatchScript>();
        Change.Id changeId = new Change.Id(this.id(reviewId));
        PatchSetDetail detail = this.getPatchSetDetail(changeId, patchSetId, monitor);
        for (Patch patch : detail.getPatches()) {
            PatchScript patchScript = this.getPatchScript(patch.getKey(), null, detail.getPatchSet().getId(), monitor);
            if (patchScript == null) continue;
            patchScriptByPatchKey.put(patch.getKey(), patchScript);
        }
        GerritPatchSetContent result = new GerritPatchSetContent();
        result.setPatchScriptByPatchKey(patchScriptByPatchKey);
        return result;
    }

    public GerritConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountDiffPreference getDiffPreference(IProgressMonitor monitor) throws GerritException {
        GerritClient gerritClient = this;
        synchronized (gerritClient) {
            if (this.myDiffPreference != null) {
                return this.myDiffPreference;
            }
        }
        AccountDiffPreference diffPreference = this.execute(monitor, new Operation<AccountDiffPreference>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getAccountService().myDiffPreferences((AsyncCallback)this);
            }
        });
        GerritClient gerritClient2 = this;
        synchronized (gerritClient2) {
            this.myDiffPreference = diffPreference;
        }
        return this.myDiffPreference;
    }

    public GerritSystemInfo getInfo(IProgressMonitor monitor) throws GerritException {
        List<ContributorAgreement> contributorAgreements = null;
        Account account = null;
        if (!this.isAnonymous()) {
            account = this.execute(monitor, new Operation<Account>(){

                @Override
                public void execute(IProgressMonitor monitor) throws GerritException {
                    GerritClient.this.getAccountService().myAccount((AsyncCallback)this);
                }
            });
        } else {
            this.executeQuery(monitor, "status:open");
        }
        this.refreshConfigOnce(monitor);
        return new GerritSystemInfo(contributorAgreements, account);
    }

    public PatchScript getPatchScript(final Patch.Key key, final PatchSet.Id leftId, final PatchSet.Id rightId, IProgressMonitor monitor) throws GerritException {
        final AccountDiffPreference diffPrefs = new AccountDiffPreference(null);
        diffPrefs.setLineLength(Integer.MAX_VALUE);
        diffPrefs.setTabSize(4);
        diffPrefs.setContext((short)-1);
        diffPrefs.setIgnoreWhitespace(AccountDiffPreference.Whitespace.IGNORE_NONE);
        diffPrefs.setIntralineDifference(false);
        return this.execute(monitor, new Operation<PatchScript>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getPatchDetailService().patchScript(key, leftId, rightId, diffPrefs, (AsyncCallback)this);
            }
        });
    }

    public PatchSetDetail getPatchSetDetail(Change.Id changeId, int patchSetId, IProgressMonitor monitor) throws GerritException {
        PatchSet.Id id = new PatchSet.Id(changeId, patchSetId);
        return this.getPatchSetDetail(id, monitor);
    }

    public PatchSetDetail getPatchSetDetail(final PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        PatchSetDetail result = null;
        try {
            result = this.execute(monitor, new Operation<PatchSetDetail>(){

                @Override
                public void execute(IProgressMonitor monitor) throws GerritException {
                    GerritClient.this.getChangeDetailService().patchSetDetail(id, null, null, this);
                }
            });
        }
        catch (GerritException e) {
            String message = e.getMessage();
            if (message != null && message.contains("Error parsing request")) {
                result = this.execute(monitor, new Operation<PatchSetDetail>(){

                    @Override
                    public void execute(IProgressMonitor monitor) throws GerritException {
                        GerritClient.this.getChangeDetailService().patchSetDetail(id, this);
                    }
                });
            }
            throw e;
        }
        return result;
    }

    public PatchSetPublishDetail getPatchSetPublishDetail(final PatchSet.Id id, IProgressMonitor monitor) throws GerritException {
        return this.execute(monitor, new Operation<PatchSetPublishDetail>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getChangeDetailService().patchSetPublishDetail(id, this);
            }
        });
    }

    public GerritChange getChange(String reviewId, IProgressMonitor monitor) throws GerritException {
        GerritChange change = new GerritChange();
        ChangeDetail changeDetail = this.getChangeDetail(this.id(reviewId), monitor);
        ArrayList<PatchSetDetail> patchSets = new ArrayList<PatchSetDetail>(changeDetail.getPatchSets().size());
        HashMap<PatchSet.Id, PatchSetPublishDetail> patchSetPublishDetailByPatchSetId = new HashMap<PatchSet.Id, PatchSetPublishDetail>();
        for (PatchSet patchSet : changeDetail.getPatchSets()) {
            PatchSetDetail patchSetDetail = this.getPatchSetDetail(patchSet.getId(), monitor);
            patchSets.add(patchSetDetail);
            if (this.isAnonymous()) continue;
            PatchSetPublishDetail patchSetPublishDetail = this.getPatchSetPublishDetail(patchSet.getId(), monitor);
            patchSetPublishDetailByPatchSetId.put(patchSet.getId(), patchSetPublishDetail);
        }
        change.setChangeDetail(changeDetail);
        change.setPatchSets(patchSets);
        change.setPatchSetPublishDetailByPatchSetId(patchSetPublishDetailByPatchSetId);
        return change;
    }

    public int id(String id) throws GerritException {
        if (id == null) {
            throw new GerritException("Invalid ID (null)");
        }
        try {
            return Integer.parseInt(id);
        }
        catch (NumberFormatException numberFormatException) {
            throw new GerritException(NLS.bind((String)"Invalid ID ('{0}')", (Object)id));
        }
    }

    public void publishComments(String reviewId, int patchSetId, final String message, final Set<ApprovalCategoryValue.Id> approvals, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        this.execute(monitor, new Operation<VoidResult>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getPatchDetailService().publishComments(id, message, approvals, (AsyncCallback)this);
            }
        });
    }

    public ReviewerResult addReviewers(String reviewId, final List<String> reviewers, IProgressMonitor monitor) throws GerritException {
        final Change.Id id = new Change.Id(this.id(reviewId));
        return this.execute(monitor, new Operation<ReviewerResult>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getPatchDetailService().addReviewers(id, reviewers, (AsyncCallback)this);
            }
        });
    }

    public List<ChangeInfo> queryAllReviews(IProgressMonitor monitor) throws GerritException {
        return this.executeQuery(monitor, "status:open");
    }

    public List<ChangeInfo> queryByProject(IProgressMonitor monitor, String project) throws GerritException {
        return this.executeQuery(monitor, "status:open project:" + project);
    }

    public List<ChangeInfo> queryMyReviews(IProgressMonitor monitor) throws GerritException {
        final Account account = this.getAccount(monitor);
        AccountDashboardInfo ad = this.execute(monitor, new Operation<AccountDashboardInfo>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getChangeListService().forAccount(account.getId(), (AsyncCallback)this);
            }
        });
        List allMyChanges = ad.getByOwner();
        allMyChanges.addAll(ad.getForReview());
        allMyChanges.addAll(ad.getClosed());
        return allMyChanges;
    }

    public GerritConfig refreshConfig(IProgressMonitor monitor) throws GerritException {
        GerritConfig gerritConfig;
        this.configRefreshed = true;
        GerritConfig config = null;
        GetMethod method = this.client.getRequest("/", monitor);
        try {
            if (method.getStatusCode() == 200) {
                InputStream in = WebUtil.getResponseBodyAsStream((HttpMethodBase)method, (IProgressMonitor)monitor);
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, method.getResponseCharSet()));
                    HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)reader, null);
                    try {
                        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
                        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                            HtmlTag tag;
                            if (token.getType() == HtmlStreamTokenizer.Token.TAG && (tag = (HtmlTag)token.getValue()).getTagType() == HTML.Tag.SCRIPT) {
                                String text = GerritClient.getText(tokenizer);
                                text = text.replaceAll("\n", "");
                                text = text.replaceAll("\\s+", " ");
                                config = this.parseConfig(text);
                                break;
                            }
                            token = tokenizer.nextToken();
                        }
                    }
                    catch (ParseException parseException) {
                        throw new IOException("Error reading url");
                    }
                }
                finally {
                    in.close();
                }
            }
            if (config == null) {
                throw new GerritException("Failed to obtain Gerrit configuration");
            }
            this.config = config;
            this.configurationChanged(config);
            gerritConfig = config;
        }
        catch (Throwable throwable) {
            try {
                method.releaseConnection();
                throw throwable;
            }
            catch (IOException cause) {
                GerritException e = new GerritException();
                e.initCause(cause);
                throw e;
            }
        }
        method.releaseConnection();
        return gerritConfig;
    }

    public GerritConfig refreshConfigOnce(IProgressMonitor monitor) throws GerritException {
        if (!this.configRefreshed && this.config == null) {
            try {
                this.refreshConfig(monitor);
            }
            catch (GerritException gerritException) {}
        }
        return this.getConfig();
    }

    public ChangeDetail restore(String reviewId, int patchSetId, final String message, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        return this.execute(monitor, new Operation<ChangeDetail>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getChangeManageService().restoreChange(id, message, (AsyncCallback)this);
            }
        });
    }

    public ChangeDetail submit(String reviewId, int patchSetId, String message, IProgressMonitor monitor) throws GerritException {
        final PatchSet.Id id = new PatchSet.Id(new Change.Id(this.id(reviewId)), patchSetId);
        return this.execute(monitor, new Operation<ChangeDetail>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getChangeManageService().submit(id, (AsyncCallback)this);
            }
        });
    }

    private void addComments(IFileRevision revision, List<PatchLineComment> comments, AccountInfoCache accountInfoCache) {
        if (comments == null) {
            return;
        }
        for (PatchLineComment comment : comments) {
            ILineRange line = FACTORY.createLineRange();
            line.setStart(comment.getLine());
            line.setEnd(comment.getLine());
            ILineLocation location = FACTORY.createLineLocation();
            location.getRanges().add(line);
            IUser author = GerritUtil.createUser(comment.getAuthor(), accountInfoCache);
            IComment topicComment = FACTORY.createComment();
            topicComment.setAuthor(author);
            topicComment.setCreationDate((Date)comment.getWrittenOn());
            topicComment.setDescription(comment.getMessage());
            ITopic topic = FACTORY.createTopic();
            topic.setAuthor(author);
            topic.setCreationDate((Date)comment.getWrittenOn());
            topic.setLocation((ILocation)location);
            topic.setItem((IReviewItem)revision);
            topic.setDescription(comment.getMessage());
            topic.getComments().add(topicComment);
            revision.getTopics().add(topic);
        }
    }

    private List<ChangeInfo> executeQuery(IProgressMonitor monitor, final String queryString) throws GerritException {
        SingleListChangeInfo sl = this.execute(monitor, new Operation<SingleListChangeInfo>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getChangeListService().allQueryNext(queryString, "z", 25, (AsyncCallback)this);
            }
        });
        return sl.getChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Account getAccount(IProgressMonitor monitor) throws GerritException {
        GerritClient gerritClient = this;
        synchronized (gerritClient) {
            if (this.myAcount != null) {
                return this.myAcount;
            }
        }
        Account account = this.execute(monitor, new Operation<Account>(){

            @Override
            public void execute(IProgressMonitor monitor) throws GerritException {
                GerritClient.this.getAccountService().myAccount((AsyncCallback)this);
            }
        });
        GerritClient gerritClient2 = this;
        synchronized (gerritClient2) {
            this.myAcount = account;
        }
        return this.myAcount;
    }

    private AccountService getAccountService() {
        return this.getService(AccountService.class);
    }

    private ChangeDetailService getChangeDetailService() {
        return this.getService(ChangeDetailService.class);
    }

    private ChangeListService getChangeListService() {
        return this.getService(ChangeListService.class);
    }

    private ChangeManageService getChangeManageService() {
        return this.getService(ChangeManageService.class);
    }

    private PatchDetailService getPatchDetailService() {
        return this.getService(PatchDetailService.class);
    }

    private SystemInfoService getSystemInfoService() {
        return this.getService(SystemInfoService.class);
    }

    public boolean isAnonymous() {
        return this.client.isAnonymous();
    }

    private GerritConfig parseConfig(String text) {
        String[] tokens;
        String prefix = "var gerrit_hostpagedata={\"config\":";
        String[] stringArray = tokens = text.split("};");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (token.startsWith(prefix)) {
                token = token.substring(prefix.length());
                return GerritClient.configFromString(token);
            }
            ++n2;
        }
        return null;
    }

    protected void configurationChanged(GerritConfig config) {
    }

    protected <T> T execute(IProgressMonitor monitor, Operation<T> operation) throws GerritException {
        try {
            GerritService.GerritRequest.setCurrentRequest(new GerritService.GerritRequest(monitor));
            operation.execute(monitor);
            if (operation.getException() instanceof GerritException) {
                throw (GerritException)operation.getException();
            }
            if (operation.getException() instanceof OperationCanceledException) {
                throw (OperationCanceledException)operation.getException();
            }
            if (operation.getException() != null) {
                GerritException e = new GerritException();
                e.initCause(operation.getException());
                throw e;
            }
            T t = operation.getResult();
            return t;
        }
        finally {
            GerritService.GerritRequest.setCurrentRequest(null);
        }
    }

    protected synchronized <T extends RemoteJsonService> T getService(Class<T> clazz) {
        Object service = this.serviceByClass.get(clazz);
        if (service == null) {
            service = GerritService.create(clazz, this.client);
            this.serviceByClass.put((Class<? extends RemoteJsonService>)clazz, (RemoteJsonService)service);
        }
        return (T)((RemoteJsonService)clazz.cast(service));
    }

    private abstract class Operation<T>
    implements AsyncCallback<T> {
        private Throwable exception;
        private T result;

        private Operation() {
        }

        public abstract void execute(IProgressMonitor var1) throws GerritException;

        public Throwable getException() {
            return this.exception;
        }

        public T getResult() {
            return this.result;
        }

        public void onFailure(Throwable exception) {
            this.exception = exception;
        }

        public void onSuccess(T result) {
            this.setResult(result);
        }

        protected void setResult(T result) {
            this.result = result;
        }
    }
}

