/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.server;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class SqlTimestampDeserializer
implements JsonDeserializer<Timestamp>,
JsonSerializer<Timestamp> {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    public Timestamp deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonNull()) {
            return null;
        }
        if (!json.isJsonPrimitive()) {
            throw new JsonParseException("Expected string for timestamp type");
        }
        JsonPrimitive p = (JsonPrimitive)json;
        if (!p.isString()) {
            throw new JsonParseException("Expected string for timestamp type");
        }
        try {
            long when = SqlTimestampDeserializer.newFormat().parse(p.getAsString()).getTime();
            return new Timestamp(when);
        }
        catch (ParseException e) {
            throw new JsonParseException("Not a timestamp string");
        }
    }

    public JsonElement serialize(Timestamp src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == null) {
            return new JsonNull();
        }
        return new JsonPrimitive(SqlTimestampDeserializer.newFormat().format(src) + "000000");
    }

    private static SimpleDateFormat newFormat() {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        f.setTimeZone(UTC);
        f.setLenient(true);
        return f;
    }
}

