/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind.rpc;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.javac.TypeOracleMediator;
import com.google.gwt.dev.util.Util;
import com.google.gwt.user.rebind.rpc.SerializableTypeOracleBuilder;
import com.google.gwt.user.rebind.rpc.Shared;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;

public class SerializationUtils {
    static final Comparator<JField> FIELD_COMPARATOR = new Comparator<JField>(){

        @Override
        public int compare(JField f1, JField f2) {
            return f1.getName().compareTo(f2.getName());
        }
    };
    static final String GENERATED_FIELD_SERIALIZER_SUFFIX = "_FieldSerializer";
    static final String TYPE_SERIALIZER_SUFFIX = "_TypeSerializer";
    static final Set<String> TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES = new HashSet<String>();

    public static JField[] getSerializableFields(TypeOracle typeOracle, JClassType classType) {
        assert (classType != null);
        ArrayList<JField> fields = new ArrayList<JField>();
        JField[] declFields = classType.getFields();
        assert (declFields != null);
        for (JField field : declFields) {
            if (!SerializableTypeOracleBuilder.shouldConsiderForSerialization(TreeLogger.NULL, true, field)) continue;
            fields.add(field);
        }
        Collections.sort(fields, FIELD_COMPARATOR);
        return fields.toArray(new JField[fields.size()]);
    }

    static String getFieldSerializerName(TypeOracle typeOracle, JType type) {
        JClassType customSerializer = SerializableTypeOracleBuilder.findCustomFieldSerializer(typeOracle, type);
        if (customSerializer != null) {
            return customSerializer.getQualifiedSourceName();
        }
        assert (type.isClassOrInterface() != null || type.isArray() != null);
        JClassType classType = (JClassType)type;
        String[] name = Shared.synthesizeTopLevelClassName(classType, GENERATED_FIELD_SERIALIZER_SUFFIX);
        if (name[0].length() > 0) {
            String serializerName = name[0] + "." + name[1];
            if (SerializableTypeOracleBuilder.isInStandardJavaPackage(type.getQualifiedSourceName())) {
                serializerName = "com.google.gwt.user.client.rpc.core." + serializerName;
            }
            return serializerName;
        }
        return name[1];
    }

    static String getSerializationSignature(TypeOracle typeOracle, JType type) throws RuntimeException {
        CRC32 crc = new CRC32();
        try {
            SerializationUtils.generateSerializationSignature(typeOracle, type, crc);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not compute the serialization signature", e);
        }
        return Long.toString(crc.getValue());
    }

    static String getTypeSerializerQualifiedName(JClassType serviceIntf) throws IllegalArgumentException {
        if (serviceIntf.isInterface() == null) {
            throw new IllegalArgumentException(serviceIntf.getQualifiedSourceName() + " is not a service interface");
        }
        String[] name = Shared.synthesizeTopLevelClassName(serviceIntf, TYPE_SERIALIZER_SUFFIX);
        if (name[0].length() > 0) {
            return name[0] + "." + name[1];
        }
        return name[1];
    }

    static String getTypeSerializerSimpleName(TypeOracle typeOracle, JClassType serviceIntf) throws IllegalArgumentException {
        if (serviceIntf.isInterface() == null) {
            throw new IllegalArgumentException(serviceIntf.getQualifiedSourceName() + " is not a service interface");
        }
        String[] name = Shared.synthesizeTopLevelClassName(serviceIntf, TYPE_SERIALIZER_SUFFIX);
        return name[1];
    }

    private static boolean excludeImplementationFromSerializationSignature(JType instanceType) {
        return TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.contains(instanceType.getQualifiedSourceName());
    }

    private static void generateSerializationSignature(TypeOracle typeOracle, JType type, CRC32 crc) throws UnsupportedEncodingException {
        JParameterizedType parameterizedType = type.isParameterized();
        if (parameterizedType != null) {
            SerializationUtils.generateSerializationSignature(typeOracle, (JType)parameterizedType.getRawType(), crc);
            return;
        }
        String serializedTypeName = TypeOracleMediator.computeBinaryClassName((JType)type);
        crc.update(serializedTypeName.getBytes(Util.DEFAULT_ENCODING));
        if (SerializationUtils.excludeImplementationFromSerializationSignature(type)) {
            return;
        }
        JClassType customSerializer = SerializableTypeOracleBuilder.findCustomFieldSerializer(typeOracle, type);
        if (customSerializer != null) {
            SerializationUtils.generateSerializationSignature(typeOracle, (JType)customSerializer, crc);
        } else if (type.isArray() != null) {
            JArrayType isArray = type.isArray();
            SerializationUtils.generateSerializationSignature(typeOracle, isArray.getComponentType(), crc);
        } else if (type.isClassOrInterface() != null) {
            JField[] fields;
            JClassType isClassOrInterface = type.isClassOrInterface();
            for (JField field : fields = SerializationUtils.getSerializableFields(typeOracle, isClassOrInterface)) {
                assert (field != null);
                crc.update(field.getName().getBytes(Util.DEFAULT_ENCODING));
                crc.update(TypeOracleMediator.computeBinaryClassName((JType)field.getType()).getBytes(Util.DEFAULT_ENCODING));
            }
            JClassType superClass = isClassOrInterface.getSuperclass();
            if (superClass != null) {
                SerializationUtils.generateSerializationSignature(typeOracle, (JType)superClass, crc);
            }
        }
    }

    static {
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add("java.lang.Boolean");
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add("java.lang.Byte");
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add("java.lang.Character");
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add("java.lang.Double");
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add("java.lang.Exception");
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add("java.lang.Float");
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add("java.lang.Integer");
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add("java.lang.Long");
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add("java.lang.Object");
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add("java.lang.Short");
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add("java.lang.String");
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add("java.lang.Throwable");
    }
}

