/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind.rpc;

import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JGenericType;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JRealClassType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.JTypeParameter;
import com.google.gwt.core.ext.typeinfo.JWildcardType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.util.log.PrintWriterTreeLogger;
import com.google.gwt.user.client.rpc.GwtTransient;
import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.rebind.rpc.CustomFieldSerializerValidator;
import com.google.gwt.user.rebind.rpc.ProblemReport;
import com.google.gwt.user.rebind.rpc.SerializableTypeOracle;
import com.google.gwt.user.rebind.rpc.SerializableTypeOracleImpl;
import com.google.gwt.user.rebind.rpc.Shared;
import com.google.gwt.user.rebind.rpc.TypeConstrainer;
import com.google.gwt.user.rebind.rpc.TypeFilter;
import com.google.gwt.user.rebind.rpc.TypeHierarchyUtils;
import com.google.gwt.user.rebind.rpc.TypeParameterExposureComputer;
import com.google.gwt.user.rebind.rpc.TypePaths;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableTypeOracleBuilder {
    static final Comparator<JType> JTYPE_COMPARATOR = new Comparator<JType>(){

        @Override
        public int compare(JType t1, JType t2) {
            return t1.getQualifiedSourceName().compareTo(t2.getQualifiedSourceName());
        }
    };
    private static final TypeFilter DEFAULT_TYPE_FILTER = new TypeFilter(){

        public String getName() {
            return "Default";
        }

        public boolean isAllowed(JClassType type) {
            return true;
        }
    };
    private static Class<? extends Annotation> JDO_PERSISTENCE_CAPABLE_ANNOTATION = null;
    private static Method JDO_PERSISTENCE_CAPABLE_DETACHABLE_METHOD;
    private static Class<? extends Annotation> JPA_ENTITY_ANNOTATION;
    private boolean alreadyCheckedObject;
    private final JGenericType collectionClass;
    private Set<String> enhancedClasses = null;
    private OutputStream logOutputStream;
    private final JGenericType mapClass;
    private final Map<JClassType, TreeLogger> rootTypes = new LinkedHashMap<JClassType, TreeLogger>();
    private final boolean suppressNonStaticFinalFieldWarnings;
    private final TypeConstrainer typeConstrainer;
    private TypeFilter typeFilter = DEFAULT_TYPE_FILTER;
    private final TypeOracle typeOracle;
    private final TypeParameterExposureComputer typeParameterExposureComputer = new TypeParameterExposureComputer(this.typeFilter);
    private Set<JTypeParameter> typeParametersInRootTypes = new HashSet<JTypeParameter>();
    private final Map<JType, TypeInfoComputed> typeToTypeInfoComputed = new HashMap<JType, TypeInfoComputed>();

    static boolean canBeInstantiated(JClassType type, ProblemReport problems) {
        if (type.isEnum() == null) {
            if (type.isAbstract()) {
                return false;
            }
            if (!type.isDefaultInstantiable() && !SerializableTypeOracleBuilder.isManuallySerializable(type)) {
                problems.add(type, type.getParameterizedQualifiedSourceName() + " is not default instantiable (it must have a zero-argument " + "constructor or no constructors at all) and has no custom " + "serializer.", ProblemReport.Priority.DEFAULT, new String[0]);
                return false;
            }
        }
        return true;
    }

    public static JClassType findCustomFieldSerializer(TypeOracle typeOracle, JType type) {
        JClassType classOrInterface = type.isClassOrInterface();
        if (classOrInterface == null) {
            return null;
        }
        String customFieldSerializerName = type.getQualifiedSourceName() + "_CustomFieldSerializer";
        JClassType customSerializer = typeOracle.findType(customFieldSerializerName);
        if (customSerializer == null) {
            customSerializer = typeOracle.findType("com.google.gwt.user.client.rpc.core." + customFieldSerializerName);
        }
        return customSerializer;
    }

    static JRealClassType getBaseType(JClassType type) {
        if (type.isParameterized() != null) {
            return type.isParameterized().getBaseType();
        }
        if (type.isRawType() != null) {
            return type.isRawType().getBaseType();
        }
        return (JRealClassType)type;
    }

    static boolean hasJdoAnnotation(JClassType type) {
        if (JDO_PERSISTENCE_CAPABLE_ANNOTATION == null) {
            return false;
        }
        Annotation annotation = type.getAnnotation(JDO_PERSISTENCE_CAPABLE_ANNOTATION);
        if (annotation == null) {
            return false;
        }
        try {
            Object value = JDO_PERSISTENCE_CAPABLE_DETACHABLE_METHOD.invoke((Object)annotation, (Object[])null);
            if (value instanceof String) {
                return "true".equalsIgnoreCase((String)value);
            }
            return false;
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    static boolean hasJpaAnnotation(JClassType type) {
        if (JPA_ENTITY_ANNOTATION == null) {
            return false;
        }
        Annotation annotation = type.getAnnotation(JPA_ENTITY_ANNOTATION);
        return annotation != null;
    }

    static boolean isAutoSerializable(JClassType type) {
        try {
            JClassType isSerializable = SerializableTypeOracleBuilder.getIsSerializableMarkerInterface(type);
            JClassType serializable = SerializableTypeOracleBuilder.getSerializableMarkerInterface(type);
            return type.isAssignableTo(isSerializable) || type.isAssignableTo(serializable);
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    static boolean isInStandardJavaPackage(String className) {
        if (className.startsWith("java.")) {
            return true;
        }
        return className.startsWith("javax.");
    }

    static void recordTypeParametersIn(JType type, Set<JTypeParameter> params) {
        JParameterizedType isParameterized;
        JWildcardType isWildcard;
        JArrayType isArray;
        JTypeParameter isTypeParameter = type.isTypeParameter();
        if (isTypeParameter != null) {
            params.add(isTypeParameter);
        }
        if ((isArray = type.isArray()) != null) {
            SerializableTypeOracleBuilder.recordTypeParametersIn(isArray.getComponentType(), params);
        }
        if ((isWildcard = type.isWildcard()) != null) {
            for (JClassType bound : isWildcard.getUpperBounds()) {
                SerializableTypeOracleBuilder.recordTypeParametersIn((JType)bound, params);
            }
        }
        if ((isParameterized = type.isParameterized()) != null) {
            for (JClassType arg : isParameterized.getTypeArgs()) {
                SerializableTypeOracleBuilder.recordTypeParametersIn((JType)arg, params);
            }
        }
    }

    static boolean shouldConsiderFieldsForSerialization(JClassType type, TypeFilter filter, ProblemReport problems) {
        if (!SerializableTypeOracleBuilder.isAllowedByFilter(filter, type, problems)) {
            return false;
        }
        if (!SerializableTypeOracleBuilder.isDeclaredSerializable(type)) {
            problems.add(type, type.getParameterizedQualifiedSourceName() + " is not assignable to '" + IsSerializable.class.getName() + "' or '" + Serializable.class.getName() + "' nor does it have a custom field serializer", ProblemReport.Priority.DEFAULT, new String[0]);
            return false;
        }
        if (SerializableTypeOracleBuilder.isManuallySerializable(type)) {
            JClassType manualSerializer = SerializableTypeOracleBuilder.findCustomFieldSerializer(type.getOracle(), (JType)type);
            assert (manualSerializer != null);
            List<String> fieldProblems = CustomFieldSerializerValidator.validate(manualSerializer, type);
            if (!fieldProblems.isEmpty()) {
                for (String problem : fieldProblems) {
                    problems.add(type, problem, ProblemReport.Priority.FATAL, new String[0]);
                }
                return false;
            }
        } else {
            assert (SerializableTypeOracleBuilder.isAutoSerializable(type));
            if (!SerializableTypeOracleBuilder.isAccessibleToSerializer(type)) {
                problems.add(type, type.getParameterizedQualifiedSourceName() + " is not accessible from a class in its same package; it " + "will be excluded from the set of serializable types", ProblemReport.Priority.DEFAULT, new String[0]);
                return false;
            }
            if (type.isMemberType() && !type.isStatic()) {
                problems.add(type, type.getParameterizedQualifiedSourceName() + " is nested but " + "not static; it will be excluded from the set of serializable " + "types", ProblemReport.Priority.DEFAULT, new String[0]);
                return false;
            }
        }
        return true;
    }

    static boolean shouldConsiderForSerialization(TreeLogger logger, boolean suppressNonStaticFinalFieldWarnings, JField field) {
        if (field.isStatic() || field.isTransient()) {
            return false;
        }
        if (field.isAnnotationPresent(GwtTransient.class)) {
            return false;
        }
        if (field.isFinal()) {
            TreeLogger.Type logLevel = SerializableTypeOracleBuilder.isManuallySerializable(field.getEnclosingType()) ? TreeLogger.DEBUG : TreeLogger.WARN;
            logger.branch(suppressNonStaticFinalFieldWarnings ? TreeLogger.DEBUG : logLevel, "Field '" + field.toString() + "' will not be serialized because it is final", null);
            return false;
        }
        return true;
    }

    private static boolean directlyImplementsMarkerInterface(JClassType type) {
        try {
            return TypeHierarchyUtils.directlyImplementsInterface(type, SerializableTypeOracleBuilder.getIsSerializableMarkerInterface(type)) || TypeHierarchyUtils.directlyImplementsInterface(type, SerializableTypeOracleBuilder.getSerializableMarkerInterface(type));
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    private static JArrayType getArrayType(TypeOracle typeOracle, int rank, JType component) {
        assert (rank > 0);
        JArrayType array = null;
        JType currentComponent = component;
        for (int i = 0; i < rank; ++i) {
            array = typeOracle.getArrayType(currentComponent);
            currentComponent = array;
        }
        return array;
    }

    private static JClassType getIsSerializableMarkerInterface(JClassType type) throws NotFoundException {
        return type.getOracle().getType(IsSerializable.class.getName());
    }

    private static JClassType getSerializableMarkerInterface(JClassType type) throws NotFoundException {
        return type.getOracle().getType(Serializable.class.getName());
    }

    private static boolean isAccessibleToSerializer(JClassType type) {
        if (type.isPrivate() || type.isLocalType()) {
            return false;
        }
        if (SerializableTypeOracleBuilder.isInStandardJavaPackage(type.getQualifiedSourceName()) && !type.isPublic()) {
            return false;
        }
        if (type.isMemberType()) {
            return SerializableTypeOracleBuilder.isAccessibleToSerializer(type.getEnclosingType());
        }
        return true;
    }

    private static boolean isAllowedByFilter(TypeFilter filter, JClassType classType, ProblemReport problems) {
        if (!filter.isAllowed(classType)) {
            problems.add(classType, classType.getParameterizedQualifiedSourceName() + " is excluded by type filter ", ProblemReport.Priority.AUXILIARY, new String[0]);
            return false;
        }
        return true;
    }

    private static boolean isDeclaredSerializable(JClassType type) {
        return SerializableTypeOracleBuilder.isAutoSerializable(type) || SerializableTypeOracleBuilder.isManuallySerializable(type);
    }

    private static boolean isDirectlySerializable(JClassType type) {
        return SerializableTypeOracleBuilder.directlyImplementsMarkerInterface(type) || SerializableTypeOracleBuilder.isManuallySerializable(type);
    }

    private static boolean isManuallySerializable(JClassType type) {
        return SerializableTypeOracleBuilder.findCustomFieldSerializer(type.getOracle(), (JType)type) != null;
    }

    private static void logSerializableTypes(TreeLogger logger, Set<JClassType> fieldSerializableTypes) {
        TreeLogger localLogger = logger.branch(TreeLogger.DEBUG, "Identified " + fieldSerializableTypes.size() + " serializable type" + (fieldSerializableTypes.size() == 1 ? "" : "s"), null);
        for (JClassType fieldSerializableType : fieldSerializableTypes) {
            localLogger.branch(TreeLogger.DEBUG, fieldSerializableType.getParameterizedQualifiedSourceName(), null);
        }
    }

    public SerializableTypeOracleBuilder(TreeLogger logger, PropertyOracle propertyOracle, TypeOracle typeOracle) throws UnableToCompleteException {
        this.typeOracle = typeOracle;
        this.typeConstrainer = new TypeConstrainer(typeOracle);
        try {
            this.collectionClass = typeOracle.getType(Collection.class.getName()).isGenericType();
            this.mapClass = typeOracle.getType(Map.class.getName()).isGenericType();
        }
        catch (NotFoundException e) {
            logger.log(TreeLogger.ERROR, null, (Throwable)e);
            throw new UnableToCompleteException();
        }
        this.suppressNonStaticFinalFieldWarnings = Shared.shouldSuppressNonStaticFinalFieldWarnings(logger, propertyOracle);
        this.enhancedClasses = Shared.getEnhancedTypes(propertyOracle);
    }

    public void addRootType(TreeLogger logger, JType type) {
        if (type.isPrimitive() != null) {
            return;
        }
        JClassType clazz = (JClassType)type;
        if (!this.rootTypes.containsKey(clazz)) {
            SerializableTypeOracleBuilder.recordTypeParametersIn(type, this.typeParametersInRootTypes);
            this.rootTypes.put(clazz, logger);
        } else {
            logger.log(TreeLogger.TRACE, clazz.getParameterizedQualifiedSourceName() + " is already a root type.");
        }
    }

    public SerializableTypeOracle build(TreeLogger logger) throws UnableToCompleteException {
        this.alreadyCheckedObject = false;
        boolean allSucceeded = true;
        for (Map.Entry<JClassType, TreeLogger> entry : this.rootTypes.entrySet()) {
            ProblemReport problems = new ProblemReport();
            problems.setContextType(entry.getKey());
            boolean entrySucceeded = this.computeTypeInstantiability(entry.getValue(), (JType)entry.getKey(), TypePaths.createRootPath((JType)entry.getKey()), problems).hasInstantiableSubtypes();
            if (!entrySucceeded) {
                problems.report(logger, TreeLogger.ERROR, TreeLogger.INFO);
            } else {
                if (problems.hasFatalProblems()) {
                    entrySucceeded = false;
                    problems.reportFatalProblems(logger, TreeLogger.ERROR);
                }
                problems.report(logger, TreeLogger.DEBUG, TreeLogger.DEBUG);
            }
            allSucceeded &= entrySucceeded;
        }
        if (!allSucceeded) {
            throw new UnableToCompleteException();
        }
        for (TypeInfoComputed tic : this.typeToTypeInfoComputed.values()) {
            assert (!tic.isPendingInstantiable());
        }
        this.pruneUnreachableTypes();
        this.logReachableTypes(logger);
        TreeSet<JType> possiblyInstantiatedTypes = new TreeSet<JType>(JTYPE_COMPARATOR);
        TreeSet<JType> fieldSerializableTypes = new TreeSet<JType>(JTYPE_COMPARATOR);
        for (TypeInfoComputed tic : this.typeToTypeInfoComputed.values()) {
            if (!(tic.getType() instanceof JClassType)) continue;
            JClassType type = (JClassType)tic.getType();
            type = type.getErasedType();
            if (tic.isInstantiable()) {
                assert (!type.isAbstract() || type.isEnum() != null);
                possiblyInstantiatedTypes.add((JType)type);
            }
            if (tic.isFieldSerializable()) {
                assert (type.isInterface() == null);
                fieldSerializableTypes.add((JType)type);
            }
            if (!tic.maybeEnhanced() && (this.enhancedClasses == null || !this.enhancedClasses.contains(type.getQualifiedSourceName()))) continue;
            type.setEnhanced();
        }
        SerializableTypeOracleBuilder.logSerializableTypes(logger, fieldSerializableTypes);
        return new SerializableTypeOracleImpl(fieldSerializableTypes, possiblyInstantiatedTypes);
    }

    public void setLogOutputStream(OutputStream logOutputStream) {
        this.logOutputStream = logOutputStream;
    }

    public void setTypeFilter(TypeFilter typeFilter) {
        this.typeFilter = typeFilter;
        this.typeParameterExposureComputer.setTypeFilter(typeFilter);
    }

    TypeInfoComputed computeTypeInstantiability(TreeLogger logger, JType type, TypePaths.TypePath path, ProblemReport problems) {
        assert (type != null);
        if (type.isPrimitive() != null) {
            TypeInfoComputed tic = this.getTypeInfoComputed(type, path, true);
            tic.setInstantiableSubtypes(true);
            tic.setInstantiable(false);
            return tic;
        }
        assert (type instanceof JClassType);
        JClassType classType = (JClassType)type;
        TypeInfoComputed tic = this.getTypeInfoComputed((JType)classType, path, false);
        if (tic != null && tic.isDone()) {
            return tic;
        }
        TreeLogger localLogger = logger.branch(TreeLogger.DEBUG, classType.getParameterizedQualifiedSourceName(), null);
        JTypeParameter isTypeParameter = classType.isTypeParameter();
        if (isTypeParameter != null) {
            if (this.typeParametersInRootTypes.contains(isTypeParameter)) {
                return this.computeTypeInstantiability(localLogger, (JType)isTypeParameter.getFirstBound(), TypePaths.createTypeParameterInRootPath(path, isTypeParameter), problems);
            }
            tic = this.getTypeInfoComputed((JType)classType, path, true);
            tic.setInstantiableSubtypes(true);
            tic.setInstantiable(false);
            return tic;
        }
        JWildcardType isWildcard = classType.isWildcard();
        if (isWildcard != null) {
            boolean success = true;
            for (JClassType bound : isWildcard.getUpperBounds()) {
                success &= this.computeTypeInstantiability(localLogger, (JType)bound, path, problems).hasInstantiableSubtypes();
            }
            tic = this.getTypeInfoComputed((JType)classType, path, true);
            tic.setInstantiableSubtypes(success);
            tic.setInstantiable(false);
            return tic;
        }
        JArrayType isArray = classType.isArray();
        if (isArray != null) {
            TypeInfoComputed arrayTic = this.checkArrayInstantiable(localLogger, isArray, path, problems);
            assert (this.getTypeInfoComputed((JType)classType, path, false) != null);
            return arrayTic;
        }
        if (classType == this.typeOracle.getJavaLangObject()) {
            problems.add(classType, "In order to produce smaller client-side code, 'Object' is not allowed; please use a more specific type", ProblemReport.Priority.DEFAULT, new String[0]);
            tic = this.getTypeInfoComputed((JType)classType, path, true);
            tic.setInstantiable(false);
            return tic;
        }
        if (classType.isRawType() != null) {
            localLogger.log(TreeLogger.DEBUG, "Type '" + classType.getQualifiedSourceName() + "' should be parameterized to help the compiler produce the smallest code size possible for your module", null);
        }
        JClassType originalType = (JClassType)type;
        tic = this.getTypeInfoComputed((JType)classType, path, true);
        boolean anySubtypes = this.checkSubtypes(localLogger, originalType, tic.getInstantiableTypes(), path, problems);
        if (!tic.isDone()) {
            tic.setInstantiableSubtypes(anySubtypes);
            tic.setInstantiable(false);
        }
        return tic;
    }

    int getTypeParameterExposure(JGenericType type, int index) {
        return this.getFlowInfo(type, index).getExposure();
    }

    boolean shouldConsiderFieldsForSerialization(JClassType type, ProblemReport problems) {
        return SerializableTypeOracleBuilder.shouldConsiderFieldsForSerialization(type, this.typeFilter, problems);
    }

    private void checkAllSubtypesOfObject(TreeLogger logger, TypePaths.TypePath parent, ProblemReport problems) {
        JClassType[] allTypes;
        if (this.alreadyCheckedObject) {
            return;
        }
        this.alreadyCheckedObject = true;
        TreeLogger localLogger = logger.branch(TreeLogger.WARN, "Checking all subtypes of Object which qualify for serialization", null);
        for (JClassType cls : allTypes = this.typeOracle.getJavaLangObject().getSubtypes()) {
            if (!SerializableTypeOracleBuilder.isDeclaredSerializable(cls)) continue;
            this.computeTypeInstantiability(localLogger, (JType)cls, TypePaths.createSubtypePath(parent, (JType)cls, this.typeOracle.getJavaLangObject()), problems);
        }
    }

    private TypeInfoComputed checkArrayInstantiable(TreeLogger logger, JArrayType array, TypePaths.TypePath path, ProblemReport problems) {
        JType leafType = array.getLeafType();
        JWildcardType leafWild = leafType.isWildcard();
        if (leafWild != null) {
            JArrayType arrayType = SerializableTypeOracleBuilder.getArrayType(this.typeOracle, array.getRank(), (JType)leafWild.getUpperBound());
            return this.checkArrayInstantiable(logger, arrayType, path, problems);
        }
        JClassType leafClass = leafType.isClassOrInterface();
        JTypeParameter isLeafTypeParameter = leafType.isTypeParameter();
        if (isLeafTypeParameter != null && !this.typeParametersInRootTypes.contains(isLeafTypeParameter)) {
            TypeInfoComputed tic = this.getTypeInfoComputed((JType)array, path, true);
            tic.setInstantiableSubtypes(true);
            tic.setInstantiable(false);
            return tic;
        }
        if (!this.isAllowedByFilter((JClassType)array, problems)) {
            TypeInfoComputed tic = this.getTypeInfoComputed((JType)array, path, true);
            tic.setInstantiable(false);
            return tic;
        }
        TypeInfoComputed tic = this.getTypeInfoComputed((JType)array, path, true);
        if (tic.isDone()) {
            return tic;
        }
        if (tic.isPendingInstantiable()) {
            return tic;
        }
        tic.setPendingInstantiable();
        TreeLogger branch = logger.branch(TreeLogger.DEBUG, "Analyzing component type:", null);
        TypeInfoComputed leafTic = this.computeTypeInstantiability(branch, leafType, TypePaths.createArrayComponentPath(array, path), problems);
        boolean succeeded = leafTic.hasInstantiableSubtypes();
        if (succeeded) {
            if (leafClass == null) {
                assert (leafType.isPrimitive() != null);
                this.markArrayTypesInstantiable(leafType, array.getRank(), path);
            } else {
                TreeLogger covariantArrayLogger = logger.branch(TreeLogger.DEBUG, "Covariant array types");
                for (JClassType instantiableType : TypeHierarchyUtils.getAllTypesBetweenRootTypeAndLeaves(leafClass, leafTic.getInstantiableTypes())) {
                    if (!SerializableTypeOracleBuilder.isAccessibleToSerializer(instantiableType)) continue;
                    covariantArrayLogger.branch(TreeLogger.DEBUG, SerializableTypeOracleBuilder.getArrayType(this.typeOracle, array.getRank(), (JType)instantiableType).getParameterizedQualifiedSourceName());
                    this.markArrayTypesInstantiable((JType)instantiableType, array.getRank(), path);
                }
            }
        }
        tic.setInstantiable(succeeded);
        return tic;
    }

    private boolean checkDeclaredFields(TreeLogger logger, TypeInfoComputed typeInfo, TypePaths.TypePath parent, ProblemReport problems) {
        boolean succeeded;
        JClassType classOrInterface = (JClassType)typeInfo.getType();
        if (classOrInterface.isEnum() != null) {
            return true;
        }
        JRealClassType baseType = SerializableTypeOracleBuilder.getBaseType(classOrInterface);
        boolean allSucceeded = true;
        JField[] fields = baseType.getFields();
        if (fields.length > 0) {
            TreeLogger localLogger = logger.branch(TreeLogger.DEBUG, "Analyzing the fields of type '" + classOrInterface.getParameterizedQualifiedSourceName() + "' that qualify for serialization", null);
            for (JField field : fields) {
                if (!SerializableTypeOracleBuilder.shouldConsiderForSerialization(localLogger, this.suppressNonStaticFinalFieldWarnings, field)) continue;
                TreeLogger fieldLogger = localLogger.branch(TreeLogger.DEBUG, field.toString(), null);
                JType fieldType = field.getType();
                TypePaths.TypePath path = TypePaths.createFieldPath(parent, field);
                if (typeInfo.isManuallySerializable() && fieldType.getLeafType() == this.typeOracle.getJavaLangObject()) {
                    this.checkAllSubtypesOfObject(fieldLogger.branch(TreeLogger.WARN, "Object was reached from a manually serializable type", null), path, problems);
                    continue;
                }
                allSucceeded &= this.computeTypeInstantiability(fieldLogger, fieldType, path, problems).hasInstantiableSubtypes();
            }
        }
        boolean bl = succeeded = allSucceeded || typeInfo.isManuallySerializable();
        if (succeeded) {
            typeInfo.setFieldSerializable();
        }
        return succeeded;
    }

    private boolean checkSubtype(TreeLogger logger, JClassType classOrInterface, JClassType originalType, TypePaths.TypePath parent, ProblemReport problems) {
        JClassType superType;
        if (classOrInterface.isEnum() != null) {
            return true;
        }
        JParameterizedType isParameterized = classOrInterface.isParameterized();
        if (isParameterized != null) {
            if (this.isRawMapOrRawCollection(classOrInterface)) {
                this.checkAllSubtypesOfObject(logger, parent, problems);
            } else {
                TreeLogger paramsLogger = logger.branch(TreeLogger.DEBUG, "Checking parameters of '" + isParameterized.getParameterizedQualifiedSourceName() + "'");
                for (JTypeParameter param : isParameterized.getBaseType().getTypeParameters()) {
                    if (this.checkTypeArgument(paramsLogger, isParameterized.getBaseType(), param.getOrdinal(), isParameterized.getTypeArgs()[param.getOrdinal()], parent, problems)) continue;
                    return false;
                }
            }
        }
        if ((superType = classOrInterface.getSuperclass()) != null && superType.isRawType() != null) {
            superType = superType.isRawType().asParameterizedByWildcards();
        }
        if (superType != null && SerializableTypeOracleBuilder.isDeclaredSerializable(superType)) {
            if ((superType = this.constrainTypeBy(superType, originalType)) == null) {
                return false;
            }
            boolean superTypeOk = false;
            superTypeOk = this.checkSubtype(logger, superType, originalType, TypePaths.createSupertypePath(parent, (JType)superType, classOrInterface), problems);
            if (!superTypeOk && !SerializableTypeOracleBuilder.isDirectlySerializable(classOrInterface)) {
                return false;
            }
        }
        TypeInfoComputed tic = this.getTypeInfoComputed((JType)classOrInterface, parent, true);
        return this.checkDeclaredFields(logger, tic, parent, problems);
    }

    private boolean checkSubtypes(TreeLogger logger, JClassType originalType, Set<JClassType> instSubtypes, TypePaths.TypePath path, ProblemReport problems) {
        JRealClassType baseType = SerializableTypeOracleBuilder.getBaseType(originalType);
        TreeLogger computationLogger = logger.branch(TreeLogger.DEBUG, "Finding possibly instantiable subtypes");
        List<JClassType> candidates = this.getPossiblyInstantiableSubtypes(computationLogger, (JClassType)baseType, problems);
        boolean anySubtypes = false;
        TreeLogger verificationLogger = logger.branch(TreeLogger.DEBUG, "Verifying instantiability");
        for (JClassType candidate : candidates) {
            if (SerializableTypeOracleBuilder.getBaseType(candidate) == baseType && originalType.isRawType() == null) {
                candidate = originalType;
            } else if ((candidate = this.constrainTypeBy(candidate, originalType)) == null) continue;
            if (!this.isAllowedByFilter(candidate, problems)) continue;
            TypePaths.TypePath subtypePath = TypePaths.createSubtypePath(path, (JType)candidate, originalType);
            TypeInfoComputed tic = this.getTypeInfoComputed((JType)candidate, subtypePath, true);
            if (tic.isDone()) {
                if (!tic.isInstantiable()) continue;
                anySubtypes = true;
                instSubtypes.add(candidate);
                continue;
            }
            if (tic.isPendingInstantiable()) {
                anySubtypes = true;
                instSubtypes.add(candidate);
                continue;
            }
            tic.setPendingInstantiable();
            TreeLogger subtypeLogger = verificationLogger.branch(TreeLogger.DEBUG, candidate.getParameterizedQualifiedSourceName());
            boolean instantiable = this.checkSubtype(subtypeLogger, candidate, originalType, subtypePath, problems);
            anySubtypes |= instantiable;
            tic.setInstantiable(instantiable);
            if (instantiable) {
                subtypeLogger.branch(TreeLogger.DEBUG, "Is instantiable");
            }
            if (!instantiable || instSubtypes == null) continue;
            instSubtypes.add(candidate);
        }
        return anySubtypes;
    }

    private boolean checkTypeArgument(TreeLogger logger, JGenericType baseType, int paramIndex, JClassType typeArg, TypePaths.TypePath parent, ProblemReport problems) {
        JGenericType declaringClass;
        JTypeParameter parameterOfTypeArgArray;
        JWildcardType isWildcard = typeArg.isWildcard();
        if (isWildcard != null) {
            return this.checkTypeArgument(logger, baseType, paramIndex, isWildcard.getUpperBound(), parent, problems);
        }
        JArrayType typeArgAsArray = typeArg.isArray();
        if (typeArgAsArray != null && (parameterOfTypeArgArray = typeArgAsArray.getLeafType().isTypeParameter()) != null && (declaringClass = parameterOfTypeArgArray.getDeclaringClass()) != null) {
            TypeParameterExposureComputer.TypeParameterFlowInfo flowInfoForArrayParam = this.getFlowInfo(declaringClass, parameterOfTypeArgArray.getOrdinal());
            TypeParameterExposureComputer.TypeParameterFlowInfo otherFlowInfo = this.getFlowInfo(baseType, paramIndex);
            if (otherFlowInfo.getExposure() >= 0 && otherFlowInfo.isTransitivelyAffectedBy(flowInfoForArrayParam)) {
                problems.add((JClassType)baseType, "Cannot serialize type '" + baseType.getParameterizedQualifiedSourceName() + "' when given an argument of type '" + typeArg.getParameterizedQualifiedSourceName() + "' because it appears to require serializing arrays " + "of unbounded dimension", ProblemReport.Priority.DEFAULT, new String[0]);
                return false;
            }
        }
        TypePaths.TypePath path = TypePaths.createTypeArgumentPath(parent, baseType, paramIndex, typeArg);
        int exposure = this.getTypeParameterExposure(baseType, paramIndex);
        switch (exposure) {
            case 0: {
                TreeLogger branch = logger.branch(TreeLogger.DEBUG, "Checking type argument " + paramIndex + " of type '" + baseType.getParameterizedQualifiedSourceName() + "' because it is directly exposed in this type or in one of its subtypes");
                return this.computeTypeInstantiability(branch, (JType)typeArg, path, problems).hasInstantiableSubtypes() || this.mightNotBeExposed(baseType, paramIndex);
            }
            case -1: {
                logger.log(TreeLogger.Type.DEBUG, "Ignoring type argument " + paramIndex + " of type '" + baseType.getParameterizedQualifiedSourceName() + "' because it is not exposed in this or any subtype");
                return true;
            }
        }
        assert (exposure >= 1);
        problems.add((JClassType)SerializableTypeOracleBuilder.getArrayType(this.typeOracle, exposure, (JType)typeArg), "Checking type argument " + paramIndex + " of type '" + baseType.getParameterizedQualifiedSourceName() + "' because it is exposed as an array with a maximum dimension of " + exposure + " in this type or one of its subtypes", ProblemReport.Priority.AUXILIARY, new String[0]);
        return this.computeTypeInstantiability(logger, (JType)SerializableTypeOracleBuilder.getArrayType(this.typeOracle, exposure, (JType)typeArg), path, problems).hasInstantiableSubtypes() || this.mightNotBeExposed(baseType, paramIndex);
    }

    private JClassType constrainTypeBy(JClassType type, JClassType superType) {
        return this.typeConstrainer.constrainTypeBy(type, superType);
    }

    private TypeParameterExposureComputer.TypeParameterFlowInfo getFlowInfo(JGenericType type, int index) {
        return this.typeParameterExposureComputer.computeTypeParameterExposure(type, index);
    }

    private List<JClassType> getPossiblyInstantiableSubtypes(TreeLogger logger, JClassType baseType, ProblemReport problems) {
        assert (baseType == SerializableTypeOracleBuilder.getBaseType(baseType));
        ArrayList<JClassType> possiblyInstantiableTypes = new ArrayList<JClassType>();
        if (baseType == this.typeOracle.getJavaLangObject()) {
            return possiblyInstantiableTypes;
        }
        ArrayList<JClassType> candidates = new ArrayList<JClassType>();
        candidates.add(baseType);
        List<JClassType> subtypes = Arrays.asList(baseType.getSubtypes());
        candidates.addAll(subtypes);
        for (JClassType subtype : candidates) {
            JRealClassType subtypeBase = SerializableTypeOracleBuilder.getBaseType(subtype);
            if (!this.maybeInstantiable(logger, (JClassType)subtypeBase, problems)) continue;
            JGenericType isGeneric = subtype.isGenericType();
            if (isGeneric != null) {
                subtype = isGeneric.asParameterizedByWildcards();
            } else assert (subtype instanceof JRealClassType);
            possiblyInstantiableTypes.add(subtype);
        }
        if (possiblyInstantiableTypes.size() == 0) {
            String[] possibilities = new String[candidates.size()];
            for (int i = 0; i < possibilities.length; ++i) {
                JClassType subtype = (JClassType)candidates.get(i);
                String worstMessage = problems.getWorstMessageForType(subtype);
                possibilities[i] = worstMessage == null ? "   subtype " + subtype.getParameterizedQualifiedSourceName() + " is not instantiable" : "   subtype " + worstMessage;
            }
            problems.add(baseType, baseType.getParameterizedQualifiedSourceName() + " has no available instantiable subtypes.", ProblemReport.Priority.DEFAULT, possibilities);
        }
        return possiblyInstantiableTypes;
    }

    private TypeInfoComputed getTypeInfoComputed(JType type, TypePaths.TypePath path, boolean createIfNeeded) {
        TypeInfoComputed tic = this.typeToTypeInfoComputed.get(type);
        if (tic == null && createIfNeeded) {
            tic = new TypeInfoComputed(type, path);
            this.typeToTypeInfoComputed.put(type, tic);
        }
        return tic;
    }

    private boolean isAllowedByFilter(JClassType classType, ProblemReport problems) {
        return SerializableTypeOracleBuilder.isAllowedByFilter(this.typeFilter, classType, problems);
    }

    private boolean isRawMapOrRawCollection(JClassType type) {
        if (type.asParameterizationOf(this.collectionClass) == this.collectionClass.asParameterizedByWildcards()) {
            return true;
        }
        return type.asParameterizationOf(this.mapClass) == this.mapClass.asParameterizedByWildcards();
    }

    private void logPath(TreeLogger logger, TypePaths.TypePath path) {
        if (path == null) {
            return;
        }
        logger.log(TreeLogger.DEBUG, ((Object)path).toString());
        this.logPath(logger, path.getParent());
    }

    private void logReachableTypes(TreeLogger logger) {
        PrintWriter printWriter = null;
        if (this.logOutputStream != null) {
            printWriter = new PrintWriter(this.logOutputStream);
            PrintWriterTreeLogger printWriterTreeLogger = new PrintWriterTreeLogger(printWriter);
            printWriterTreeLogger.setMaxDetail(TreeLogger.ALL);
            logger = printWriterTreeLogger;
        }
        logger.log(TreeLogger.DEBUG, "Reachable types computed on: " + new Date().toString());
        Set<JType> keySet = this.typeToTypeInfoComputed.keySet();
        JType[] types = keySet.toArray(new JType[0]);
        Arrays.sort(types, JTYPE_COMPARATOR);
        for (JType type : types) {
            TypeInfoComputed tic = this.typeToTypeInfoComputed.get(type);
            assert (tic != null);
            TreeLogger typeLogger = logger.branch(TreeLogger.DEBUG, tic.getType().getParameterizedQualifiedSourceName());
            TreeLogger serializationStatus = typeLogger.branch(TreeLogger.DEBUG, "Serialization status");
            if (tic.isInstantiable()) {
                serializationStatus.branch(TreeLogger.DEBUG, "Instantiable");
            } else if (tic.isFieldSerializable()) {
                serializationStatus.branch(TreeLogger.DEBUG, "Field serializable");
            } else {
                serializationStatus.branch(TreeLogger.DEBUG, "Not serializable");
            }
            TreeLogger pathLogger = typeLogger.branch(TreeLogger.DEBUG, "Path");
            this.logPath(pathLogger, tic.getPath());
            logger.log(TreeLogger.DEBUG, "");
        }
        if (printWriter != null) {
            printWriter.flush();
        }
    }

    private void markArrayTypesInstantiable(JType leafType, int maxRank, TypePaths.TypePath path) {
        for (int rank = 1; rank <= maxRank; ++rank) {
            JArrayType covariantArray = SerializableTypeOracleBuilder.getArrayType(this.typeOracle, rank, leafType);
            TypeInfoComputed covariantArrayTic = this.getTypeInfoComputed((JType)covariantArray, path, true);
            covariantArrayTic.setInstantiable(true);
        }
    }

    private boolean maybeInstantiable(TreeLogger logger, JClassType type, ProblemReport problems) {
        boolean success;
        boolean bl = success = SerializableTypeOracleBuilder.canBeInstantiated(type, problems) && this.shouldConsiderFieldsForSerialization(type, problems);
        if (success) {
            logger.log(TreeLogger.DEBUG, type.getParameterizedQualifiedSourceName() + " might be instantiable");
        }
        return success;
    }

    private boolean mightNotBeExposed(JGenericType baseType, int paramIndex) {
        TypeParameterExposureComputer.TypeParameterFlowInfo flowInfo = this.getFlowInfo(baseType, paramIndex);
        return flowInfo.getMightNotBeExposed() || SerializableTypeOracleBuilder.isManuallySerializable((JClassType)baseType);
    }

    private void pruneUnreachableTypes() {
        LinkedHashSet<JClassType> supersOfInstantiableTypes = new LinkedHashSet<JClassType>();
        for (TypeInfoComputed tic : this.typeToTypeInfoComputed.values()) {
            JClassType jClassType;
            if (!tic.isInstantiable() || !(tic.getType() instanceof JClassType)) continue;
            JClassType sup = jClassType = (JClassType)tic.getType().getErasedType();
            while (sup != null) {
                supersOfInstantiableTypes.add(sup.getErasedType());
                sup = sup.getErasedType().getSuperclass();
            }
        }
        LinkedHashSet<JType> toKill = new LinkedHashSet<JType>();
        for (TypeInfoComputed typeInfoComputed : this.typeToTypeInfoComputed.values()) {
            if (!typeInfoComputed.isFieldSerializable() || supersOfInstantiableTypes.contains(typeInfoComputed.getType().getErasedType())) continue;
            toKill.add(typeInfoComputed.getType());
        }
        for (JType jType : toKill) {
            this.typeToTypeInfoComputed.remove(jType);
        }
    }

    static {
        JPA_ENTITY_ANNOTATION = null;
        try {
            JDO_PERSISTENCE_CAPABLE_ANNOTATION = Class.forName("javax.jdo.annotations.PersistenceCapable").asSubclass(Annotation.class);
            JDO_PERSISTENCE_CAPABLE_DETACHABLE_METHOD = JDO_PERSISTENCE_CAPABLE_ANNOTATION.getDeclaredMethod("detachable", null);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
            JDO_PERSISTENCE_CAPABLE_ANNOTATION = null;
        }
        try {
            JPA_ENTITY_ANNOTATION = Class.forName("javax.persistence.Entity").asSubclass(Annotation.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TypeInfoComputed {
        private Set<JClassType> instantiableTypes = new HashSet<JClassType>();
        private final boolean autoSerializable;
        private final boolean directlyImplementsMarker;
        private boolean fieldSerializable = false;
        private boolean instantiable = false;
        private boolean instantiableSubtypes;
        private final JClassType manualSerializer;
        private final boolean maybeEnhanced;
        private final TypePaths.TypePath path;
        private TypeState state = TypeState.NOT_CHECKED;
        private final JType type;

        public TypeInfoComputed(JType type, TypePaths.TypePath path) {
            this.type = type;
            this.path = path;
            if (type instanceof JClassType) {
                JClassType typeClass = (JClassType)type;
                this.autoSerializable = SerializableTypeOracleBuilder.isAutoSerializable(typeClass);
                this.manualSerializer = SerializableTypeOracleBuilder.findCustomFieldSerializer(SerializableTypeOracleBuilder.this.typeOracle, (JType)typeClass);
                this.directlyImplementsMarker = SerializableTypeOracleBuilder.directlyImplementsMarkerInterface(typeClass);
                this.maybeEnhanced = SerializableTypeOracleBuilder.hasJdoAnnotation(typeClass) || SerializableTypeOracleBuilder.hasJpaAnnotation(typeClass);
            } else {
                this.autoSerializable = false;
                this.manualSerializer = null;
                this.directlyImplementsMarker = false;
                this.maybeEnhanced = false;
            }
        }

        public Set<JClassType> getInstantiableTypes() {
            return this.instantiableTypes;
        }

        public JClassType getManualSerializer() {
            return this.manualSerializer;
        }

        public TypePaths.TypePath getPath() {
            return this.path;
        }

        public JType getType() {
            return this.type;
        }

        public boolean hasInstantiableSubtypes() {
            return this.isInstantiable() || this.instantiableSubtypes || this.isPendingInstantiable();
        }

        public boolean isAutoSerializable() {
            return this.autoSerializable;
        }

        public boolean isDeclaredSerializable() {
            return this.autoSerializable || this.isManuallySerializable();
        }

        public boolean isDirectlySerializable() {
            return this.directlyImplementsMarker || this.isManuallySerializable();
        }

        public boolean isDone() {
            return this.state == TypeState.CHECK_DONE;
        }

        public boolean isFieldSerializable() {
            return this.fieldSerializable;
        }

        public boolean isInstantiable() {
            return this.instantiable;
        }

        public boolean isManuallySerializable() {
            return this.manualSerializer != null;
        }

        public boolean isPendingInstantiable() {
            return this.state == TypeState.CHECK_IN_PROGRESS;
        }

        public boolean maybeEnhanced() {
            return this.maybeEnhanced;
        }

        public void setFieldSerializable() {
            this.fieldSerializable = true;
        }

        public void setInstantiable(boolean instantiable) {
            this.instantiable = instantiable;
            if (instantiable) {
                this.fieldSerializable = true;
            }
            this.state = TypeState.CHECK_DONE;
        }

        public void setInstantiableSubtypes(boolean instantiableSubtypes) {
            this.instantiableSubtypes = instantiableSubtypes;
        }

        public void setPendingInstantiable() {
            this.state = TypeState.CHECK_IN_PROGRESS;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TypeState {
        CHECK_DONE("Check succeeded"),
        CHECK_IN_PROGRESS("Check in progress"),
        NOT_CHECKED("Not checked");

        private final String message;

        private TypeState(String message) {
            this.message = message;
        }

        public String toString() {
            return this.message;
        }
    }
}

