/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind.rpc;

import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JGenericType;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JRawType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.JWildcardType;
import com.google.gwt.user.rebind.rpc.JTypeVisitor;

class JModTypeVisitor
extends JTypeVisitor {
    protected JType replacement;

    JModTypeVisitor() {
    }

    public void accept(JType type) {
        this.replacement = type;
        this.acceptChildren(type);
        this.endVisit(this.replacement);
    }

    public JClassType transform(JClassType type) {
        return (JClassType)this.transform((JType)type);
    }

    public JGenericType transform(JGenericType type) {
        return (JGenericType)this.transform((JType)type);
    }

    public JPrimitiveType transform(JPrimitiveType type) {
        return (JPrimitiveType)this.transform((JType)type);
    }

    public JType transform(JType type) {
        this.accept(type);
        return this.replacement;
    }

    protected void acceptChildren(JType type) {
        JWildcardType typeWild;
        JRawType typeRaw;
        JParameterizedType typeParameterized;
        JArrayType typeArray = type.isArray();
        if (typeArray != null) {
            JType newComponentType;
            JType oldComponentType = typeArray.getComponentType();
            this.replacement = oldComponentType == (newComponentType = this.transform(oldComponentType)) ? type : typeArray.getOracle().getArrayType(newComponentType);
        }
        if ((typeParameterized = type.isParameterized()) != null) {
            JGenericType oldBaseType = typeParameterized.getBaseType();
            JGenericType newBaseType = this.transform(oldBaseType);
            JClassType oldEnclosingType = typeParameterized.getEnclosingType();
            JClassType newEnclosingType = oldEnclosingType == null ? null : this.transform(oldEnclosingType);
            JClassType[] oldTypeArgs = typeParameterized.getTypeArgs();
            JClassType[] newTypeArgs = new JClassType[oldTypeArgs.length];
            boolean argsAllSame = true;
            for (int i = 0; i < oldTypeArgs.length; ++i) {
                newTypeArgs[i] = this.transform(oldTypeArgs[i]);
                if (newTypeArgs[i] == oldTypeArgs[i]) continue;
                argsAllSame = false;
            }
            this.replacement = argsAllSame && oldBaseType == newBaseType && oldEnclosingType == newEnclosingType ? type : typeParameterized.getOracle().getParameterizedType(newBaseType, newEnclosingType, newTypeArgs);
        }
        if ((typeRaw = type.isRawType()) != null) {
            JGenericType newBaseType;
            JGenericType oldBaseType = typeRaw.getBaseType();
            this.replacement = oldBaseType == (newBaseType = this.transform(oldBaseType)) ? type : newBaseType.getRawType();
        }
        if ((typeWild = type.isWildcard()) != null) {
            JClassType newBound;
            JClassType oldBound = typeWild.getFirstBound();
            this.replacement = oldBound == (newBound = this.transform(oldBound)) ? type : typeWild.getOracle().getWildcardType(typeWild.getBoundType(), newBound);
        }
    }
}

