/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind.model;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.model.OwnerFieldClass;

public class OwnerField {
    private final String name;
    private final OwnerFieldClass fieldType;
    private final boolean isProvided;

    public OwnerField(JField field, MortalLogger logger) throws UnableToCompleteException {
        this.name = field.getName();
        JClassType fieldClassType = field.getType().isClassOrInterface();
        if (fieldClassType == null) {
            logger.die("Type for field " + this.name + " is not a class: " + field.getType().getSimpleSourceName(), new Object[0]);
        }
        this.fieldType = OwnerFieldClass.getFieldClass(fieldClassType, logger);
        UiField annotation = (UiField)field.getAnnotation(UiField.class);
        if (annotation == null) {
            logger.die("Field " + this.name + " is not annotated with @UiField", new Object[0]);
        }
        this.isProvided = annotation.provided();
    }

    public String getName() {
        return this.name;
    }

    public OwnerFieldClass getType() {
        return this.fieldType;
    }

    public boolean isProvided() {
        return this.isProvided;
    }

    public String toString() {
        return String.format("%s.%s#%s", this.fieldType.getRawType().getPackage(), this.fieldType.getRawType().getName(), this.name);
    }
}

