/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind.model;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JField;
import com.google.gwt.core.ext.typeinfo.JGenericType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.uibinder.client.UiFactory;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.model.OwnerField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwnerClass {
    private final Map<String, OwnerField> uiFields = new TreeMap<String, OwnerField>();
    private final Map<JClassType, OwnerField> uiFieldTypes = new HashMap<JClassType, OwnerField>();
    private final Map<JClassType, JMethod> uiFactories = new HashMap<JClassType, JMethod>();
    private final List<JMethod> uiHandlers = new ArrayList<JMethod>();
    private final MortalLogger logger;

    public OwnerClass(JClassType ownerType, MortalLogger logger) throws UnableToCompleteException {
        this.logger = logger;
        this.findUiFields(ownerType);
        this.findUiFactories(ownerType);
        this.findUiHandlers(ownerType);
    }

    public JMethod getUiFactoryMethod(JClassType forType) {
        JGenericType genericType = forType.isGenericType();
        if (genericType != null) {
            forType = genericType.getRawType();
        }
        return this.uiFactories.get(forType);
    }

    public OwnerField getUiField(String name) {
        return this.uiFields.get(name);
    }

    @Deprecated
    public OwnerField getUiFieldForType(JClassType type) {
        return this.uiFieldTypes.get(type);
    }

    public Collection<OwnerField> getUiFields() {
        return this.uiFields.values();
    }

    public List<JMethod> getUiHandlers() {
        return this.uiHandlers;
    }

    private void findUiFactories(JClassType ownerType) throws UnableToCompleteException {
        JMethod[] methods;
        for (JMethod method : methods = ownerType.getMethods()) {
            JParameterizedType paramType;
            if (!method.isAnnotationPresent(UiFactory.class)) continue;
            JClassType factoryType = method.getReturnType().isClassOrInterface();
            if (factoryType == null) {
                this.logger.die("Factory return type is not a class in method " + method.getName(), new Object[0]);
            }
            if ((paramType = factoryType.isParameterized()) != null) {
                factoryType = paramType.getRawType();
            }
            if (this.uiFactories.containsKey(factoryType)) {
                this.logger.die("Duplicate factory in class " + method.getEnclosingType().getName() + " for type " + factoryType.getName(), new Object[0]);
            }
            this.uiFactories.put(factoryType, method);
        }
        JClassType superclass = ownerType.getSuperclass();
        if (superclass != null) {
            this.findUiFactories(superclass);
        }
    }

    private void findUiFields(JClassType ownerType) throws UnableToCompleteException {
        JField[] fields;
        for (JField field : fields = ownerType.getFields()) {
            if (!field.isAnnotationPresent(UiField.class)) continue;
            JClassType ownerFieldType = field.getType().isClassOrInterface();
            if (ownerFieldType == null) {
                this.logger.die("Field type is not a class in field " + field.getName(), new Object[0]);
            }
            OwnerField ownerField = new OwnerField(field, this.logger);
            String ownerFieldName = field.getName();
            this.uiFields.put(ownerFieldName, ownerField);
            this.uiFieldTypes.put(ownerFieldType, ownerField);
        }
        JClassType superclass = ownerType.getSuperclass();
        if (superclass != null) {
            this.findUiFields(superclass);
        }
    }

    private void findUiHandlers(JClassType ownerType) {
        JMethod[] methods;
        for (JMethod method : methods = ownerType.getMethods()) {
            if (!method.isAnnotationPresent(UiHandler.class)) continue;
            this.uiHandlers.add(method);
        }
        JClassType superclass = ownerType.getSuperclass();
        if (superclass != null) {
            this.findUiHandlers(superclass);
        }
    }
}

