/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind.messages;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.uibinder.rebind.IndentedWriter;
import com.google.gwt.uibinder.rebind.MortalLogger;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLAttribute;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.uibinder.rebind.messages.AttributeMessage;
import com.google.gwt.uibinder.rebind.messages.GenerateAnnotationWriter;
import com.google.gwt.uibinder.rebind.messages.MessageWriter;
import com.google.gwt.uibinder.rebind.messages.PlaceholderWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesWriter {
    public static final String ATTRIBUTE = "attribute";
    private static final String NAME = "name";
    private static final String[] EMPTY_ARRAY = new String[0];
    private final String messagesNamespaceURI;
    private final String packageName;
    private final String messagesClassName;
    private final MortalLogger logger;
    private final List<MessageWriter> messages = new ArrayList<MessageWriter>();
    private final String generatedFrom;
    private String defaultLocale;
    private String messagesPrefix;
    private String generateKeys;
    private GenerateAnnotationWriter generate;
    private Map<XMLElement, Collection<AttributeMessage>> elemToAttributeMessages = new HashMap<XMLElement, Collection<AttributeMessage>>();

    public MessagesWriter(String nameSpaceUri, MortalLogger mortalLogger, String generatedFrom, String packageName, String uiBinderImplClassName) {
        this.messagesNamespaceURI = nameSpaceUri;
        this.generatedFrom = generatedFrom;
        this.packageName = packageName;
        this.messagesClassName = uiBinderImplClassName.replaceAll("_", "") + "GenMessages";
        this.logger = mortalLogger;
    }

    public void consumeAndStoreMessageAttributesFor(XMLElement elem) throws UnableToCompleteException {
        Collection<AttributeMessage> attributeMessages = this.consumeAttributeMessages(elem);
        if (!attributeMessages.isEmpty()) {
            this.elemToAttributeMessages.put(elem, attributeMessages);
        }
    }

    public Collection<AttributeMessage> consumeAttributeMessages(XMLElement elem) throws UnableToCompleteException {
        Collection<XMLElement> messageChildren = this.getAttributeMessageChildren(elem);
        if (messageChildren.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<AttributeMessage> attributeMessages = new HashSet<AttributeMessage>();
        for (XMLElement child : messageChildren) {
            XMLAttribute attribute;
            String attributeName = this.consumeMessageElementAttribute(NAME, child);
            if (attributeName.length() == 0) {
                this.logger.die("Missing name attribute in %s", child);
            }
            if (!elem.hasAttribute(attributeName)) {
                this.logger.die("%s has no attribute matching %s", elem, child);
            }
            if ((attribute = elem.getAttribute(attributeName)).hasComputedValue()) {
                this.logger.die("In %s, attribute \"%s\" has a field reference and so cannot be marked for localization, but found %s", elem, attributeName, child);
            }
            String defaultMessage = MessageWriter.escapeMessageFormat(elem.consumeRawAttribute(attributeName));
            defaultMessage = UiBinderWriter.escapeTextForJavaStringLiteral(defaultMessage);
            attributeMessages.add(new AttributeMessage(attributeName, this.declareMessage(child, defaultMessage)));
        }
        return attributeMessages;
    }

    public String consumeMessageAttribute(String attName, XMLElement elem) {
        String fullAttName = this.getMessagesPrefix() + ":" + attName;
        return elem.consumeRawAttribute(fullAttName, "");
    }

    public String declareMessage(MessageWriter newMessage) {
        this.messages.add(newMessage);
        return String.format("messages.%s", newMessage.getInvocation());
    }

    public void findMessagesConfig(XMLElement elem) {
        String prefix = elem.lookupPrefix(this.getMessagesUri());
        if (prefix != null) {
            this.messagesPrefix = prefix;
            this.defaultLocale = this.consumeMessageAttribute("defaultLocale", elem);
            this.generateKeys = this.consumeMessageAttribute("generateKeys", elem);
            this.generate = new GenerateAnnotationWriter(this.getMessageAttributeStringArray("generateFormat", elem), this.consumeMessageAttribute("generateFilename", elem), this.getMessageAttributeStringArray("generateLocales", elem));
        }
    }

    public String getDeclaration() {
        return String.format("static %1$s messages = (%1$s) GWT.create(%1$s.class);", this.getMessagesClassName());
    }

    public String getMessagesClassName() {
        return this.messagesClassName;
    }

    public String getMessagesPrefix() {
        return this.messagesPrefix;
    }

    public boolean hasMessageAttribute(String attName, XMLElement elem) {
        String fullAttName = this.getMessagesPrefix() + ":" + attName;
        return elem.hasAttribute(fullAttName);
    }

    public boolean hasMessages() {
        return !this.messages.isEmpty();
    }

    public boolean isMessage(XMLElement elem) {
        return this.isMessagePrefixed(elem) && "msg".equals(elem.getLocalName());
    }

    public MessageWriter newMessage(XMLElement elem) {
        MessageWriter newMessage = new MessageWriter(this.consumeMessageElementAttribute("description", elem), this.consumeMessageElementAttribute("key", elem), this.consumeMessageElementAttribute("meaning", elem), this.nextMessageName());
        return newMessage;
    }

    public Collection<AttributeMessage> retrieveMessageAttributesFor(XMLElement elem) {
        return this.elemToAttributeMessages.get(elem);
    }

    public void write(PrintWriter printWriter) {
        IndentedWriter writer = new IndentedWriter(printWriter);
        if (this.packageName.length() > 0) {
            writer.write("package %1$s;", this.packageName);
            writer.newline();
        }
        writer.write("import com.google.gwt.i18n.client.Messages;");
        writer.write("import static com.google.gwt.i18n.client.LocalizableResource.*;");
        writer.newline();
        this.genInterfaceAnnotations(writer);
        writer.write("public interface %s extends Messages {", this.getMessagesClassName());
        writer.newline();
        writer.indent();
        for (MessageWriter m : this.messages) {
            m.writeDeclaration(writer);
        }
        writer.outdent();
        writer.write("}");
    }

    String consumeMessageElementAttribute(String attName, XMLElement elem) {
        if (elem.hasAttribute(attName)) {
            return UiBinderWriter.escapeTextForJavaStringLiteral(elem.consumeRawAttribute(attName));
        }
        String fullAttName = this.getMessagesPrefix() + ":" + attName;
        if (elem.hasAttribute(fullAttName)) {
            String value = elem.consumeRawAttribute(fullAttName);
            this.logger.warn("In %s, deprecated prefix \"%s:\" on \"%s\". Use \"%s\" instead.", elem, this.getMessagesPrefix(), fullAttName, attName);
            return value;
        }
        return "";
    }

    String consumeRequiredMessageElementAttribute(String attName, XMLElement elem) throws UnableToCompleteException {
        String value = this.consumeMessageElementAttribute(attName, elem);
        if ("".equals(value)) {
            this.logger.die("%s does not have required attribute %s", elem, attName);
        }
        return value;
    }

    boolean isMessagePrefixed(XMLElement elem) {
        String uri = elem.getNamespaceUri();
        return uri != null && uri.startsWith(this.getMessagesUri());
    }

    private String declareMessage(XMLElement elem, String defaultMessage) {
        List<PlaceholderWriter> emptyList = Collections.emptyList();
        MessageWriter newMessage = this.newMessage(elem);
        newMessage.setDefaultMessage(defaultMessage);
        for (PlaceholderWriter placeholder : emptyList) {
            newMessage.addPlaceholder(placeholder);
        }
        return this.declareMessage(newMessage);
    }

    private void genInterfaceAnnotations(IndentedWriter pw) {
        pw.write("@GeneratedFrom(\"%s\")", this.generatedFrom);
        if (this.defaultLocale.length() > 0) {
            pw.write("@DefaultLocale(\"%s\")", this.defaultLocale);
        }
        if (this.generateKeys.length() > 0) {
            pw.write("@GenerateKeys(\"%s\")", this.generateKeys);
        }
        this.generate.write(pw);
    }

    private Collection<XMLElement> getAttributeMessageChildren(final XMLElement elem) throws UnableToCompleteException {
        return elem.consumeChildElements(new XMLElement.Interpreter<Boolean>(){

            @Override
            public Boolean interpretElement(XMLElement child) throws UnableToCompleteException {
                if (MessagesWriter.this.isAttributeMessage(child)) {
                    if (child.hasChildNodes()) {
                        MessagesWriter.this.logger.die("Illegal body for %s in %s.", child, elem);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private String[] getMessageAttributeStringArray(String attName, XMLElement elem) {
        String value = this.consumeMessageAttribute(attName, elem);
        if (value == null) {
            return EMPTY_ARRAY;
        }
        return value.split("\\s*,\\s*");
    }

    private String getMessagesUri() {
        return this.messagesNamespaceURI;
    }

    private boolean isAttributeMessage(XMLElement elem) {
        return this.isMessagePrefixed(elem) && ATTRIBUTE.equals(elem.getLocalName());
    }

    private String nextMessageName() {
        return String.format("message%d", this.messages.size() + 1);
    }
}

