/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind;

import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.uibinder.rebind.FieldManager;
import com.google.gwt.uibinder.rebind.FieldWriter;
import com.google.gwt.uibinder.rebind.MonitoredLogger;
import java.util.LinkedHashSet;

public class FieldReference {
    private final FieldManager fieldManager;
    private final String debugString;
    private final String[] elements;
    private final LinkedHashSet<JType> leftHandTypes = new LinkedHashSet();
    private final TypeOracle types;

    FieldReference(String reference, FieldManager fieldManager, TypeOracle types) {
        this.debugString = "{" + reference + "}";
        this.fieldManager = fieldManager;
        this.types = types;
        this.elements = reference.split("\\.");
    }

    public void addLeftHandType(JType type) {
        this.leftHandTypes.add(type);
    }

    public String getFieldName() {
        return this.elements[0];
    }

    public String toString() {
        return this.debugString;
    }

    public void validate(MonitoredLogger logger) {
        JType myReturnType = this.findReturnType(logger);
        if (myReturnType == null) {
            return;
        }
        for (JType t : this.leftHandTypes) {
            this.ensureAssignable(t, myReturnType, logger);
        }
    }

    private void ensureAssignable(JType leftHandType, JType rightHandType, MonitoredLogger logger) {
        JClassType rightClass;
        if (leftHandType == rightHandType) {
            return;
        }
        if (this.handleMismatchedNumbers(leftHandType, rightHandType)) {
            return;
        }
        if (this.handleMismatchedNonNumericPrimitives(leftHandType, rightHandType, logger)) {
            return;
        }
        JClassType leftClass = leftHandType.isClassOrInterface();
        if (!(leftClass == null || (rightClass = rightHandType.isClassOrInterface()) != null && leftClass.isAssignableFrom(rightClass))) {
            this.logTypeMismatch(leftHandType, rightHandType, logger);
        }
    }

    private JType findReturnType(MonitoredLogger logger) {
        FieldWriter field = this.fieldManager.lookup(this.elements[0]);
        if (field == null) {
            logger.error("No field named %s", this.elements[0]);
            return null;
        }
        return field.getReturnType(this.elements, logger);
    }

    private boolean handleMismatchedNonNumericPrimitives(JType leftHandType, JType rightHandType, MonitoredLogger logger) {
        JPrimitiveType leftPrimitive = leftHandType.isPrimitive();
        JPrimitiveType rightPrimitive = rightHandType.isPrimitive();
        if (leftPrimitive == null && rightPrimitive == null) {
            return false;
        }
        if (leftPrimitive != null) {
            JClassType autobox = this.types.findType(leftPrimitive.getQualifiedBoxedSourceName());
            if (rightHandType != autobox) {
                logger.error("Returns %s, can't be used as %s", rightHandType, leftHandType);
            }
        } else {
            JClassType autobox = this.types.findType(rightPrimitive.getQualifiedBoxedSourceName());
            if (leftHandType != autobox) {
                logger.error("Returns %s, can't be used as %s", rightHandType, leftHandType);
            }
        }
        return true;
    }

    private boolean handleMismatchedNumbers(JType leftHandType, JType rightHandType) {
        return this.isNumber(leftHandType) && this.isNumber(rightHandType) && rightHandType.isPrimitive() != null;
    }

    private boolean isNumber(JType t) {
        JClassType numberType = this.types.findType(Number.class.getCanonicalName());
        JClassType asClass = t.isClass();
        if (asClass != null) {
            return numberType.isAssignableFrom(asClass);
        }
        JPrimitiveType asPrimitive = t.isPrimitive();
        if (asPrimitive != null) {
            JClassType autoboxed = this.types.findType(asPrimitive.getQualifiedBoxedSourceName());
            return numberType.isAssignableFrom(autoboxed);
        }
        return false;
    }

    private void logTypeMismatch(JType leftHandType, JType rightHandType, MonitoredLogger logger) {
        logger.error("Returns %s, can't be used as %s", rightHandType, leftHandType);
    }
}

