/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rebind.context;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.dev.util.Util;
import com.google.gwt.resources.rebind.context.AbstractResourceContext;
import java.io.IOException;
import java.io.OutputStream;

class StaticResourceContext
extends AbstractResourceContext {
    static final String ENABLE_RENAMING = "ClientBundle.enableRenaming";

    StaticResourceContext(TreeLogger logger, GeneratorContext context, JClassType resourceBundleType) {
        super(logger, context, resourceBundleType);
    }

    public String deploy(String suggestedFileName, String mimeType, byte[] data, boolean xhrCompatible) throws UnableToCompleteException {
        String outputName;
        TreeLogger logger = this.getLogger();
        GeneratorContext context = this.getGeneratorContext();
        PropertyOracle propertyOracle = context.getPropertyOracle();
        String enableRenaming = null;
        try {
            ConfigurationProperty prop = propertyOracle.getConfigurationProperty(ENABLE_RENAMING);
            enableRenaming = (String)prop.getValues().get(0);
        }
        catch (BadPropertyValueException e) {
            logger.log(TreeLogger.ERROR, "Bad value for ClientBundle.enableRenaming", (Throwable)e);
            throw new UnableToCompleteException();
        }
        if (Boolean.parseBoolean(enableRenaming)) {
            String strongName = Util.computeStrongName((byte[])data);
            int lastIdx = suggestedFileName.lastIndexOf(46);
            String extension = lastIdx != -1 ? suggestedFileName.substring(lastIdx + 1) : "noext";
            outputName = strongName + ".cache." + extension;
        } else {
            outputName = suggestedFileName.substring(suggestedFileName.lastIndexOf(47) + 1);
        }
        OutputStream out = context.tryCreateResource(logger, outputName);
        if (out != null) {
            try {
                out.write(data);
            }
            catch (IOException e) {
                logger.log(TreeLogger.ERROR, "Unable to write data to output name " + outputName, (Throwable)e);
                throw new UnableToCompleteException();
            }
            context.commitResource(logger, out);
            logger.log(TreeLogger.DEBUG, "Copied " + data.length + " bytes to " + outputName, null);
        }
        return "GWT.getModuleBaseURL() + \"" + outputName + "\"";
    }

    public boolean supportsDataUrls() {
        return false;
    }
}

