/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rebind.context;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.SelectionProperty;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.generator.NameFactory;
import com.google.gwt.dev.util.Util;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.ClientBundleWithLookup;
import com.google.gwt.resources.client.ResourcePrototype;
import com.google.gwt.resources.ext.ClientBundleFields;
import com.google.gwt.resources.ext.ClientBundleRequirements;
import com.google.gwt.resources.ext.ResourceContext;
import com.google.gwt.resources.ext.ResourceGenerator;
import com.google.gwt.resources.ext.ResourceGeneratorType;
import com.google.gwt.resources.rebind.context.AbstractResourceContext;
import com.google.gwt.resources.rg.BundleResourceGenerator;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClientBundleGenerator
extends Generator {
    public final String generate(TreeLogger logger, GeneratorContext generatorContext, String typeName) throws UnableToCompleteException {
        TypeOracle typeOracle = generatorContext.getTypeOracle();
        JClassType sourceType = typeOracle.findType(typeName);
        if (sourceType == null) {
            logger.log(TreeLogger.ERROR, "Could not find requested typeName");
            throw new UnableToCompleteException();
        }
        if (sourceType.isInterface() == null) {
            logger.log(TreeLogger.ERROR, sourceType.getQualifiedSourceName() + " is not an interface.", null);
            throw new UnableToCompleteException();
        }
        Map<Class<? extends ResourceGenerator>, List<JMethod>> taskList = this.createTaskList(logger, typeOracle, sourceType);
        AbstractResourceContext resourceContext = this.createResourceContext(logger, generatorContext, sourceType);
        FieldsImpl fields = new FieldsImpl();
        RequirementsImpl requirements = new RequirementsImpl(generatorContext.getPropertyOracle());
        this.doAddFieldsAndRequirements(logger, generatorContext, fields, requirements);
        Map<ResourceGenerator, List<JMethod>> generators = this.initAndPrepare(logger, taskList, resourceContext, requirements);
        String generatedSimpleSourceName = this.generateSimpleSourceName(logger, resourceContext, requirements);
        String packageName = sourceType.getPackage().getName();
        String createdClassName = packageName + "." + generatedSimpleSourceName;
        PrintWriter out = generatorContext.tryCreate(logger, packageName, generatedSimpleSourceName);
        if (out != null) {
            this.doCreateBundleForPermutation(logger, generatorContext, fields, generatedSimpleSourceName);
            ClassSourceFileComposerFactory f = new ClassSourceFileComposerFactory(packageName, generatedSimpleSourceName);
            f.addImport(GWT.class.getName());
            f.addImport(ResourcePrototype.class.getName());
            f.addImplementedInterface(sourceType.getQualifiedSourceName());
            SourceWriter sw = f.createSourceWriter(generatorContext, out);
            resourceContext.setSimpleSourceName(generatedSimpleSourceName);
            this.createFieldsAndAssignments(logger, sw, generators, resourceContext, fields);
            sw.println(fields.getCode());
            taskList.remove(BundleResourceGenerator.class);
            this.writeMapMethods(logger, createdClassName, sw, taskList);
            sw.commit(logger);
        }
        this.finish(logger, resourceContext, generators.keySet());
        this.doFinish(logger);
        return createdClassName;
    }

    protected abstract AbstractResourceContext createResourceContext(TreeLogger var1, GeneratorContext var2, JClassType var3) throws UnableToCompleteException;

    protected void doAddFieldsAndRequirements(TreeLogger logger, GeneratorContext context, FieldsImpl fields, ClientBundleRequirements requirements) throws UnableToCompleteException {
    }

    protected void doCreateBundleForPermutation(TreeLogger logger, GeneratorContext generatorContext, FieldsImpl fields, String generatedSimpleSourceName) throws UnableToCompleteException {
    }

    protected void doFinish(TreeLogger logger) throws UnableToCompleteException {
    }

    private boolean createFieldsAndAssignments(TreeLogger logger, AbstractResourceContext resourceContext, ResourceGenerator rg, List<JMethod> generatorMethods, SourceWriter sw, ClientBundleFields fields) {
        boolean fail = false;
        resourceContext.setCurrentResourceGenerator(rg);
        try {
            rg.createFields(logger.branch(TreeLogger.DEBUG, "Creating fields"), resourceContext, fields);
        }
        catch (UnableToCompleteException e) {
            return false;
        }
        for (JMethod m : generatorMethods) {
            String rhs;
            try {
                rhs = rg.createAssignment(logger.branch(TreeLogger.DEBUG, "Creating assignment for " + m.getName() + "()"), resourceContext, m);
            }
            catch (UnableToCompleteException e) {
                fail = true;
                continue;
            }
            String ident = fields.define((JType)m.getReturnType().isClassOrInterface(), m.getName(), null, true, false);
            sw.print(m.getReadableDeclaration(false, true, true, true, true));
            sw.println(" {");
            sw.indent();
            sw.println("if (" + ident + " == null) {");
            sw.indent();
            sw.println(ident + " = " + rhs + ";");
            sw.outdent();
            sw.println("}");
            sw.println("return " + ident + ";");
            sw.outdent();
            sw.println("}");
        }
        return !fail;
    }

    private void createFieldsAndAssignments(TreeLogger logger, SourceWriter sw, Map<ResourceGenerator, List<JMethod>> generators, AbstractResourceContext resourceContext, ClientBundleFields fields) throws UnableToCompleteException {
        boolean success = true;
        for (Map.Entry<ResourceGenerator, List<JMethod>> entry : generators.entrySet()) {
            success &= this.createFieldsAndAssignments(logger, resourceContext, entry.getKey(), entry.getValue(), sw, fields);
        }
        if (!success) {
            throw new UnableToCompleteException();
        }
    }

    private Map<Class<? extends ResourceGenerator>, List<JMethod>> createTaskList(TreeLogger logger, TypeOracle typeOracle, JClassType sourceType) throws UnableToCompleteException {
        LinkedHashMap<Class<? extends ResourceGenerator>, List<JMethod>> toReturn = new LinkedHashMap<Class<? extends ResourceGenerator>, List<JMethod>>();
        JClassType bundleType = typeOracle.findType(ClientBundle.class.getName());
        assert (bundleType != null);
        JClassType bundleWithLookupType = typeOracle.findType(ClientBundleWithLookup.class.getName());
        assert (bundleWithLookupType != null);
        JClassType resourcePrototypeType = typeOracle.findType(ResourcePrototype.class.getName());
        assert (resourcePrototypeType != null);
        boolean throwException = false;
        for (JMethod m : sourceType.getOverridableMethods()) {
            JClassType returnType = m.getReturnType().isClassOrInterface();
            if (m.getEnclosingType().equals((Object)bundleType) || m.getEnclosingType().equals((Object)bundleWithLookupType) || !m.isAbstract()) continue;
            if (returnType == null || !returnType.isAssignableTo(resourcePrototypeType) && !returnType.isAssignableTo(bundleType)) {
                logger.log(TreeLogger.ERROR, "Unable to implement " + m.getName() + " because it does not derive from " + resourcePrototypeType.getQualifiedSourceName() + " or " + bundleType.getQualifiedSourceName());
                throwException = true;
                continue;
            }
            try {
                List<JMethod> generatorMethods;
                Class<? extends ResourceGenerator> clazz = this.findResourceGenerator(logger, m);
                if (toReturn.containsKey(clazz)) {
                    generatorMethods = (List)toReturn.get(clazz);
                } else {
                    generatorMethods = new ArrayList();
                    toReturn.put(clazz, generatorMethods);
                }
                generatorMethods.add(m);
            }
            catch (UnableToCompleteException e) {
                throwException = true;
            }
        }
        if (throwException) {
            throw new UnableToCompleteException();
        }
        return toReturn;
    }

    private Class<? extends ResourceGenerator> findResourceGenerator(TreeLogger logger, JMethod method) throws UnableToCompleteException {
        JClassType resourceType = method.getReturnType().isClassOrInterface();
        assert (resourceType != null);
        ResourceGeneratorType annotation = (ResourceGeneratorType)resourceType.findAnnotationInTypeHierarchy(ResourceGeneratorType.class);
        if (annotation == null) {
            logger.log(TreeLogger.ERROR, "No @" + ResourceGeneratorType.class.getName() + " was specifed for type " + resourceType.getQualifiedSourceName() + " or its supertypes");
            throw new UnableToCompleteException();
        }
        return annotation.value();
    }

    private void finish(TreeLogger logger, AbstractResourceContext context, Collection<ResourceGenerator> generators) throws UnableToCompleteException {
        boolean fail = false;
        for (ResourceGenerator rg : generators) {
            context.setCurrentResourceGenerator(rg);
            try {
                rg.finish(logger.branch(TreeLogger.DEBUG, "Finishing ResourceGenerator"), context);
            }
            catch (UnableToCompleteException e) {
                fail = true;
            }
        }
        if (fail) {
            throw new UnableToCompleteException();
        }
    }

    private String generateSimpleSourceName(TreeLogger logger, ResourceContext context, RequirementsImpl requirements) throws UnableToCompleteException {
        StringBuilder toReturn = new StringBuilder(context.getClientBundleType().getQualifiedSourceName().replaceAll("[.$]", "_"));
        HashSet<String> permutationAxes = new HashSet<String>(requirements.axes);
        permutationAxes.add("locale");
        try {
            PropertyOracle oracle = context.getGeneratorContext().getPropertyOracle();
            for (String property : permutationAxes) {
                SelectionProperty prop = oracle.getSelectionProperty(logger, property);
                String value = prop.getCurrentValue();
                toReturn.append("_" + value);
            }
        }
        catch (BadPropertyValueException e) {
            // empty catch block
        }
        toReturn.append("_" + ((Object)((Object)this)).getClass().getSimpleName());
        return toReturn.toString();
    }

    private boolean initAndPrepare(TreeLogger logger, AbstractResourceContext resourceContext, ResourceGenerator rg, List<JMethod> generatorMethods, ClientBundleRequirements requirements) {
        try {
            resourceContext.setCurrentResourceGenerator(rg);
            rg.init(logger.branch(TreeLogger.DEBUG, "Initializing ResourceGenerator"), resourceContext);
        }
        catch (UnableToCompleteException e) {
            return false;
        }
        boolean fail = false;
        for (JMethod m : generatorMethods) {
            try {
                rg.prepare(logger.branch(TreeLogger.DEBUG, "Preparing method " + m.getName()), resourceContext, requirements, m);
            }
            catch (UnableToCompleteException e) {
                fail = true;
            }
        }
        return !fail;
    }

    private Map<ResourceGenerator, List<JMethod>> initAndPrepare(TreeLogger logger, Map<Class<? extends ResourceGenerator>, List<JMethod>> taskList, AbstractResourceContext resourceContext, ClientBundleRequirements requirements) throws UnableToCompleteException {
        boolean success = true;
        IdentityHashMap<ResourceGenerator, List<JMethod>> toReturn = new IdentityHashMap<ResourceGenerator, List<JMethod>>();
        for (Map.Entry<Class<? extends ResourceGenerator>, List<JMethod>> entry : taskList.entrySet()) {
            ResourceGenerator rg = this.instantiateResourceGenerator(logger, entry.getKey());
            toReturn.put(rg, entry.getValue());
            success &= this.initAndPrepare(logger, resourceContext, rg, entry.getValue(), requirements);
        }
        if (!success) {
            throw new UnableToCompleteException();
        }
        return toReturn;
    }

    private <T extends ResourceGenerator> T instantiateResourceGenerator(TreeLogger logger, Class<T> generatorClass) throws UnableToCompleteException {
        try {
            return (T)((ResourceGenerator)generatorClass.newInstance());
        }
        catch (InstantiationException e) {
            logger.log(TreeLogger.ERROR, "Unable to initialize ResourceGenerator", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.log(TreeLogger.ERROR, "Unable to instantiate ResourceGenerator. Does it have a public default constructor?", (Throwable)e);
        }
        throw new UnableToCompleteException();
    }

    private void writeMapMethods(TreeLogger logger, String createdClassName, SourceWriter sw, Map<Class<? extends ResourceGenerator>, List<JMethod>> taskList) throws UnableToCompleteException {
        sw.println("public ResourcePrototype[] getResources() {");
        sw.indent();
        sw.println("return new ResourcePrototype[] {");
        sw.indent();
        for (List<JMethod> methods : taskList.values()) {
            for (JMethod m : methods) {
                sw.println(m.getName() + "(), ");
            }
        }
        sw.outdent();
        sw.println("};");
        sw.outdent();
        sw.println("}");
        sw.println("public native ResourcePrototype getResource(String name) /*-{");
        sw.indent();
        sw.println("switch (name) {");
        sw.indent();
        for (List<JMethod> list : taskList.values()) {
            for (JMethod m : list) {
                sw.println("case '" + m.getName() + "': return this." + m.getJsniSignature() + "();");
            }
        }
        sw.outdent();
        sw.println("}");
        sw.println("return null;");
        sw.outdent();
        sw.println("}-*/;");
    }

    protected static class FieldsImpl
    implements ClientBundleFields {
        private final NameFactory factory = new NameFactory();
        private final Map<String, String> fieldsToDeclarations = new LinkedHashMap<String, String>();
        private final Map<String, String> fieldsToInitializers = new HashMap<String, String>();

        protected FieldsImpl() {
        }

        public void addName(String name) {
            this.factory.addName(name);
        }

        public String define(JType type, String name) {
            return this.define(type, name, null, true, false);
        }

        public String define(JType type, String name, String initializer, boolean isStatic, boolean isFinal) {
            assert (Util.isValidJavaIdent((String)name)) : name + " is not a valid Java identifier";
            String ident = this.factory.createName(name);
            StringBuilder sb = new StringBuilder();
            sb.append("private ");
            if (isStatic) {
                sb.append("static ");
            }
            if (isFinal) {
                sb.append("final ");
            }
            sb.append(type.getQualifiedSourceName());
            sb.append(" ");
            sb.append(ident);
            this.fieldsToDeclarations.put(ident, sb.toString());
            if (initializer != null) {
                this.fieldsToInitializers.put(ident, initializer);
            }
            return ident;
        }

        public void setInitializer(String ident, String initializer) {
            assert (this.fieldsToDeclarations.containsKey(ident)) : ident + " not defined";
            this.fieldsToInitializers.put(ident, initializer);
        }

        private String getCode() {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : this.fieldsToDeclarations.entrySet()) {
                String ident = entry.getKey();
                sb.append(entry.getValue());
                String initializer = this.fieldsToInitializers.get(ident);
                if (initializer != null) {
                    sb.append(" = ").append(initializer);
                }
                sb.append(";\n");
            }
            return sb.toString();
        }
    }

    private static class RequirementsImpl
    implements ClientBundleRequirements {
        private final Set<String> axes = new HashSet<String>();
        private final PropertyOracle oracle;

        public RequirementsImpl(PropertyOracle oracle) {
            this.oracle = oracle;
        }

        public void addPermutationAxis(String propertyName) throws BadPropertyValueException {
            try {
                this.oracle.getSelectionProperty(TreeLogger.NULL, propertyName).getCurrentValue();
                this.axes.add(propertyName);
            }
            catch (BadPropertyValueException e) {
                this.oracle.getConfigurationProperty(propertyName).getValues();
            }
        }
    }
}

