/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit.rebind;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitTestCaseStubGenerator
extends Generator {
    protected TreeLogger logger;
    private String packageName;
    private String qualifiedStubClassName;
    private JClassType requestedClass;
    private String simpleStubClassName;
    private SourceWriter sourceWriter;
    private TypeOracle typeOracle;

    protected static Map<String, List<JMethod>> getAllMethods(JClassType type, MethodFilter filter) {
        HashMap<String, List<JMethod>> methods = new HashMap<String, List<JMethod>>();
        for (JClassType cls = type; cls != null; cls = cls.getSuperclass()) {
            for (JMethod declMethod : cls.getMethods()) {
                if (!filter.accept(declMethod)) continue;
                ArrayList<JMethod> list = (ArrayList<JMethod>)methods.get(declMethod.getName());
                if (list == null) {
                    list = new ArrayList<JMethod>();
                    methods.put(declMethod.getName(), list);
                    list.add(declMethod);
                    continue;
                }
                JParameter[] declParams = declMethod.getParameters();
                for (int j = 0; j < list.size(); ++j) {
                    JMethod method = (JMethod)list.get(j);
                    JParameter[] parameters = method.getParameters();
                    if (JUnitTestCaseStubGenerator.equals(declParams, parameters)) continue;
                    list.add(declMethod);
                }
            }
        }
        return methods;
    }

    protected static boolean isJUnitTestMethod(JMethod method, boolean acceptArgs) {
        if (!method.getName().startsWith("test")) {
            return false;
        }
        if (!method.isPublic()) {
            return false;
        }
        return acceptArgs || method.getParameters().length == 0 && !acceptArgs;
    }

    private static boolean equals(JParameter[] params1, JParameter[] params2) {
        if (params1.length != params2.length) {
            return false;
        }
        for (int i = 0; i < params1.length; ++i) {
            if (params1[i].getType() == params2[i].getType()) continue;
            return false;
        }
        return true;
    }

    private static String[] getTestMethodNames(JClassType requestedClass) {
        return JUnitTestCaseStubGenerator.getAllMethods(requestedClass, new MethodFilter(){

            public boolean accept(JMethod method) {
                return JUnitTestCaseStubGenerator.isJUnitTestMethod(method, false);
            }
        }).keySet().toArray(new String[0]);
    }

    public String generate(TreeLogger logger, GeneratorContext context, String typeName) throws UnableToCompleteException {
        if (!this.init(logger, context, typeName)) {
            return this.qualifiedStubClassName;
        }
        this.writeSource();
        this.sourceWriter.commit(logger);
        return this.qualifiedStubClassName;
    }

    protected JClassType getRequestedClass() {
        return this.requestedClass;
    }

    protected SourceWriter getSourceWriter() {
        return this.sourceWriter;
    }

    protected TypeOracle getTypeOracle() {
        return this.typeOracle;
    }

    protected void writeSource() throws UnableToCompleteException {
        String[] testMethods = JUnitTestCaseStubGenerator.getTestMethodNames(this.requestedClass);
        this.writeDoRunTestMethod(testMethods, this.sourceWriter);
    }

    private String getSimpleStubClassName(JClassType baseClass) {
        return "__" + baseClass.getSimpleSourceName() + "_unitTestImpl";
    }

    private SourceWriter getSourceWriter(TreeLogger logger, GeneratorContext ctx, String packageName, String className, String superclassName) {
        PrintWriter printWriter = ctx.tryCreate(logger, packageName, className);
        if (printWriter == null) {
            return null;
        }
        ClassSourceFileComposerFactory composerFactory = new ClassSourceFileComposerFactory(packageName, className);
        composerFactory.setSuperclass(superclassName);
        return composerFactory.createSourceWriter(ctx, printWriter);
    }

    private boolean init(TreeLogger logger, GeneratorContext context, String typeName) throws UnableToCompleteException {
        this.logger = logger;
        this.typeOracle = context.getTypeOracle();
        assert (this.typeOracle != null);
        try {
            this.requestedClass = this.typeOracle.getType(typeName);
        }
        catch (NotFoundException e) {
            logger.log(TreeLogger.ERROR, "Could not find type '" + typeName + "'; please see the log, as this usually indicates a previous error ", (Throwable)e);
            throw new UnableToCompleteException();
        }
        this.simpleStubClassName = this.getSimpleStubClassName(this.requestedClass);
        this.packageName = this.requestedClass.getPackage().getName();
        this.qualifiedStubClassName = this.packageName + "." + this.simpleStubClassName;
        this.sourceWriter = this.getSourceWriter(logger, context, this.packageName, this.simpleStubClassName, this.requestedClass.getQualifiedSourceName());
        return this.sourceWriter != null;
    }

    private void writeDoRunTestMethod(String[] testMethodNames, SourceWriter sw) {
        sw.println();
        sw.println("protected final void doRunTest(String name) throws Throwable {");
        sw.indent();
        int n = testMethodNames.length;
        for (int i = 0; i < n; ++i) {
            String methodName = testMethodNames[i];
            if (i > 0) {
                sw.print("else ");
            }
            sw.println("if (name.equals(\"" + methodName + "\")) {");
            sw.indentln(methodName + "();");
            sw.println("}");
        }
        sw.outdent();
        sw.println("}");
    }

    protected static interface MethodFilter {
        public boolean accept(JMethod var1);
    }
}

