/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit;

import com.gargoylesoftware.htmlunit.AlertHandler;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import com.gargoylesoftware.htmlunit.OnbeforeunloadHandler;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.shell.HostedModePluginObject;
import com.google.gwt.junit.JUnitShell;
import com.google.gwt.junit.RunStyle;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunStyleHtmlUnit
extends RunStyle {
    private static final Map<String, BrowserVersion> BROWSER_MAP = RunStyleHtmlUnit.createBrowserMap();
    private static final int DEFAULT_TRIES = 3;
    private Set<BrowserVersion> browsers = new HashSet<BrowserVersion>();
    private boolean developmentMode;
    private final List<Thread> threads = new ArrayList<Thread>();

    static String getBrowserList() {
        StringBuffer sb = new StringBuffer();
        for (String str : BROWSER_MAP.keySet()) {
            sb.append(str);
            sb.append(",");
        }
        if (sb.length() > 1) {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }

    private static Map<String, BrowserVersion> createBrowserMap() {
        HashMap<String, BrowserVersion> browserMap = new HashMap<String, BrowserVersion>();
        for (BrowserVersion browser : new BrowserVersion[]{BrowserVersion.FIREFOX_2, BrowserVersion.FIREFOX_3, BrowserVersion.INTERNET_EXPLORER_6, BrowserVersion.INTERNET_EXPLORER_7}) {
            browserMap.put(browser.getNickname(), browser);
        }
        return Collections.unmodifiableMap(browserMap);
    }

    public RunStyleHtmlUnit(JUnitShell shell) {
        super(shell);
    }

    @Override
    public int initialize(String args) {
        if (args == null || args.length() == 0) {
            args = "FF3";
        }
        HashSet<BrowserVersion> browserSet = new HashSet<BrowserVersion>();
        for (String browserName : args.split(",")) {
            BrowserVersion browser = BROWSER_MAP.get(browserName);
            if (browser == null) {
                this.getLogger().log(TreeLogger.ERROR, "RunStyleHtmlUnit: Unknown browser name " + browserName + ", expected browser name: one of " + BROWSER_MAP.keySet());
                return -1;
            }
            browserSet.add(browser);
        }
        this.browsers = Collections.unmodifiableSet(browserSet);
        this.setTries(3);
        return this.browsers.size();
    }

    @Override
    public void launchModule(String moduleName) {
        for (BrowserVersion browser : this.browsers) {
            String url = this.shell.getModuleUrl(moduleName);
            HtmlUnitThread hut = this.createHtmlUnitThread(browser, url);
            this.shell.getTopLogger().log(TreeLogger.INFO, "Starting " + url + " on browser " + browser.getNickname());
            hut.start();
            this.threads.add(hut);
        }
    }

    public int numBrowsers() {
        return this.browsers.size();
    }

    @Override
    public boolean setupMode(TreeLogger logger, boolean developmentMode) {
        this.developmentMode = developmentMode;
        return true;
    }

    protected HtmlUnitThread createHtmlUnitThread(BrowserVersion browser, String url) {
        return new HtmlUnitThread(browser, url, this.shell.getTopLogger().branch(TreeLogger.SPAM, "logging for HtmlUnit thread"), this.developmentMode);
    }

    private static class HostedJavaScriptEngine
    extends JavaScriptEngine {
        private static final long serialVersionUID = 3594816610842448691L;

        public HostedJavaScriptEngine(WebClient webClient) {
            super(webClient);
        }

        public void initialize(WebWindow webWindow) {
            super.initialize(webWindow);
            Window window = (Window)webWindow.getScriptObject();
            window.defineProperty("__gwt_HostedModePlugin", (Object)new HostedModePluginObject((JavaScriptEngine)this), 1);
        }
    }

    protected static class HtmlUnitThread
    extends Thread
    implements AlertHandler,
    IncorrectnessListener,
    OnbeforeunloadHandler {
        private final BrowserVersion browser;
        private final boolean developmentMode;
        private final TreeLogger treeLogger;
        private final String url;
        private Object waitForUnload = new Object();

        public HtmlUnitThread(BrowserVersion browser, String url, TreeLogger treeLogger, boolean developmentMode) {
            this.browser = browser;
            this.url = url;
            this.treeLogger = treeLogger;
            this.setName("htmlUnit client thread");
            this.developmentMode = developmentMode;
        }

        public void handleAlert(Page page, String message) {
            this.treeLogger.log(TreeLogger.ERROR, "Alert: " + message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleEvent(Page page, String returnValue) {
            Object object = this.waitForUnload;
            synchronized (object) {
                this.waitForUnload.notifyAll();
            }
            return true;
        }

        public void notify(String message, Object origin) {
            if ("Obsolete content type encountered: 'text/javascript'.".equals(message)) {
                return;
            }
            this.treeLogger.log(TreeLogger.WARN, message);
        }

        public void run() {
            WebClient webClient = new WebClient(this.browser);
            webClient.setAlertHandler((AlertHandler)this);
            webClient.setIncorrectnessListener((IncorrectnessListener)this);
            webClient.setThrowExceptionOnFailingStatusCode(false);
            webClient.setThrowExceptionOnScriptError(true);
            webClient.setOnbeforeunloadHandler((OnbeforeunloadHandler)this);
            this.setupWebClient(webClient);
            try {
                Page page = webClient.getPage(this.url);
                webClient.waitForBackgroundJavaScriptStartingBefore(2000L);
                page.getEnclosingWindow().getJobManager().waitForJobs(60000L);
                this.treeLogger.log(TreeLogger.SPAM, "getPage returned " + ((HtmlPage)page).asXml());
            }
            catch (FailingHttpStatusCodeException e) {
                this.treeLogger.log(TreeLogger.ERROR, "HTTP request failed", (Throwable)e);
                return;
            }
            catch (MalformedURLException e) {
                this.treeLogger.log(TreeLogger.ERROR, "Bad URL", (Throwable)e);
                return;
            }
            catch (IOException e) {
                this.treeLogger.log(TreeLogger.ERROR, "I/O error on HTTP request", (Throwable)e);
                return;
            }
        }

        protected void setupWebClient(WebClient webClient) {
            if (this.developmentMode) {
                HostedJavaScriptEngine hostedEngine = new HostedJavaScriptEngine(webClient);
                webClient.setJavaScriptEngine((JavaScriptEngine)hostedEngine);
            }
        }
    }
}

