/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.junit;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.junit.JUnitShell;
import com.google.gwt.junit.RunStyle;
import java.util.HashSet;

class RunStyleExternalBrowser
extends RunStyle {
    private ExternalBrowser[] externalBrowsers;

    public RunStyleExternalBrowser(JUnitShell shell) {
        super(shell);
    }

    public String[] getInterruptedHosts() {
        HashSet<String> toRet = null;
        for (ExternalBrowser browser : this.externalBrowsers) {
            try {
                browser.getProcess().exitValue();
                if (toRet == null) {
                    toRet = new HashSet<String>();
                }
                toRet.add(browser.getPath());
            }
            catch (IllegalThreadStateException e) {
                // empty catch block
            }
        }
        return toRet == null ? null : toRet.toArray(new String[toRet.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int initialize(String args) {
        if (args == null || args.length() == 0) {
            this.getLogger().log(TreeLogger.ERROR, "ExternalBrowser runstyle requires an argument listing one or more executables of external browsers to launch");
            return -1;
        }
        String[] browsers = args.split(",");
        RunStyleExternalBrowser runStyleExternalBrowser = this;
        synchronized (runStyleExternalBrowser) {
            this.externalBrowsers = new ExternalBrowser[browsers.length];
            for (int i = 0; i < browsers.length; ++i) {
                this.externalBrowsers[i] = new ExternalBrowser(browsers[i]);
            }
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownCb());
        return browsers.length;
    }

    public synchronized void launchModule(String moduleName) throws UnableToCompleteException {
        String[] commandArray = new String[2];
        commandArray[1] = this.shell.getModuleUrl(moduleName);
        Process child = null;
        for (ExternalBrowser browser : this.externalBrowsers) {
            try {
                commandArray[0] = browser.getPath();
                child = Runtime.getRuntime().exec(commandArray);
                if (child == null) {
                    this.getLogger().log(TreeLogger.ERROR, "Problem exec()'ing " + commandArray[0]);
                    throw new UnableToCompleteException();
                }
            }
            catch (Exception e) {
                this.getLogger().log(TreeLogger.ERROR, "Error launching external browser at " + browser.getPath(), (Throwable)e);
                throw new UnableToCompleteException();
            }
            browser.setProcess(child);
        }
    }

    private static class ExternalBrowser {
        String browserPath;
        Process process;

        public ExternalBrowser(String browserPath) {
            this.browserPath = browserPath;
        }

        public String getPath() {
            return this.browserPath;
        }

        public Process getProcess() {
            return this.process;
        }

        public void setProcess(Process process) {
            this.process = process;
        }
    }

    private class ShutdownCb
    extends Thread {
        private ShutdownCb() {
        }

        public void run() {
            for (ExternalBrowser browser : RunStyleExternalBrowser.this.externalBrowsers) {
                try {
                    browser.getProcess().exitValue();
                }
                catch (IllegalThreadStateException e) {
                    browser.getProcess().destroy();
                }
            }
        }
    }
}

