/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.tools;

import com.google.gwt.i18n.client.Constants;
import com.google.gwt.i18n.client.ConstantsWithLookup;
import com.google.gwt.i18n.client.Localizable;
import com.google.gwt.i18n.client.Messages;
import com.google.gwt.i18n.rebind.ConstantsInterfaceCreator;
import com.google.gwt.i18n.rebind.MessagesInterfaceCreator;
import com.google.gwt.i18n.tools.ArgHandlerValueChooser;
import com.google.gwt.util.tools.ArgHandler;
import com.google.gwt.util.tools.ArgHandlerExtra;
import com.google.gwt.util.tools.ArgHandlerString;
import com.google.gwt.util.tools.ToolBase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18NSync
extends ToolBase {
    public static final String ID = "@gwt.key ";
    private ArgHandlerValueChooser chooser;
    private String classNameArg;
    private File outDirArg;

    public static void createConstantsInterfaceFromClassName(String className, File outDir) throws IOException {
        I18NSync.createConstantsInterfaceFromClassName(className, outDir, Constants.class);
    }

    public static void createConstantsWithLookupInterfaceFromClassName(String className) throws IOException {
        I18NSync.createConstantsInterfaceFromClassName(className, null, ConstantsWithLookup.class);
    }

    public static void createConstantsWithLookupInterfaceFromClassName(String className, File sourceDir) throws IOException {
        I18NSync.createConstantsInterfaceFromClassName(className, sourceDir, ConstantsWithLookup.class);
    }

    public static void createInterfaceFromClassName(String className, File sourceDir, Class<? extends Localizable> interfaceType) throws IOException {
        if (interfaceType == Messages.class) {
            I18NSync.createMessagesInterfaceFromClassName(className, sourceDir);
        } else {
            if (!Constants.class.isAssignableFrom(interfaceType)) {
                throw new RuntimeException("Internal Error: Unable to create i18n class derived from " + interfaceType.getName());
            }
            I18NSync.createConstantsInterfaceFromClassName(className, sourceDir, interfaceType.asSubclass(Constants.class));
        }
    }

    public static void createMessagesInterfaceFromClassName(String className) throws IOException {
        I18NSync.createMessagesInterfaceFromClassName(className, null);
    }

    public static void createMessagesInterfaceFromClassName(String className, File sourceDir) throws IOException {
        File source;
        File resource = I18NSync.urlToResourceFile(className);
        if (sourceDir == null) {
            source = I18NSync.synthesizeSourceFile(resource);
        } else {
            I18NSync.checkValidSourceDir(sourceDir);
            String sourcePath = className.replace('.', File.separatorChar);
            sourcePath = sourceDir.getCanonicalFile() + File.separator + sourcePath + ".java";
            source = new File(sourcePath);
        }
        I18NSync.checkValidJavaSourceOutputFile(source);
        I18NSync.checkValidResourceInputFile(resource);
        int classDiv = className.lastIndexOf(".");
        String packageName = className.substring(0, classDiv);
        String name = className.substring(classDiv + 1);
        MessagesInterfaceCreator creator = new MessagesInterfaceCreator(name, packageName, resource, source);
        creator.generate();
    }

    public static void main(String[] args) {
        I18NSync creator = new I18NSync();
        if (creator.processArgs(args) && creator.run()) {
            return;
        }
        System.exit(1);
    }

    static void checkValidJavaSourceOutputFile(File targetSource) throws IOException {
        if (targetSource.isDirectory()) {
            throw new IOException("Output file'" + targetSource + "' exists and is a directory; cannot overwrite");
        }
        if (!targetSource.getParentFile().isDirectory()) {
            throw new IOException("The target source's directory '" + targetSource.getParent() + "' must be an existing directory");
        }
    }

    static void checkValidResourceInputFile(File resource) throws IOException {
        if (!resource.getPath().endsWith(".properties")) {
            throw new IOException("Properties files " + resource + " should end with '.properties'");
        }
        if (!resource.exists() || !resource.isFile()) {
            throw new IOException("Properties file not found: " + resource);
        }
    }

    private static void checkValidSourceDir(File outDir) throws IOException {
        if (!outDir.isDirectory()) {
            throw new IOException(outDir + " must be an existing directory. Current path is " + new File(".").getCanonicalPath());
        }
    }

    private static void createConstantsInterfaceFromClassName(String className, File sourceDir, Class<? extends Constants> interfaceClass) throws IOException {
        File source;
        File resource = I18NSync.urlToResourceFile(className);
        if (sourceDir == null) {
            source = I18NSync.synthesizeSourceFile(resource);
        } else {
            I18NSync.checkValidSourceDir(sourceDir);
            String sourcePath = className.replace('.', File.separatorChar);
            sourcePath = sourceDir.getCanonicalFile() + File.separator + sourcePath + ".java";
            source = new File(sourcePath);
        }
        I18NSync.checkValidJavaSourceOutputFile(source);
        I18NSync.checkValidResourceInputFile(resource);
        int classDiv = className.lastIndexOf(".");
        String packageName = className.substring(0, classDiv);
        String name = className.substring(classDiv + 1);
        ConstantsInterfaceCreator creator = new ConstantsInterfaceCreator(name, packageName, resource, source, interfaceClass);
        creator.generate();
    }

    private static File synthesizeSourceFile(File resource) {
        String javaPath = resource.getName();
        javaPath = javaPath.substring(0, javaPath.lastIndexOf("."));
        javaPath = resource.getParentFile().getPath() + File.separator + javaPath + ".java";
        File targetClassFile = new File(javaPath);
        return targetClassFile;
    }

    private static File urlToResourceFile(String className) throws IOException {
        URL r;
        if (className.endsWith(".java") || className.endsWith(".properties") || className.endsWith(".class") || className.indexOf(File.separator) > 0) {
            throw new IllegalArgumentException("class '" + className + "'should not contain an extension. \"com.google.gwt.SomeClass\" is an example of a correctly formed class string");
        }
        String resourcePath = className.replace('.', '/') + ".properties";
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if ((r = cl.getResource(resourcePath)) == null) {
            throw new FileNotFoundException("Could not find the resource '" + resourcePath + " matching '" + className + "' did you remember to add it to your classpath?");
        }
        File resourceFile = new File(URLDecoder.decode(r.getPath(), "utf-8"));
        return resourceFile;
    }

    private I18NSync() {
        this.registerHandler((ArgHandler)new classNameArgHandler());
        this.registerHandler((ArgHandler)new outDirHandler());
        this.chooser = new ArgHandlerValueChooser();
        this.registerHandler(this.chooser.getConstantsWithLookupArgHandler());
        this.registerHandler(this.chooser.getMessagesArgHandler());
    }

    protected boolean run() {
        try {
            I18NSync.createInterfaceFromClassName(this.classNameArg, this.outDirArg, this.chooser.getArgValue());
            return true;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            return false;
        }
    }

    private class classNameArgHandler
    extends ArgHandlerExtra {
        private classNameArgHandler() {
        }

        public boolean addExtraArg(String str) {
            if (I18NSync.this.classNameArg != null) {
                System.err.println("Too many arguments.");
                return false;
            }
            try {
                File resourceFile = I18NSync.urlToResourceFile(str);
                I18NSync.checkValidResourceInputFile(resourceFile);
                I18NSync.this.classNameArg = str;
            }
            catch (IOException e) {
                System.err.println("Error: " + e.getMessage());
                return false;
            }
            return true;
        }

        public String getPurpose() {
            return "Identifies the Constants/Messages class to be created.  For example com.google.sample.i18n.client.Colors";
        }

        public String[] getTagArgs() {
            String[] interfaceArg = new String[]{"name of the Constants/Messages interface to create"};
            return interfaceArg;
        }

        public boolean isRequired() {
            return true;
        }
    }

    private class outDirHandler
    extends ArgHandlerString {
        private outDirHandler() {
        }

        public String getPurpose() {
            return "Java source directory, defaults to the resource's class path.";
        }

        public String getTag() {
            return "-out";
        }

        public String[] getTagArgs() {
            String[] resourceArgs = new String[]{"fileName"};
            return resourceArgs;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean setString(String str) {
            I18NSync.this.outDirArg = new File(str);
            try {
                I18NSync.checkValidSourceDir(I18NSync.this.outDirArg);
            }
            catch (IOException e) {
                System.err.println("Error: " + e.getMessage());
                return false;
            }
            return true;
        }
    }
}

