/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.i18n.rebind.AbstractLocalizableMethodCreator;
import com.google.gwt.i18n.rebind.AbstractResource;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.user.rebind.AbstractGeneratorClassCreator;

class SimpleValueMethodCreator
extends AbstractLocalizableMethodCreator {
    static final AbstractValueCreator DOUBLE = new AbstractValueCreator(){

        String getValue(String stringVal) {
            return Double.parseDouble(stringVal) + "";
        }
    };
    static final AbstractValueCreator FLOAT = new AbstractValueCreator(){

        String getValue(String stringVal) {
            return Float.parseFloat(stringVal) + "f";
        }
    };
    static final AbstractValueCreator INT = new AbstractValueCreator(){

        String getValue(String stringVal) {
            return Integer.parseInt(stringVal) + "";
        }
    };
    static final AbstractValueCreator STRING = new AbstractValueCreator(){

        String getValue(String stringVal) {
            return SimpleValueMethodCreator.wrap(stringVal);
        }
    };
    static final AbstractValueCreator BOOLEAN = new AbstractValueCreator(){

        String getValue(String stringVal) {
            if ("true".equals(stringVal)) {
                return "true";
            }
            if ("false".equals(stringVal)) {
                return "false";
            }
            throw new BadBooleanPropertyValue();
        }
    };
    private AbstractValueCreator valueCreator;

    SimpleValueMethodCreator(AbstractGeneratorClassCreator currentCreator, AbstractValueCreator valueCreator) {
        super(currentCreator);
        this.valueCreator = valueCreator;
    }

    public void createMethodFor(TreeLogger logger, JMethod targetMethod, String key, AbstractResource.ResourceList resource, GwtLocale locale) throws UnableToCompleteException {
        String value = resource.getRequiredStringExt(key, null);
        try {
            String translatedValue = this.valueCreator.getValue(value);
            this.println("return " + translatedValue + ";");
        }
        catch (NumberFormatException e) {
            throw SimpleValueMethodCreator.error(logger, value + " could not be parsed as a number.");
        }
        catch (BadBooleanPropertyValue e) {
            throw SimpleValueMethodCreator.error(logger, "'" + value + "' is not a valid boolean property value; must be 'true' or 'false'");
        }
    }

    public static abstract class AbstractValueCreator {
        abstract String getValue(String var1);
    }

    private static class BadBooleanPropertyValue
    extends RuntimeException {
        private BadBooleanPropertyValue() {
        }
    }
}

