/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameter;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.i18n.client.Messages;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.i18n.client.PluralRule;
import com.google.gwt.i18n.client.impl.plurals.DefaultRule;
import com.google.gwt.i18n.rebind.AbstractResource;
import com.google.gwt.i18n.rebind.LocalizableLinkageCreator;
import com.google.gwt.i18n.rebind.MessageFormatParser;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.user.rebind.AbstractGeneratorClassCreator;
import com.google.gwt.user.rebind.AbstractMethodCreator;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MessagesMethodCreator
extends AbstractMethodCreator {
    private static final String dtFormatClassName = DateTimeFormat.class.getCanonicalName();
    private static Map<String, ValueFormatter> formatters = new HashMap<String, ValueFormatter>();
    private static final String numFormatClassName = NumberFormat.class.getCanonicalName();

    public MessagesMethodCreator(AbstractGeneratorClassCreator classCreator) {
        super(classCreator);
    }

    @Override
    public void createMethodFor(TreeLogger logger, JMethod m, String key, AbstractResource.ResourceList resourceList, GwtLocale locale) throws UnableToCompleteException {
        JParameter[] params = m.getParameters();
        int pluralParamIndex = -1;
        Class ruleClass = null;
        int numParams = params.length;
        boolean[] seenFlags = new boolean[numParams];
        for (int i = 0; i < numParams; ++i) {
            Messages.PluralCount pluralCount = (Messages.PluralCount)params[i].getAnnotation(Messages.PluralCount.class);
            if (pluralCount == null) continue;
            if (pluralParamIndex >= 0) {
                throw MessagesMethodCreator.error(logger, m.getName() + ": there can only be one PluralCount parameter");
            }
            JPrimitiveType primType = params[i].getType().isPrimitive();
            if (primType != JPrimitiveType.INT && primType != JPrimitiveType.SHORT) {
                throw MessagesMethodCreator.error(logger, m.getName() + ": PluralCount parameter must be int or short");
            }
            pluralParamIndex = i;
            ruleClass = pluralCount.value();
        }
        StringBuffer generated = new StringBuffer();
        if (ruleClass == null) {
            if (m.getAnnotation(Messages.PluralText.class) != null) {
                logger.log(TreeLogger.WARN, "Unused @PluralText on " + m.getEnclosingType().getSimpleSourceName() + "." + m.getName() + "; did you intend to mark a @PluralCount parameter?", null);
            }
        } else {
            if (ruleClass == PluralRule.class) {
                ruleClass = DefaultRule.class;
            }
            PluralRule rule = this.createLocalizedPluralRule(logger, m.getEnclosingType().getOracle(), ruleClass, locale);
            logger.log(TreeLogger.TRACE, "Using plural rule " + rule.getClass() + " for locale '" + locale + "'", null);
            generated.append(PluralRule.class.getCanonicalName());
            generated.append(" rule = new " + rule.getClass().getCanonicalName() + "();\n");
            generated.append("switch (rule.select(" + params[pluralParamIndex].getName() + ")) {\n");
            PluralRule.PluralForm[] pluralForms = rule.pluralForms();
            resourceList.setPluralForms(key, pluralForms);
            for (int i = 1; i < pluralForms.length; ++i) {
                String template = resourceList.getStringExt(key, pluralForms[i].getName());
                if (template != null) {
                    generated.append("  // " + pluralForms[i].getName() + " - " + pluralForms[i].getDescription() + "\n");
                    generated.append("  case " + i + ": return ");
                    this.generateString(logger, template, params, seenFlags, generated);
                    generated.append(";\n");
                    continue;
                }
                if (!pluralForms[i].getWarnIfMissing()) continue;
                logger.log(TreeLogger.WARN, "No plural form '" + pluralForms[i].getName() + "' defined for method '" + m.getName() + "' in " + m.getEnclosingType() + " for locale " + locale, null);
            }
            generated.append("}\n");
        }
        generated.append("return ");
        String template = resourceList.getRequiredStringExt(key, null);
        this.generateString(logger, template, params, seenFlags, generated);
        for (int i = 0; i < numParams; ++i) {
            Messages.Optional optional;
            if (seenFlags[i] || (optional = (Messages.Optional)params[i].getAnnotation(Messages.Optional.class)) != null) continue;
            throw MessagesMethodCreator.error(logger, "Required argument " + params[i].getName() + " not present: " + template);
        }
        generated.append(';');
        this.println(generated.toString());
    }

    private PluralRule createLocalizedPluralRule(TreeLogger logger, TypeOracle oracle, Class<? extends PluralRule> ruleClass, GwtLocale locale) throws UnableToCompleteException {
        String baseName = ruleClass.getCanonicalName();
        JClassType ruleJClassType = oracle.findType(baseName);
        Map<String, JClassType> matchingClasses = LocalizableLinkageCreator.findDerivedClasses(logger, ruleJClassType);
        for (GwtLocale search : locale.getCompleteSearchList()) {
            JClassType localizedType = matchingClasses.get(((Object)search).toString());
            if (localizedType == null) continue;
            try {
                Class<?> testClass = Class.forName(localizedType.getQualifiedBinaryName(), false, PluralRule.class.getClassLoader());
                if (!PluralRule.class.isAssignableFrom(testClass)) continue;
                return (PluralRule)testClass.newInstance();
            }
            catch (ClassCastException e) {
            }
            catch (ClassNotFoundException e) {
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
            }
        }
        return new DefaultRule();
    }

    private void generateString(TreeLogger logger, String template, JParameter[] params, boolean[] seenFlag, StringBuffer outputBuf) throws UnableToCompleteException {
        StringGenerator buf = new StringGenerator(outputBuf);
        try {
            for (MessageFormatParser.TemplateChunk chunk : MessageFormatParser.parse(template)) {
                if (chunk.isLiteral()) {
                    buf.appendStringLiteral(chunk.getString());
                    continue;
                }
                if (chunk instanceof MessageFormatParser.ArgumentChunk) {
                    MessageFormatParser.ArgumentChunk argChunk = (MessageFormatParser.ArgumentChunk)chunk;
                    int argNumber = argChunk.getArgumentNumber();
                    if (argNumber >= params.length) {
                        throw MessagesMethodCreator.error(logger, "Argument " + argNumber + " beyond range of arguments: " + template);
                    }
                    seenFlag[argNumber] = true;
                    String arg = params[argNumber].getName();
                    String format = argChunk.getFormat();
                    if (format != null) {
                        String subformat = argChunk.getSubFormat();
                        ValueFormatter formatter = formatters.get(format);
                        if (formatter != null) {
                            String err = formatter.format(buf, subformat, arg, params[argNumber].getType());
                            if (err == null) continue;
                            throw MessagesMethodCreator.error(logger, err);
                        }
                    }
                    buf.appendExpression(arg, "java.lang.String".equals(params[argNumber].getType().getQualifiedSourceName()));
                    continue;
                }
                throw MessagesMethodCreator.error(logger, "Unexpected result from parsing template " + template);
            }
        }
        catch (ParseException e) {
            throw MessagesMethodCreator.error(logger, e);
        }
        buf.completeString();
    }

    static {
        formatters.put("date", new DateFormatter());
        formatters.put("number", new NumberFormatter());
        formatters.put("time", new TimeFormatter());
    }

    private static class DateFormatter
    implements ValueFormatter {
        private DateFormatter() {
        }

        public String format(StringGenerator out, String subformat, String argName, JType argType) {
            if (!"java.util.Date".equals(argType.getQualifiedSourceName())) {
                return "Only java.util.Date acceptable for date format";
            }
            if (subformat == null || "medium".equals(subformat)) {
                out.appendExpression(dtFormatClassName + ".getMediumDateFormat()" + ".format(" + argName + ")", true);
            } else if ("full".equals(subformat)) {
                out.appendExpression(dtFormatClassName + ".getFullDateFormat().format(" + argName + ")", true);
            } else if ("long".equals(subformat)) {
                out.appendExpression(dtFormatClassName + ".getLongDateFormat().format(" + argName + ")", true);
            } else if ("short".equals(subformat)) {
                out.appendExpression(dtFormatClassName + ".getShortDateFormat()" + ".format(" + argName + ")", true);
            } else {
                out.appendExpression(dtFormatClassName + ".getFormat(" + MessagesMethodCreator.wrap(subformat) + ").format(" + argName + ")", true);
            }
            return null;
        }
    }

    private static class NumberFormatter
    implements ValueFormatter {
        private NumberFormatter() {
        }

        public String format(StringGenerator out, String subformat, String argName, JType argType) {
            JPrimitiveType argPrimType = argType.isPrimitive();
            if (argPrimType == null || argPrimType == JPrimitiveType.BOOLEAN || argPrimType == JPrimitiveType.VOID) {
                return "Illegal argument type for number format";
            }
            if (subformat == null) {
                out.appendExpression(numFormatClassName + ".getDecimalFormat().format(" + argName + ")", true);
            } else if ("integer".equals(subformat)) {
                out.appendExpression(numFormatClassName + ".getIntegerFormat().format(" + argName + ")", true);
            } else if ("currency".equals(subformat)) {
                out.appendExpression(numFormatClassName + ".getCurrencyFormat().format(" + argName + ")", true);
            } else if ("percent".equals(subformat)) {
                out.appendExpression(numFormatClassName + ".getPercentFormat().format(" + argName + ")", true);
            } else {
                out.appendExpression(numFormatClassName + ".getFormat(" + MessagesMethodCreator.wrap(subformat) + ").format(" + argName + ")", true);
            }
            return null;
        }
    }

    private static class StringGenerator {
        private StringBuffer buf;
        private boolean inString;
        private boolean producedOutput;

        public StringGenerator(StringBuffer buf) {
            this.buf = buf;
            this.producedOutput = false;
            this.inString = false;
        }

        public void appendExpression(String expression) {
            this.appendExpression(expression, false);
        }

        public void appendExpression(String expression, boolean knownToBeString) {
            if (this.inString) {
                this.buf.append('\"');
                this.inString = false;
                this.producedOutput = true;
            }
            if (this.producedOutput) {
                this.buf.append(" + ");
            } else if (!knownToBeString) {
                this.buf.append("\"\" + ");
            }
            this.buf.append(expression);
            this.producedOutput = true;
        }

        public void appendStringLiteral(char ch) {
            if (!this.inString) {
                if (this.producedOutput) {
                    this.buf.append(" + ");
                } else {
                    this.producedOutput = true;
                }
                this.buf.append('\"');
                this.inString = true;
            }
            this.buf.append(ch);
        }

        public void appendStringLiteral(String str) {
            if (!this.inString) {
                if (this.producedOutput) {
                    this.buf.append(" + ");
                } else {
                    this.producedOutput = true;
                }
                this.buf.append('\"');
                this.inString = true;
            }
            this.buf.append(str);
        }

        public void completeString() {
            if (this.inString) {
                this.buf.append('\"');
            } else if (!this.producedOutput) {
                this.buf.append("\"\"");
            }
        }
    }

    private static class TimeFormatter
    implements ValueFormatter {
        private TimeFormatter() {
        }

        public String format(StringGenerator out, String subformat, String argName, JType argType) {
            if (!"java.util.Date".equals(argType.getQualifiedSourceName())) {
                return "Only java.util.Date acceptable for date format";
            }
            if (subformat == null || "medium".equals(subformat)) {
                out.appendExpression(dtFormatClassName + ".getMediumTimeFormat().format(" + argName + ")", true);
            } else if ("full".equals(subformat)) {
                out.appendExpression(dtFormatClassName + ".getFullTimeFormat().format(" + argName + ")", true);
            } else if ("long".equals(subformat)) {
                out.appendExpression(dtFormatClassName + ".getLongTimeFormat().format(" + argName + ")", true);
            } else if ("short".equals(subformat)) {
                out.appendExpression(dtFormatClassName + ".getShortTimeFormat().format(" + argName + ")", true);
            } else {
                out.appendExpression(dtFormatClassName + ".getFormat(" + MessagesMethodCreator.wrap(subformat) + ").format(" + argName + ")", true);
            }
            return null;
        }
    }

    private static interface ValueFormatter {
        public String format(StringGenerator var1, String var2, String var3, JType var4);
    }
}

