/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.rebind;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.core.ext.typeinfo.TypeOracleException;
import com.google.gwt.i18n.rebind.AbstractLocalizableImplCreator;
import com.google.gwt.i18n.rebind.AbstractResource;
import com.google.gwt.i18n.rebind.ConstantsMapMethodCreator;
import com.google.gwt.i18n.rebind.ConstantsStringArrayMethodCreator;
import com.google.gwt.i18n.rebind.SimpleValueMethodCreator;
import com.google.gwt.i18n.shared.GwtLocale;
import com.google.gwt.user.rebind.SourceWriter;
import java.util.Map;

class ConstantsImplCreator
extends AbstractLocalizableImplCreator {
    private boolean needCache = false;

    public ConstantsImplCreator(TreeLogger logger, SourceWriter writer, JClassType localizableClass, AbstractResource.ResourceList resourceList, TypeOracle oracle) throws UnableToCompleteException {
        super(logger, writer, localizableClass, resourceList, true);
        try {
            JClassType stringClass = oracle.getType(String.class.getName());
            JClassType mapClass = oracle.getType(Map.class.getName());
            JArrayType stringArrayClass = oracle.getArrayType((JType)stringClass);
            JType intClass = oracle.parse(Integer.TYPE.getName());
            JType doubleClass = oracle.parse(Double.TYPE.getName());
            JType floatClass = oracle.parse(Float.TYPE.getName());
            JType booleanClass = oracle.parse(Boolean.TYPE.getName());
            this.register((JType)stringClass, new SimpleValueMethodCreator(this, SimpleValueMethodCreator.STRING));
            this.register((JType)mapClass, new ConstantsMapMethodCreator(this));
            this.register(intClass, new SimpleValueMethodCreator(this, SimpleValueMethodCreator.INT));
            this.register(doubleClass, new SimpleValueMethodCreator(this, SimpleValueMethodCreator.DOUBLE));
            this.register(floatClass, new SimpleValueMethodCreator(this, SimpleValueMethodCreator.FLOAT));
            this.register(booleanClass, new SimpleValueMethodCreator(this, SimpleValueMethodCreator.BOOLEAN));
            this.register((JType)stringArrayClass, new ConstantsStringArrayMethodCreator(this));
        }
        catch (NotFoundException e) {
            throw ConstantsImplCreator.error(logger, e);
        }
        catch (TypeOracleException e) {
            throw ConstantsImplCreator.error(logger, e);
        }
    }

    protected void checkConstantMethod(TreeLogger logger, JMethod method) throws UnableToCompleteException {
        if (method.getParameters().length > 0) {
            throw ConstantsImplCreator.error(logger, "Methods in interfaces extending Constant must have no parameters");
        }
        this.checkReturnType(logger, method);
    }

    protected void checkReturnType(TreeLogger logger, JMethod method) throws UnableToCompleteException {
        JType returnType = method.getReturnType();
        JPrimitiveType primitive = returnType.isPrimitive();
        if (primitive != null && (primitive == JPrimitiveType.BOOLEAN || primitive == JPrimitiveType.DOUBLE || primitive == JPrimitiveType.FLOAT || primitive == JPrimitiveType.INT)) {
            return;
        }
        JArrayType arrayType = returnType.isArray();
        if (arrayType != null) {
            String arrayComponent = arrayType.getComponentType().getQualifiedSourceName();
            if (!arrayComponent.equals("java.lang.String")) {
                throw ConstantsImplCreator.error(logger, "Methods in interfaces extending Constant only support arrays of Strings");
            }
            return;
        }
        String returnTypeName = returnType.getQualifiedSourceName();
        if (returnTypeName.equals("java.lang.String")) {
            return;
        }
        if (returnTypeName.equals("java.util.Map")) {
            JClassType[] typeArgs;
            JParameterizedType paramType = returnType.isParameterized();
            if (!(paramType == null || (typeArgs = paramType.getTypeArgs()).length == 2 && typeArgs[0].getQualifiedSourceName().equals("java.lang.String") && typeArgs[1].getQualifiedSourceName().equals("java.lang.String"))) {
                throw ConstantsImplCreator.error(logger, "Map Methods in interfaces extending Constant must be raw or <String, String>");
            }
            return;
        }
        throw ConstantsImplCreator.error(logger, "Methods in interfaces extending Constant must have a return type of String/int/float/boolean/double/String[]/Map");
    }

    protected void classEpilog() {
        if (this.isNeedCache()) {
            this.getWriter().println("java.util.Map cache = new java.util.HashMap();");
        }
    }

    protected void emitMethodBody(TreeLogger logger, JMethod method, GwtLocale locale) throws UnableToCompleteException {
        this.checkConstantMethod(logger, method);
        this.delegateToCreator(logger, method, locale);
    }

    boolean isNeedCache() {
        return this.needCache;
    }

    void setNeedCache(boolean needCache) {
        this.needCache = needCache;
    }
}

