/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.editors.parts;

import java.text.DateFormat;
import org.eclipse.mylyn.internal.reviews.ui.editors.parts.AbstractCommentPart;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentPart
extends AbstractCommentPart<CommentPart> {
    private Composite composite;

    public CommentPart(IComment comment) {
        super(comment);
    }

    @Override
    protected String getSectionHeaderText() {
        String headerText = String.valueOf(this.comment.getAuthor().getDisplayName()) + "   ";
        headerText = String.valueOf(headerText) + DateFormat.getDateTimeInstance(2, 3).format(this.comment.getCreationDate());
        return headerText;
    }

    private String getCommentText() {
        String commentText = this.comment.getDescription();
        String customFieldsString = "";
        if (customFieldsString.length() > 0) {
            commentText = String.valueOf(commentText) + "  " + customFieldsString;
        }
        return commentText;
    }

    @Override
    protected String getAnnotationText() {
        String text = "";
        if (this.comment.isDraft()) {
            text = "DRAFT ";
        }
        return text;
    }

    @Override
    protected boolean represents(IComment comment) {
        return this.comment.getId().equals(comment.getId());
    }

    @Override
    protected Control update(Composite parentComposite, FormToolkit toolkit, IComment newComment) {
        this.comment = newComment;
        Control createControl = this.createOrUpdateControl(parentComposite, toolkit);
        return createControl;
    }

    @Override
    protected CommentPart createChildPart(IComment comment) {
        return new CommentPart(comment);
    }

    @Override
    protected Composite createSectionContents(Section section, FormToolkit toolkit) {
        this.composite = super.createSectionContents(section, toolkit);
        this.updateChildren(this.composite, toolkit, false, this.comment.getReplies());
        return this.composite;
    }
}

