/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.annotations;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotation;
import org.eclipse.mylyn.internal.reviews.ui.annotations.IReviewAnnotationModel;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IFileRevision;
import org.eclipse.mylyn.reviews.core.model.ILineLocation;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.ITopic;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReviewAnnotationModel
implements IAnnotationModel,
IReviewAnnotationModel {
    private final Set<CommentAnnotation> annotations = new HashSet<CommentAnnotation>(32);
    private final Set<IAnnotationModelListener> annotationModelListeners = new HashSet<IAnnotationModelListener>(2);
    private final ITextEditor textEditor;
    private final IEditorInput editorInput;
    private IDocument editorDocument;
    private IFileItem crucibleFile;
    private boolean annotated = false;
    private final IDocumentListener documentListener = new IDocumentListener(){

        public void documentChanged(DocumentEvent event) {
            ReviewAnnotationModel.this.updateAnnotations(false);
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }
    };
    private final IFileRevision revision;

    public ReviewAnnotationModel(ITextEditor editor, IEditorInput editorInput, IDocument document, IFileItem crucibleFile, IFileRevision revision) {
        this.textEditor = editor;
        this.editorInput = editorInput;
        this.editorDocument = document;
        this.crucibleFile = crucibleFile;
        this.revision = revision;
        this.updateAnnotations(true);
    }

    protected void updateAnnotations(boolean force) {
        boolean annotate = false;
        annotate = this.textEditor == null && this.editorInput == null && this.editorDocument != null ? true : (this.editorDocument == null ? false : !this.textEditor.isDirty() && this.editorInput != null && this.crucibleFile != null);
        if (annotate) {
            if (!this.annotated || force) {
                this.createAnnotations();
                this.annotated = true;
            }
        } else if (this.annotated) {
            this.clear();
            this.annotated = false;
        }
    }

    protected void clear() {
        AnnotationModelEvent event = new AnnotationModelEvent((IAnnotationModel)this);
        this.clear(event);
        this.fireModelChanged(event);
    }

    protected void clear(AnnotationModelEvent event) {
        for (CommentAnnotation commentAnnotation : this.annotations) {
            event.annotationRemoved((Annotation)commentAnnotation, commentAnnotation.getPosition());
        }
        this.annotations.clear();
    }

    protected void createAnnotations() {
        AnnotationModelEvent event = new AnnotationModelEvent((IAnnotationModel)this);
        this.clear(event);
        if (this.revision != null) {
            for (ITopic comment : this.revision.getTopics()) {
                this.createCommentAnnotation(event, comment);
            }
        } else if (this.crucibleFile != null) {
            for (ITopic comment : this.crucibleFile.getTopics()) {
                this.createCommentAnnotation(event, comment);
            }
        }
        this.fireModelChanged(event);
    }

    private void createCommentAnnotation(AnnotationModelEvent event, ITopic comment) {
        try {
            int startLine = 0;
            int endLine = 0;
            ILineLocation location = (ILineLocation)comment.getLocation();
            location.getRanges();
            startLine = location.getTotalMin();
            endLine = location.getTotalMax();
            int offset = 0;
            int length = 0;
            if (startLine != 0) {
                offset = this.editorDocument.getLineOffset(startLine - 1);
                if (endLine == 0) {
                    endLine = startLine;
                }
                length = Math.max(this.editorDocument.getLineOffset(endLine - 1) - offset, 0);
            }
            CommentAnnotation ca = new CommentAnnotation(offset, length, comment);
            this.annotations.add(ca);
            event.annotationAdded((Annotation)ca);
        }
        catch (BadLocationException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Unable to add annotation.", (Throwable)e));
        }
    }

    public void addAnnotationModelListener(IAnnotationModelListener listener) {
        if (!this.annotationModelListeners.contains(listener)) {
            this.annotationModelListeners.add(listener);
            this.fireModelChanged(new AnnotationModelEvent((IAnnotationModel)this, true));
        }
    }

    public void removeAnnotationModelListener(IAnnotationModelListener listener) {
        this.annotationModelListeners.remove(listener);
    }

    protected void fireModelChanged(AnnotationModelEvent event) {
        event.markSealed();
        if (!event.isEmpty()) {
            for (IAnnotationModelListener listener : this.annotationModelListeners) {
                if (listener instanceof IAnnotationModelListenerExtension) {
                    ((IAnnotationModelListenerExtension)listener).modelChanged(event);
                    continue;
                }
                listener.modelChanged((IAnnotationModel)this);
            }
        }
    }

    public void connect(IDocument document) {
        for (CommentAnnotation commentAnnotation : this.annotations) {
            try {
                document.addPosition(commentAnnotation.getPosition());
            }
            catch (BadLocationException e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", e.getMessage(), (Throwable)e));
            }
        }
        document.addDocumentListener(this.documentListener);
    }

    public void disconnect(IDocument document) {
        for (CommentAnnotation commentAnnotation : this.annotations) {
            document.removePosition(commentAnnotation.getPosition());
        }
        document.removeDocumentListener(this.documentListener);
    }

    public void addAnnotation(Annotation annotation, Position position) {
    }

    public void removeAnnotation(Annotation annotation) {
    }

    public Iterator<CommentAnnotation> getAnnotationIterator() {
        return this.annotations.iterator();
    }

    public Position getPosition(Annotation annotation) {
        if (annotation instanceof CommentAnnotation) {
            return ((CommentAnnotation)annotation).getPosition();
        }
        return null;
    }

    public void updateCrucibleFile(IFileItem newCrucibleFile, IReview newReview) {
        this.crucibleFile = newCrucibleFile;
        this.updateAnnotations(true);
    }

    public IFileItem getCrucibleFile() {
        return this.crucibleFile;
    }

    public CommentAnnotation getFirstAnnotationForOffset(int offset) {
        for (CommentAnnotation annotation : this.annotations) {
            if (annotation.getPosition().offset > offset || annotation.getPosition().length + annotation.getPosition().offset < offset) continue;
            return annotation;
        }
        return null;
    }

    public List<CommentAnnotation> getAnnotationsForOffset(int offset) {
        ArrayList<CommentAnnotation> result = new ArrayList<CommentAnnotation>();
        for (CommentAnnotation annotation : this.annotations) {
            if (annotation.getPosition().offset > offset || annotation.getPosition().length + annotation.getPosition().offset < offset) continue;
            result.add(annotation);
        }
        return result;
    }

    @Override
    public void setEditorDocument(IDocument editorDocument) {
        this.editorDocument = editorDocument;
        this.updateAnnotations(true);
    }
}

