/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gwtjsonrpc.server.JsonServlet;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;

public class JSonSupport {
    private Gson gson;

    public JSonSupport() {
        ExclusionStrategy exclustionStrategy = new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                return f.getDeclaredClass() == List.class && f.getName().equals("commentLinks");
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        };
        this.gson = JsonServlet.defaultGsonBuilder().registerTypeAdapter(JSonResponse.class, (Object)new JSonResponseDeserializer()).registerTypeAdapter(Edit.class, (Object)new JsonDeserializer<Edit>(){

            public Edit deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonArray array;
                if (json.isJsonArray() && (array = json.getAsJsonArray()).size() == 4) {
                    return new Edit(array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt(), array.get(3).getAsInt());
                }
                return new Edit(0, 0);
            }
        }).setExclusionStrategies(new ExclusionStrategy[]{exclustionStrategy}).create();
    }

    public Gson getGson() {
        return this.gson;
    }

    String createRequest(int id, String xsrfKey, String methodName, Collection<Object> args) {
        JsonRequest msg = new JsonRequest();
        msg.method = methodName;
        if (args != null) {
            for (Object arg : args) {
                msg.params.add(arg);
            }
        }
        msg.id = id;
        msg.xsrfKey = xsrfKey;
        return this.gson.toJson((Object)msg, msg.getClass());
    }

    <T> T parseResponse(String responseMessage, Type resultType) throws GerritException {
        JSonResponse response = (JSonResponse)this.gson.fromJson(responseMessage, JSonResponse.class);
        if (response.error != null) {
            JSonError error = (JSonError)this.gson.fromJson(response.error, JSonError.class);
            throw new GerritException(error.message, error.code);
        }
        return (T)this.gson.fromJson(response.result, resultType);
    }

    static class JSonError {
        int code;
        String message;

        JSonError() {
        }
    }

    static class JSonResponse {
        JsonElement error;
        int id;
        String jsonrpc;
        JsonElement result;

        JSonResponse() {
        }
    }

    private class JSonResponseDeserializer
    implements JsonDeserializer<JSonResponse> {
        private JSonResponseDeserializer() {
        }

        public JSonResponse deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            JSonResponse response = new JSonResponse();
            response.jsonrpc = object.get("jsonrpc").getAsString();
            response.id = object.get("id").getAsInt();
            response.result = object.get("result");
            response.error = object.get("error");
            return response;
        }
    }

    static class JsonRequest {
        int id;
        final String jsonrpc = "2.0";
        String method;
        final List<Object> params = new ArrayList<Object>();
        String xsrfKey;

        JsonRequest() {
        }
    }
}

