/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.gerrit.common.auth.userpass.LoginResult;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.UnsupportedRequestException;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritLoginException;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;

public class GerritHttpClient {
    private static final Object LOGIN_COOKIE_NAME = "GerritAccount";
    private static final String LOGIN_URL = "/login/mine";
    private static final String BECOME_URL = "/become";
    private HostConfiguration hostConfiguration;
    private final HttpClient httpClient;
    private int id = 1;
    private final AbstractWebLocation location;
    private volatile Cookie xsrfCookie;

    public GerritHttpClient(AbstractWebLocation location) {
        this.location = location;
        this.httpClient = new HttpClient(WebUtil.getConnectionManager());
    }

    public synchronized int getId() {
        return this.id++;
    }

    public AbstractWebLocation getLocation() {
        return this.location;
    }

    public synchronized String getXsrfKey() {
        return this.xsrfCookie != null ? this.xsrfCookie.getValue() : null;
    }

    public String postJsonRequest(String serviceUri, JsonEntity entity, IProgressMonitor monitor) throws IOException, GerritException {
        this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
        int attempt = 0;
        while (attempt < 2) {
            PostMethod method;
            int code;
            AuthenticationCredentials credentials;
            if (this.needsAuthentication() && (credentials = this.location.getCredentials(AuthenticationType.REPOSITORY)) != null) {
                this.authenticate(monitor);
            }
            if ((code = (method = this.postJsonRequestInternal(serviceUri, entity, monitor)).getStatusCode()) == 200) {
                return method.getResponseBodyAsString();
            }
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            if (code != 401 && code != 403) {
                throw new GerritHttpException(code);
            }
            this.authenticate(monitor);
            ++attempt;
        }
        throw new GerritLoginException();
    }

    private PostMethod postJsonRequestInternal(String serviceUri, JsonEntity entity, IProgressMonitor monitor) throws IOException {
        PostMethod method = new PostMethod(String.valueOf(this.getUrl()) + serviceUri);
        method.setRequestHeader("Content-Type", "application/json; charset=utf-8");
        method.setRequestHeader("Accept", "application/json");
        try {
            StringRequestEntity requestEntity = new StringRequestEntity(entity.getContent(), "application/json", null);
            method.setRequestEntity((RequestEntity)requestEntity);
            WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
            return method;
        }
        catch (IOException e) {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            throw e;
        }
        catch (RuntimeException e) {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            throw e;
        }
    }

    GetMethod getRequest(String serviceUri, IProgressMonitor monitor) throws IOException {
        GetMethod method = new GetMethod(String.valueOf(this.getUrl()) + serviceUri);
        try {
            WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
            return method;
        }
        catch (IOException e) {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            throw e;
        }
        catch (RuntimeException e) {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            throw e;
        }
    }

    private String getUrl() {
        String url = this.location.getUrl();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    private void authenticate(IProgressMonitor monitor) throws GerritException, IOException {
        block3: {
            int code;
            AuthenticationCredentials credentials;
            while (true) {
                if ((credentials = this.location.getCredentials(AuthenticationType.REPOSITORY)) == null) {
                    throw new GerritLoginException();
                }
                code = this.authenticateForm(credentials, monitor);
                if (code == -1) continue;
                if (code != 404) break block3;
                code = this.authenticateService(credentials, monitor);
                if (code != -1) break;
            }
            if (code == 404) {
                this.authenticateTestMode(credentials, monitor);
            }
        }
        this.validateAuthenticationState(this.httpClient);
    }

    private int authenticateService(AuthenticationCredentials credentials, IProgressMonitor monitor) throws IOException, GerritException {
        JSonSupport json = new JSonSupport();
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(credentials.getUserName());
        args.add(credentials.getPassword());
        final String request = json.createRequest(this.getId(), null, "authenticate", args);
        JsonEntity entity = new JsonEntity(){

            @Override
            public String getContent() {
                return request;
            }
        };
        PostMethod method = this.postJsonRequestInternal("/gerrit/rpc/UserPassAuthService", entity, monitor);
        try {
            int code = method.getStatusCode();
            if (this.needsReauthentication(code, monitor)) {
                return -1;
            }
            if (code == 200) {
                LoginResult result = (LoginResult)json.parseResponse(method.getResponseBodyAsString(), (Type)((Object)LoginResult.class));
                if (result.success) {
                    return 307;
                }
                this.requestCredentials(monitor, AuthenticationType.REPOSITORY);
                return -1;
            }
            int n = code;
            return n;
        }
        finally {
            method.releaseConnection();
        }
    }

    private int authenticateTestMode(AuthenticationCredentials credentials, IProgressMonitor monitor) throws IOException, GerritException {
        String repositoryUrl = this.getUrl();
        GetMethod method = new GetMethod(WebUtil.getRequestPath((String)(String.valueOf(repositoryUrl) + BECOME_URL + "?user_name=" + credentials.getUserName())));
        method.setFollowRedirects(false);
        try {
            int code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
            if (this.needsReauthentication(code, monitor)) {
                return -1;
            }
            if (code != 404 && code != 302) {
                throw new GerritHttpException(code);
            }
            int n = code;
            return n;
        }
        finally {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
        }
    }

    private int authenticateForm(AuthenticationCredentials credentials, IProgressMonitor monitor) throws IOException, GerritException {
        String repositoryUrl = this.getUrl();
        AuthScope authScope = new AuthScope(WebUtil.getHost((String)repositoryUrl), WebUtil.getPort((String)repositoryUrl), null, AuthScope.ANY_SCHEME);
        Credentials httpCredentials = WebUtil.getHttpClientCredentials((AuthenticationCredentials)credentials, (String)WebUtil.getHost((String)repositoryUrl));
        this.httpClient.getState().setCredentials(authScope, httpCredentials);
        GetMethod method = new GetMethod(WebUtil.getRequestPath((String)(String.valueOf(repositoryUrl) + LOGIN_URL)));
        method.setFollowRedirects(false);
        try {
            int code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
            if (this.needsReauthentication(code, monitor)) {
                return -1;
            }
            if (code == 302) {
                Header locationHeader = method.getResponseHeader("Location");
                if (locationHeader != null && locationHeader.getValue().endsWith("#SignInFailure,SIGN_IN,Session cookie not available.")) {
                    return 404;
                }
            } else if (code != 404) {
                throw new GerritHttpException(code);
            }
            int n = code;
            return n;
        }
        finally {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
        }
    }

    private synchronized boolean needsAuthentication() {
        return this.xsrfCookie == null || this.xsrfCookie.isExpired();
    }

    private boolean needsReauthentication(int code, IProgressMonitor monitor) throws IOException, GerritLoginException {
        AuthenticationType authenticationType;
        if (code == 401 || code == 403) {
            authenticationType = AuthenticationType.REPOSITORY;
        } else if (code == 407) {
            authenticationType = AuthenticationType.PROXY;
        } else {
            return false;
        }
        this.requestCredentials(monitor, authenticationType);
        return true;
    }

    void requestCredentials(IProgressMonitor monitor, AuthenticationType authenticationType) throws GerritLoginException {
        try {
            this.location.requestCredentials(authenticationType, null, monitor);
        }
        catch (UnsupportedRequestException unsupportedRequestException) {
            throw new GerritLoginException();
        }
        this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateAuthenticationState(HttpClient httpClient) throws GerritLoginException {
        Cookie[] cookies;
        Cookie[] cookieArray = cookies = httpClient.getState().getCookies();
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if (LOGIN_COOKIE_NAME.equals(cookie.getName())) {
                GerritHttpClient gerritHttpClient = this;
                synchronized (gerritHttpClient) {
                    this.xsrfCookie = cookie;
                }
                return;
            }
            ++n2;
        }
        if (CoreUtil.TEST_MODE) {
            System.err.println(" Authentication failed: " + httpClient.getState());
        }
        throw new GerritLoginException();
    }

    public boolean isAnonymous() {
        return this.getLocation().getCredentials(AuthenticationType.REPOSITORY) == null;
    }

    public static abstract class JsonEntity {
        public abstract String getContent();
    }
}

