/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core;

import com.google.gerrit.common.data.AccountInfo;
import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.ChangeInfo;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.ChangeMessage;
import java.util.Date;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.GerritTaskSchema;
import org.eclipse.mylyn.internal.gerrit.core.GerritUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritChange;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.tasks.core.IRepositoryPerson;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskSchema;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskCommentMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class GerritTaskDataHandler
extends AbstractTaskDataHandler {
    private final GerritConnector connector;

    public static String dateToString(Date date) {
        if (date == null) {
            return "";
        }
        return String.valueOf(date.getTime());
    }

    public GerritTaskDataHandler(GerritConnector connector) {
        this.connector = connector;
    }

    public TaskData createTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) {
        TaskData data = new TaskData(this.getAttributeMapper(repository), "org.eclipse.mylyn.gerrit", repository.getRepositoryUrl(), taskId);
        this.initializeTaskData(repository, data, null, monitor);
        return data;
    }

    public TaskAttributeMapper getAttributeMapper(TaskRepository repository) {
        return new TaskAttributeMapper(repository);
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        try {
            GerritClient client = this.connector.getClient(repository);
            client.refreshConfigOnce(monitor);
            GerritChange review = client.getChange(taskId, monitor);
            TaskData taskData = this.createTaskData(repository, taskId, monitor);
            this.updateTaskData(repository, taskData, review, !client.isAnonymous());
            return taskData;
        }
        catch (GerritException e) {
            throw this.connector.toCoreException(repository, e);
        }
    }

    public boolean initializeTaskData(TaskRepository repository, TaskData taskData, ITaskMapping initializationData, IProgressMonitor monitor) {
        GerritTaskSchema.getDefault().initialize(taskData);
        return true;
    }

    public RepositoryResponse postTaskData(TaskRepository repository, TaskData taskData, Set<TaskAttribute> oldAttributes, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void updateTaskData(TaskRepository repository, TaskData data, GerritChange review, boolean canPublish) {
        GerritTaskSchema schema = GerritTaskSchema.getDefault();
        ChangeDetail changeDetail = review.getChangeDetail();
        Change change = changeDetail.getChange();
        AccountInfo owner = changeDetail.getAccounts().get(change.getOwner());
        this.setAttributeValue(data, schema.KEY, change.getId().toString());
        this.setAttributeValue(data, schema.CHANGE_ID, change.getKey().get());
        this.setAttributeValue(data, schema.BRANCH, change.getDest().get());
        this.setAttributeValue(data, schema.OWNER, GerritUtil.getUserLabel(owner));
        this.setAttributeValue(data, schema.PROJECT, change.getProject().get());
        this.setAttributeValue(data, schema.SUMMARY, change.getSubject());
        this.setAttributeValue(data, schema.STATUS, change.getStatus().toString());
        this.setAttributeValue(data, schema.UPDATED, GerritTaskDataHandler.dateToString(change.getLastUpdatedOn()));
        this.setAttributeValue(data, schema.UPLOADED, GerritTaskDataHandler.dateToString(change.getCreatedOn()));
        this.setAttributeValue(data, schema.DESCRIPTION, changeDetail.getDescription());
        this.setAttributeValue(data, schema.URL, this.connector.getTaskUrl(repository.getUrl(), data.getTaskId()));
        if (change.getStatus() != null && change.getStatus().isClosed()) {
            this.setAttributeValue(data, schema.COMPLETED, GerritTaskDataHandler.dateToString(change.getLastUpdatedOn()));
        }
        int i = 1;
        for (ChangeMessage message : changeDetail.getMessages()) {
            TaskCommentMapper mapper = new TaskCommentMapper();
            if (message.getAuthor() != null) {
                AccountInfo author = changeDetail.getAccounts().get(message.getAuthor());
                IRepositoryPerson person = repository.createPerson(author.getPreferredEmail() != null ? author.getPreferredEmail() : "" + author.getId());
                person.setName(author.getFullName());
                mapper.setAuthor(person);
            }
            mapper.setText(message.getMessage());
            mapper.setCreationDate((Date)message.getWrittenOn());
            mapper.setNumber(Integer.valueOf(i));
            TaskAttribute attribute = data.getRoot().createAttribute("task.common.comment-" + i);
            mapper.applyTo(attribute);
            ++i;
        }
        JSonSupport json = new JSonSupport();
        this.setAttributeValue(data, schema.OBJ_REVIEW, json.getGson().toJson((Object)review));
        this.setAttributeValue(data, schema.CAN_PUBLISH, Boolean.toString(canPublish));
    }

    public void updateTaskData(TaskData data, ChangeInfo changeInfo) {
        GerritTaskSchema schema = GerritTaskSchema.getDefault();
        this.setAttributeValue(data, schema.KEY, "" + changeInfo.getId());
        this.setAttributeValue(data, schema.OWNER, changeInfo.getOwner().toString());
        this.setAttributeValue(data, schema.PROJECT, changeInfo.getProject().getName());
        this.setAttributeValue(data, schema.SUMMARY, changeInfo.getSubject());
        this.setAttributeValue(data, schema.STATUS, changeInfo.getStatus().toString());
        this.setAttributeValue(data, schema.UPDATED, GerritTaskDataHandler.dateToString(changeInfo.getLastUpdatedOn()));
    }

    private TaskAttribute setAttributeValue(TaskData data, AbstractTaskSchema.Field gerritAttribut, String value) {
        TaskAttribute attribute = data.getRoot().getAttribute(gerritAttribut.getKey());
        if (value != null) {
            attribute.setValue(value);
        }
        return attribute;
    }
}

