/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core;

import com.google.gerrit.common.data.ChangeDetail;
import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.common.data.ReviewerResult;
import org.eclipse.mylyn.internal.gerrit.core.GerritConnector;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.operations.AbandonRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.AddReviewersRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.GerritOperation;
import org.eclipse.mylyn.internal.gerrit.core.operations.PublishRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.RefreshConfigRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.RestoreRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.SubmitRequest;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public class GerritOperationFactory {
    private final IRepositoryManager repositoryManager;

    public GerritOperationFactory(IRepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    public GerritOperation createAbandonOperation(ITask review, AbandonRequest request) {
        return new GerritOperation<ChangeDetail>("Abandoning Change", this.getClient(review), request);
    }

    public GerritOperation createAddReviewersOperation(ITask review, AddReviewersRequest request) {
        return new GerritOperation<ReviewerResult>("Adding Reviewers", this.getClient(review), request);
    }

    public GerritOperation createPublishOperation(ITask review, PublishRequest request) {
        return new GerritOperation<Object>("Publishing Change", this.getClient(review), request);
    }

    public GerritOperation createRefreshConfigOperation(ITask review, RefreshConfigRequest request) {
        return new GerritOperation<GerritConfig>("Refreshing Configuration", this.getClient(review), request);
    }

    public GerritOperation createRestoreOperation(ITask review, RestoreRequest request) {
        return new GerritOperation<ChangeDetail>("Restoring Change", this.getClient(review), request);
    }

    public GerritOperation createSubmitOperation(ITask review, SubmitRequest request) {
        return new GerritOperation<ChangeDetail>("Submitting Change", this.getClient(review), request);
    }

    public GerritClient getClient(ITask review) {
        TaskRepository repository = this.repositoryManager.getRepository(review.getConnectorKind(), review.getRepositoryUrl());
        GerritConnector connector = (GerritConnector)this.repositoryManager.getRepositoryConnector(repository.getConnectorKind());
        GerritClient client = connector.getClient(repository);
        return client;
    }
}

