/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core;

import com.google.gerrit.common.data.ChangeInfo;
import com.google.gerrit.common.data.GerritConfig;
import java.util.Date;
import java.util.List;
import org.apache.commons.httpclient.HttpStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.gerrit.core.GerritCorePlugin;
import org.eclipse.mylyn.internal.gerrit.core.GerritTaskDataHandler;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritLoginException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritSystemInfo;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.core.sync.ISynchronizationSession;
import org.eclipse.osgi.util.NLS;

public class GerritConnector
extends AbstractRepositoryConnector {
    public static final String CHANGE_PREFIX = "/#change,";
    public static final String CONNECTOR_KIND = "org.eclipse.mylyn.gerrit";
    private static final String KEY_REPOSITORY_CONFIG = "org.eclipse.mylyn.gerrit.config";
    private final GerritTaskDataHandler taskDataHandler = new GerritTaskDataHandler(this);
    private TaskRepositoryLocationFactory taskRepositoryLocationFactory = new TaskRepositoryLocationFactory();

    public GerritConnector() {
        if (GerritCorePlugin.getDefault() != null) {
            GerritCorePlugin.getDefault().setConnector(this);
        }
    }

    public boolean canCreateNewTask(TaskRepository arg0) {
        return false;
    }

    public boolean canCreateTaskFromKey(TaskRepository arg0) {
        return false;
    }

    public GerritClient getClient(TaskRepository repository) {
        return this.createClient(repository);
    }

    public String getConnectorKind() {
        return CONNECTOR_KIND;
    }

    public String getLabel() {
        return "Gerrit Code Review (supports 2.1.5 and later)";
    }

    public String getRepositoryUrlFromTaskUrl(String url) {
        return null;
    }

    public TaskData getTaskData(TaskRepository repository, String taskId, IProgressMonitor monitor) throws CoreException {
        return this.taskDataHandler.getTaskData(repository, taskId, monitor);
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return this.taskDataHandler;
    }

    public String getTaskIdFromTaskUrl(String url) {
        int index;
        if (url != null && url.length() > 0 && (index = url.indexOf(CHANGE_PREFIX)) > 0) {
            return url.substring(index + CHANGE_PREFIX.length());
        }
        return null;
    }

    public ITaskMapping getTaskMapping(TaskData taskData) {
        return new TaskMapper(taskData);
    }

    public synchronized TaskRepositoryLocationFactory getTaskRepositoryLocationFactory() {
        return this.taskRepositoryLocationFactory;
    }

    public String getTaskUrl(String repositoryUrl, String taskId) {
        String url = String.valueOf(repositoryUrl) + CHANGE_PREFIX + taskId;
        return repositoryUrl != null && taskId != null ? url : null;
    }

    public boolean hasTaskChanged(TaskRepository repository, ITask task, TaskData taskData) {
        ITaskMapping taskMapping = this.getTaskMapping(taskData);
        Date repositoryDate = taskMapping.getModificationDate();
        Date localDate = task.getModificationDate();
        return repositoryDate == null || !repositoryDate.equals(localDate);
    }

    public IStatus performQuery(TaskRepository repository, IRepositoryQuery query, TaskDataCollector resultCollector, ISynchronizationSession session, IProgressMonitor monitor) {
        try {
            monitor.beginTask("Executing query", -1);
            GerritClient client = this.getClient(repository);
            client.refreshConfigOnce(monitor);
            List<ChangeInfo> result = null;
            if ("all open changes".equals(query.getAttribute("gerrit query type"))) {
                result = client.queryAllReviews(monitor);
            } else if ("my open changes".equals(query.getAttribute("gerrit query type"))) {
                result = client.queryMyReviews(monitor);
            } else if ("open changes by project".equals(query.getAttribute("gerrit query type"))) {
                String project = query.getAttribute("gerrit query project");
                result = client.queryByProject(monitor, project);
            }
            if (result != null) {
                for (ChangeInfo changeInfo : result) {
                    TaskData taskData = this.taskDataHandler.createTaskData(repository, "" + changeInfo.getId(), monitor);
                    taskData.setPartial(true);
                    this.taskDataHandler.updateTaskData(taskData, changeInfo);
                    resultCollector.accept(taskData);
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            Status status = new Status(4, "org.eclipse.mylyn.gerrit.core", NLS.bind((String)"Unknows query type: {0}", (Object)query.getAttribute("gerrit query project")));
            return status;
        }
        catch (UnsupportedClassVersionError e) {
            Status status = this.toStatus(repository, e);
            return status;
        }
        catch (GerritException e) {
            Status status = this.toStatus(repository, e);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    public synchronized void setTaskRepositoryLocationFactory(TaskRepositoryLocationFactory taskRepositoryLocationFactory) {
        this.taskRepositoryLocationFactory = taskRepositoryLocationFactory;
    }

    public void updateRepositoryConfiguration(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        try {
            this.getClient(repository).refreshConfig(monitor);
        }
        catch (GerritException e) {
            throw this.toCoreException(repository, e);
        }
    }

    public void updateTaskFromTaskData(TaskRepository taskRepository, ITask task, TaskData taskData) {
        TaskMapper mapper = (TaskMapper)this.getTaskMapping(taskData);
        mapper.applyTo(task);
    }

    public GerritSystemInfo validate(TaskRepository repository, IProgressMonitor monitor) throws CoreException {
        try {
            return this.createClient(repository).getInfo(Policy.backgroundMonitorFor((IProgressMonitor)monitor));
        }
        catch (UnsupportedClassVersionError e) {
            throw this.toCoreException(repository, e);
        }
        catch (GerritException e) {
            throw this.toCoreException(repository, e);
        }
    }

    private GerritClient createClient(final TaskRepository repository) {
        GerritConfig config = GerritClient.configFromString(repository.getProperty(KEY_REPOSITORY_CONFIG));
        return new GerritClient(this.taskRepositoryLocationFactory.createWebLocation(repository), config){

            @Override
            protected void configurationChanged(GerritConfig config) {
                repository.setProperty(GerritConnector.KEY_REPOSITORY_CONFIG, GerritClient.configToString(config));
            }
        };
    }

    CoreException toCoreException(TaskRepository repository, GerritException e) {
        return new CoreException((IStatus)this.toStatus(repository, e));
    }

    CoreException toCoreException(TaskRepository repository, UnsupportedClassVersionError e) {
        return new CoreException((IStatus)this.toStatus(repository, e));
    }

    Status toStatus(TaskRepository repository, GerritException e) {
        String message;
        if (e instanceof GerritHttpException) {
            int code = ((GerritHttpException)e).getResponseCode();
            message = NLS.bind((String)"Unexpected error: {1} ({0})", (Object)code, (Object)HttpStatus.getStatusText((int)code));
        } else {
            message = e instanceof GerritLoginException ? "Login failed" : (e.getMessage() != null ? NLS.bind((String)"Unexpected error: {0}", (Object)e.getMessage()) : "Unexpected error while communicating with Gerrit");
        }
        return new Status(4, "org.eclipse.mylyn.gerrit.core", message, (Throwable)e);
    }

    Status toStatus(TaskRepository repository, UnsupportedClassVersionError e) {
        String message = NLS.bind((String)"The Gerrit Connector requires at Java 1.6 or higer (installed version: {0})", (Object)System.getProperty("java.version"));
        return new Status(4, "org.eclipse.mylyn.gerrit.core", message, (Throwable)e);
    }
}

