/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind.ui;

import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.user.client.ui.ImageBundle;
import com.google.gwt.user.rebind.ClassSourceFileComposerFactory;
import com.google.gwt.user.rebind.SourceWriter;
import com.google.gwt.user.rebind.ui.ImageBundleBuilder;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;

public class ImageBundleGenerator
extends Generator {
    static final String MSG_NO_FILE_BASED_ON_METHOD_NAME = "No matching image resource was found; any of the following filenames would have matched had they been present:";
    private static final String ABSTRACTIMAGEPROTOTYPE_QNAME = "com.google.gwt.user.client.ui.AbstractImagePrototype";
    private static final String CLIPPEDIMAGEPROTOTYPE_QNAME = "com.google.gwt.user.client.ui.impl.ClippedImagePrototype";
    private static final String GWT_QNAME = "com.google.gwt.core.client.GWT";
    private static final String[] IMAGE_FILE_EXTENSIONS = new String[]{"png", "gif", "jpg"};
    private static final String IMAGEBUNDLE_QNAME = "com.google.gwt.user.client.ui.ImageBundle";
    private final ResourceLocator resLocator;

    static String msgCannotFindImageFromMetaData(String imgResName) {
        return "Unable to find image resource '" + imgResName + "'";
    }

    public ImageBundleGenerator() {
        this(new ResourceLocator(){

            public boolean isResourcePresent(String resName) {
                URL url = this.getClass().getClassLoader().getResource(resName);
                return url != null;
            }
        });
    }

    ImageBundleGenerator(ResourceLocator resourceLocator) {
        assert (resourceLocator != null);
        this.resLocator = resourceLocator;
    }

    public String generate(TreeLogger logger, GeneratorContext context, String typeName) throws UnableToCompleteException {
        TypeOracle typeOracle = context.getTypeOracle();
        JClassType userType = this.getValidUserType(logger, typeName, typeOracle);
        JMethod[] imgMethods = userType.getOverridableMethods();
        String resultName = this.generateImplClass(logger, context, userType, imgMethods);
        return resultName;
    }

    String getImageResourceName(TreeLogger logger, JMethodOracle method) throws UnableToCompleteException {
        String imgName = this.tryGetImageNameFromMetaData(logger, method);
        if (imgName != null) {
            return imgName;
        }
        return this.getImageNameFromMethodName(logger, method);
    }

    private String computeSubclassName(JClassType userType) {
        String baseName = userType.getName().replace('.', '_');
        return baseName + "_generatedBundle";
    }

    private void generateImageMethod(ImageBundleBuilder compositeImage, SourceWriter sw, JMethod method, String imgResName) {
        String decl = method.getReadableDeclaration(false, true, true, true, true);
        sw.indent();
        ImageBundleBuilder.ImageRect imageRect = compositeImage.getMapping(imgResName);
        String singletonName = method.getName() + "_SINGLETON";
        sw.print("private static final ClippedImagePrototype ");
        sw.print(singletonName);
        sw.print(" = new ClippedImagePrototype(IMAGE_BUNDLE_URL, ");
        sw.print(Integer.toString(imageRect.getLeft()));
        sw.print(", ");
        sw.print(Integer.toString(imageRect.getTop()));
        sw.print(", ");
        sw.print(Integer.toString(imageRect.getWidth()));
        sw.print(", ");
        sw.print(Integer.toString(imageRect.getHeight()));
        sw.println(");");
        sw.print(decl);
        sw.println(" {");
        sw.indent();
        sw.print("return ");
        sw.print(singletonName);
        sw.println(";");
        sw.outdent();
        sw.println("}");
        sw.outdent();
    }

    private String generateImplClass(TreeLogger logger, GeneratorContext context, JClassType userType, JMethod[] imageMethods) throws UnableToCompleteException {
        JClassType abstractImagePrototype;
        try {
            abstractImagePrototype = userType.getOracle().getType(ABSTRACTIMAGEPROTOTYPE_QNAME);
        }
        catch (NotFoundException e) {
            logger.log(TreeLogger.ERROR, "GWT com.google.gwt.user.client.ui.AbstractImagePrototype class is not available", (Throwable)e);
            throw new UnableToCompleteException();
        }
        String pkgName = userType.getPackage().getName();
        String subName = this.computeSubclassName(userType);
        ClassSourceFileComposerFactory f = new ClassSourceFileComposerFactory(pkgName, subName);
        f.addImport(ABSTRACTIMAGEPROTOTYPE_QNAME);
        f.addImport(CLIPPEDIMAGEPROTOTYPE_QNAME);
        f.addImport(GWT_QNAME);
        f.addImplementedInterface(userType.getQualifiedSourceName());
        PrintWriter pw = context.tryCreate(logger, pkgName, subName);
        if (pw != null) {
            SourceWriter sw = f.createSourceWriter(context, pw);
            ImageBundleBuilder bulder = new ImageBundleBuilder();
            ArrayList<String> imageResNames = new ArrayList<String>();
            for (JMethod method : imageMethods) {
                String branchMsg = "Analyzing method '" + method.getName() + "' in type " + userType.getQualifiedSourceName();
                TreeLogger branch = logger.branch(TreeLogger.DEBUG, branchMsg, null);
                if (method.getReturnType() != abstractImagePrototype) {
                    branch.log(TreeLogger.ERROR, "Return type must be com.google.gwt.user.client.ui.AbstractImagePrototype", null);
                    throw new UnableToCompleteException();
                }
                if (method.getParameters().length > 0) {
                    branch.log(TreeLogger.ERROR, "Method must have zero parameters", null);
                    throw new UnableToCompleteException();
                }
                String imageResName = this.getImageResourceName(branch, new JMethodOracleImpl(method));
                assert (imageResName != null);
                imageResNames.add(imageResName);
                bulder.assimilate(logger, imageResName);
            }
            String bundledImageUrl = bulder.writeBundledImage(logger, context);
            sw.print("private static final String IMAGE_BUNDLE_URL = GWT.getModuleBaseURL() + \"");
            sw.print(ImageBundleGenerator.escape((String)bundledImageUrl));
            sw.println("\";");
            int imageResNameIndex = 0;
            for (JMethod method : imageMethods) {
                this.generateImageMethod(bulder, sw, method, (String)imageResNames.get(imageResNameIndex++));
            }
            sw.commit(logger);
        }
        return f.getCreatedClassName();
    }

    private String getImageNameFromMethodName(TreeLogger logger, JMethodOracle method) throws UnableToCompleteException {
        String pkgName = method.getPackageName();
        String pkgPrefix = pkgName.replace('.', '/');
        if (pkgPrefix.length() > 0) {
            pkgPrefix = pkgPrefix + "/";
        }
        String methodName = method.getName();
        String pkgAndMethodName = pkgPrefix + methodName;
        ArrayList<String> testImgNames = new ArrayList<String>();
        for (int i = 0; i < IMAGE_FILE_EXTENSIONS.length; ++i) {
            String testImgName = pkgAndMethodName + '.' + IMAGE_FILE_EXTENSIONS[i];
            if (this.resLocator.isResourcePresent(testImgName)) {
                return testImgName;
            }
            testImgNames.add(testImgName);
        }
        TreeLogger branch = logger.branch(TreeLogger.ERROR, MSG_NO_FILE_BASED_ON_METHOD_NAME, null);
        for (String testImgName : testImgNames) {
            branch.log(TreeLogger.ERROR, testImgName, null);
        }
        throw new UnableToCompleteException();
    }

    private JClassType getValidUserType(TreeLogger logger, String typeName, TypeOracle typeOracle) throws UnableToCompleteException {
        try {
            JClassType userType = typeOracle.getType(typeName);
            JClassType magicType = typeOracle.findType(IMAGEBUNDLE_QNAME);
            if (userType.isInterface() == null) {
                logger.log(TreeLogger.ERROR, userType.getQualifiedSourceName() + " must be an interface", null);
                throw new UnableToCompleteException();
            }
            if (!userType.isAssignableTo(magicType)) {
                logger.log(TreeLogger.ERROR, userType.getQualifiedSourceName() + " must be assignable to " + magicType.getQualifiedSourceName(), null);
                throw new UnableToCompleteException();
            }
            return userType;
        }
        catch (NotFoundException e) {
            logger.log(TreeLogger.ERROR, "Unable to find required type(s)", (Throwable)e);
            throw new UnableToCompleteException();
        }
    }

    private String tryGetImageNameFromAnnotation(JMethodOracle method) {
        ImageBundle.Resource imgResAnn = method.getAnnotation(ImageBundle.Resource.class);
        String imgName = null;
        if (imgResAnn != null) {
            imgName = imgResAnn.value();
        }
        return imgName;
    }

    private String tryGetImageNameFromMetaData(TreeLogger logger, JMethodOracle method) throws UnableToCompleteException {
        String pkgName;
        String imgFileName = this.tryGetImageNameFromAnnotation(method);
        if (imgFileName == null) {
            return null;
        }
        if (imgFileName.indexOf("/") == -1 && !"".equals(pkgName = method.getPackageName())) {
            imgFileName = pkgName.replace('.', '/') + "/" + imgFileName;
        }
        if (!this.resLocator.isResourcePresent(imgFileName)) {
            logger.log(TreeLogger.ERROR, ImageBundleGenerator.msgCannotFindImageFromMetaData(imgFileName), null);
            throw new UnableToCompleteException();
        }
        return imgFileName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface JMethodOracle {
        public ImageBundle.Resource getAnnotation(Class<ImageBundle.Resource> var1);

        public String getName();

        public String getPackageName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JMethodOracleImpl
    implements JMethodOracle {
        private final JMethod delegate;

        public JMethodOracleImpl(JMethod delegate) {
            this.delegate = delegate;
        }

        @Override
        public ImageBundle.Resource getAnnotation(Class<ImageBundle.Resource> clazz) {
            return (ImageBundle.Resource)this.delegate.getAnnotation(clazz);
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public String getPackageName() {
            return this.delegate.getEnclosingType().getPackage().getName();
        }
    }

    static interface ResourceLocator {
        public boolean isResourcePresent(String var1);
    }
}

