/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind.rpc;

import com.google.gwt.core.ext.typeinfo.JClassType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TypeHierarchyUtils {
    TypeHierarchyUtils() {
    }

    public static boolean directlyImplementsInterface(JClassType type, JClassType intf) {
        type = type.getErasedType();
        intf = intf.getErasedType();
        return TypeHierarchyUtils.directlyImplementsInterfaceRecursive(new HashSet<JClassType>(), type, intf);
    }

    public static List<JClassType> getAllTypesBetweenRootTypeAndLeaves(JClassType root, Collection<JClassType> leaves) {
        Map<JClassType, List<JClassType>> adjList = TypeHierarchyUtils.getInvertedTypeHierarchy(root.getErasedType());
        HashSet<JClassType> types = new HashSet<JClassType>();
        for (JClassType type : leaves) {
            TypeHierarchyUtils.depthFirstSearch(types, adjList, type.getErasedType());
        }
        return Arrays.asList(types.toArray(new JClassType[0]));
    }

    public static List<JClassType> getImmediateSubtypes(JClassType clazz) {
        ArrayList<JClassType> immediateSubtypes = new ArrayList<JClassType>();
        clazz = clazz.getErasedType();
        for (JClassType subclass : clazz.getSubtypes()) {
            JClassType superclass = subclass.getSuperclass();
            if (superclass != null) {
                superclass = superclass.getErasedType();
            }
            if (superclass != clazz && (clazz.isInterface() == null || !TypeHierarchyUtils.directlyImplementsInterface(subclass, clazz))) continue;
            immediateSubtypes.add(subclass);
        }
        return immediateSubtypes;
    }

    private static void addEdge(Map<JClassType, List<JClassType>> adjList, JClassType subclass, JClassType clazz) {
        List<JClassType> edges = adjList.get(subclass);
        if (edges == null) {
            edges = new ArrayList<JClassType>();
            adjList.put(subclass, edges);
        }
        edges.add(clazz);
    }

    private static void depthFirstSearch(Set<JClassType> seen, Map<JClassType, List<JClassType>> adjList, JClassType type) {
        if (seen.contains(type)) {
            return;
        }
        seen.add(type);
        List<JClassType> children = adjList.get(type);
        if (children != null) {
            for (JClassType child : children) {
                if (seen.contains(child)) continue;
                TypeHierarchyUtils.depthFirstSearch(seen, adjList, child);
            }
        }
    }

    private static boolean directlyImplementsInterfaceRecursive(Set<JClassType> seen, JClassType clazz, JClassType intf) {
        JClassType[] intfImpls;
        assert (clazz.getErasedType() == clazz);
        assert (intf.getErasedType() == intf);
        if (clazz == intf) {
            return true;
        }
        for (JClassType intfImpl : intfImpls = clazz.getImplementedInterfaces()) {
            if (seen.contains(intfImpl = intfImpl.getErasedType())) continue;
            seen.add(intfImpl);
            if (!TypeHierarchyUtils.directlyImplementsInterfaceRecursive(seen, intfImpl, intf)) continue;
            return true;
        }
        return false;
    }

    private static Map<JClassType, List<JClassType>> getInvertedTypeHierarchy(JClassType root) {
        HashMap<JClassType, List<JClassType>> adjList = new HashMap<JClassType, List<JClassType>>();
        HashSet<JClassType> seen = new HashSet<JClassType>();
        Stack<JClassType> queue = new Stack<JClassType>();
        queue.push(root);
        while (!queue.isEmpty()) {
            JClassType clazz = (JClassType)queue.pop();
            if (seen.contains(clazz)) continue;
            seen.add(clazz);
            List<JClassType> immediateSubtypes = TypeHierarchyUtils.getImmediateSubtypes(clazz);
            for (JClassType immediateSubtype : immediateSubtypes) {
                TypeHierarchyUtils.addEdge(adjList, immediateSubtype, clazz);
                queue.push(immediateSubtype);
            }
        }
        return adjList;
    }
}

