/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind.rpc;

import com.google.gwt.core.ext.typeinfo.JAnnotationType;
import com.google.gwt.core.ext.typeinfo.JArrayType;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JEnumType;
import com.google.gwt.core.ext.typeinfo.JGenericType;
import com.google.gwt.core.ext.typeinfo.JParameterizedType;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.JRawType;
import com.google.gwt.core.ext.typeinfo.JRealClassType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.JTypeParameter;
import com.google.gwt.core.ext.typeinfo.JWildcardType;

class JTypeVisitor {
    JTypeVisitor() {
    }

    public void accept(JType type) {
        this.acceptChildren(type);
        this.endVisit(type);
    }

    protected void acceptChildren(JType type) {
        JWildcardType typeWild;
        JRawType typeRaw;
        JParameterizedType typeParameterized;
        JArrayType typeArray = type.isArray();
        if (typeArray != null) {
            this.accept(typeArray.getComponentType());
            this.endVisit(typeArray);
        }
        if ((typeParameterized = type.isParameterized()) != null) {
            this.accept((JType)typeParameterized.getBaseType());
            for (JClassType typeArg : typeParameterized.getTypeArgs()) {
                this.accept((JType)typeArg);
            }
            this.endVisit(typeParameterized);
        }
        if ((typeRaw = type.isRawType()) != null) {
            this.accept((JType)typeRaw.getBaseType());
            this.endVisit(typeRaw);
        }
        if ((typeWild = type.isWildcard()) != null) {
            this.accept((JType)typeWild.getFirstBound());
            this.endVisit(typeWild);
        }
    }

    protected void endVisit(JAnnotationType typeAnnotation) {
    }

    protected void endVisit(JArrayType typeArray) {
    }

    protected void endVisit(JEnumType typeEnum) {
    }

    protected void endVisit(JGenericType typeGeneric) {
    }

    protected void endVisit(JParameterizedType typeParameterized) {
    }

    protected void endVisit(JPrimitiveType typePrimitive) {
    }

    protected void endVisit(JRawType typeRaw) {
    }

    protected void endVisit(JRealClassType typeReal) {
    }

    protected void endVisit(JType type) {
        JAnnotationType typeAnnotation = type.isAnnotation();
        if (typeAnnotation != null) {
            this.endVisit(typeAnnotation);
            return;
        }
        JArrayType typeArray = type.isArray();
        if (typeArray != null) {
            this.endVisit(typeArray);
            return;
        }
        JEnumType typeEnum = type.isEnum();
        if (typeEnum != null) {
            this.endVisit(typeEnum);
            return;
        }
        JGenericType typeGeneric = type.isGenericType();
        if (typeGeneric != null) {
            this.endVisit(typeGeneric);
            return;
        }
        JParameterizedType typeParameterized = type.isParameterized();
        if (typeParameterized != null) {
            this.endVisit(typeParameterized);
            return;
        }
        JPrimitiveType typePrimitive = type.isPrimitive();
        if (typePrimitive != null) {
            this.endVisit(typePrimitive);
            return;
        }
        JRawType typeRaw = type.isRawType();
        if (typeRaw != null) {
            this.endVisit(typeRaw);
            return;
        }
        JTypeParameter typeParam = type.isTypeParameter();
        if (typeParam != null) {
            this.endVisit(typeParam);
            return;
        }
        JWildcardType typeWild = type.isWildcard();
        if (typeWild != null) {
            this.endVisit(typeWild);
            return;
        }
        JRealClassType typeReal = (JRealClassType)type;
        this.endVisit(typeReal);
    }

    protected void endVisit(JTypeParameter typeParam) {
    }

    protected void endVisit(JWildcardType typeWild) {
    }
}

