/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind.rpc;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JRealClassType;
import com.google.gwt.user.rebind.rpc.TypeFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class BlacklistTypeFilter
implements TypeFilter {
    private List<Boolean> includeType;
    private TreeLogger logger;
    private List<Pattern> typePatterns;
    private List<String> values;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BlacklistTypeFilter(TreeLogger logger, PropertyOracle propertyOracle) throws UnableToCompleteException {
        this.logger = logger.branch(TreeLogger.DEBUG, "Analyzing RPC blacklist information");
        try {
            ConfigurationProperty prop = propertyOracle.getConfigurationProperty("rpc.blacklist");
            this.values = prop.getValues();
            int size = this.values.size();
            this.typePatterns = new ArrayList<Pattern>(size);
            this.includeType = new ArrayList<Boolean>(size);
            for (String regex : this.values) {
                boolean include = false;
                if (regex.length() == 0) {
                    logger.log(TreeLogger.ERROR, "Got empty RPC blacklist entry");
                    throw new UnableToCompleteException();
                }
                char c = regex.charAt(0);
                if (c == '+' || c == '-') {
                    regex = regex.substring(1);
                    include = c == '+';
                }
                try {
                    Pattern p = Pattern.compile(regex);
                    this.typePatterns.add(p);
                    this.includeType.add(include);
                    logger.log(TreeLogger.DEBUG, "Got RPC blacklist entry '" + regex + "'");
                }
                catch (PatternSyntaxException e) {
                    logger.log(TreeLogger.ERROR, "Got malformed RPC blacklist entry '" + regex + "'");
                    throw new UnableToCompleteException();
                    return;
                }
            }
        }
        catch (BadPropertyValueException e) {
            logger.log(TreeLogger.DEBUG, "No RPC blacklist entries present");
        }
    }

    public String getName() {
        return "BlacklistTypeFilter";
    }

    public boolean isAllowed(JClassType type) {
        String name = this.getBaseTypeName(type);
        if (name == null) {
            return true;
        }
        int size = this.typePatterns.size();
        for (int idx = size - 1; idx >= 0; --idx) {
            this.logger.log(TreeLogger.DEBUG, "Considering RPC rule " + this.values.get(idx) + " for type " + name);
            boolean include = this.includeType.get(idx);
            Pattern pattern = this.typePatterns.get(idx);
            if (!pattern.matcher(name).matches()) continue;
            if (include) {
                this.logger.log(TreeLogger.DEBUG, "Whitelisting type " + name + " according to rule " + this.values.get(idx));
                return true;
            }
            this.logger.log(TreeLogger.DEBUG, "Blacklisting type " + name + " according to rule " + this.values.get(idx));
            return false;
        }
        return true;
    }

    private String getBaseTypeName(JClassType type) {
        JClassType baseType = null;
        if (type instanceof JRealClassType) {
            baseType = type;
        } else if (type.isParameterized() != null) {
            baseType = type.isParameterized().getBaseType();
        } else if (type.isRawType() != null) {
            baseType = type.isRawType();
        }
        return baseType == null ? null : baseType.getQualifiedSourceName();
    }
}

