/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.rebind;

import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.user.rebind.ClassSourceFileComposer;
import com.google.gwt.user.rebind.Enum;
import com.google.gwt.user.rebind.SourceWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassSourceFileComposerFactory {
    private List<String> annotations = new ArrayList<String>();
    private JavaSourceCategory classCategory = JavaSourceCategory.CLASS;
    private String classComment;
    private String className;
    private Set<String> imports = new HashSet<String>();
    private Set<String> interfaceNames = new HashSet<String>();
    private String packageName;
    private String superClassName;

    public ClassSourceFileComposerFactory(String packageName, String className) {
        this.packageName = packageName;
        this.className = className;
    }

    public void addAnnotationDeclaration(String declaration) {
        this.annotations.add(declaration);
    }

    public void addImplementedInterface(String intfName) {
        this.interfaceNames.add(intfName);
    }

    public void addImport(String typeName) {
        this.imports.add(typeName);
    }

    public SourceWriter createSourceWriter(GeneratorContext ctx, PrintWriter printWriter) {
        return new ClassSourceFileComposer(ctx, printWriter, this.getCreatedPackage(), this.getAnnotationDeclarations(), this.getCreatedClassShortName(), this.getSuperclassName(), this.getInterfaceNames(), this.getImports(), this.classCategory, this.classComment);
    }

    public SourceWriter createSourceWriter(PrintWriter printWriter) {
        return new ClassSourceFileComposer(null, printWriter, this.getCreatedPackage(), this.getAnnotationDeclarations(), this.getCreatedClassShortName(), this.getSuperclassName(), this.getInterfaceNames(), this.getImports(), this.classCategory, this.classComment);
    }

    public String[] getAnnotationDeclarations() {
        return this.annotations.toArray(new String[this.annotations.size()]);
    }

    public String getCreatedClassName() {
        return this.getCreatedPackage() + "." + this.getCreatedClassShortName();
    }

    public String getCreatedClassShortName() {
        return this.className;
    }

    public String getCreatedPackage() {
        return this.packageName;
    }

    public String[] getInterfaceNames() {
        return this.interfaceNames.toArray(new String[this.interfaceNames.size()]);
    }

    public String getSuperclassName() {
        return this.superClassName;
    }

    public void makeInterface() {
        this.classCategory = JavaSourceCategory.INTERFACE;
    }

    public void setJavaDocCommentForClass(String comment) {
        this.classComment = comment;
    }

    public void setSuperclass(String superclassName) {
        this.superClassName = superclassName;
    }

    private String[] getImports() {
        return this.imports.toArray(new String[this.imports.size()]);
    }

    public static class JavaSourceCategory
    extends Enum {
        public static final JavaSourceCategory CLASS;
        public static final JavaSourceCategory INTERFACE;
        static Map<String, Enum> pool;

        public static JavaSourceCategory require(String key) {
            return (JavaSourceCategory)Enum.require(key, pool);
        }

        protected JavaSourceCategory(String key) {
            super(key, pool);
        }

        static {
            pool = new HashMap<String, Enum>();
            CLASS = new JavaSourceCategory("class");
            INTERFACE = new JavaSourceCategory("interface");
        }
    }
}

