/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind;

import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;

class PrintWriterManager {
    private final GeneratorContext genCtx;
    private final String packageName;
    private final TreeLogger logger;
    private final Set<PrintWriter> writers = new HashSet<PrintWriter>();

    PrintWriterManager(GeneratorContext genCtx, TreeLogger logger, String packageName) {
        this.genCtx = genCtx;
        this.packageName = packageName;
        this.logger = logger;
    }

    void commit() {
        for (PrintWriter writer : this.writers) {
            this.genCtx.commit(this.logger, writer);
        }
    }

    PrintWriter makePrintWriterFor(String name) {
        PrintWriter writer = this.tryToMakePrintWriterFor(name);
        if (writer == null) {
            throw new RuntimeException(String.format("Tried to write %s.%s twice.", this.packageName, name));
        }
        return writer;
    }

    PrintWriter tryToMakePrintWriterFor(String name) {
        PrintWriter writer = this.genCtx.tryCreate(this.logger, this.packageName, name);
        if (writer != null) {
            this.writers.add(writer);
        }
        return writer;
    }
}

