/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind;

import java.io.PrintWriter;

public class IndentedWriter {
    private final PrintWriter pw;
    private int indent;

    public IndentedWriter(PrintWriter pw) {
        this.pw = pw;
    }

    public void indent() {
        ++this.indent;
    }

    public void newline() {
        this.pw.println();
    }

    public void outdent() {
        if (this.indent == 0) {
            throw new IllegalStateException("Tried to outdent below zero");
        }
        --this.indent;
    }

    public void write(String format) {
        this.printIndent();
        this.pw.println(format);
    }

    public void write(String format, Object ... args) {
        this.printIndent();
        this.pw.printf(format, args);
        this.pw.println();
    }

    private void printIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.pw.print("  ");
        }
    }
}

