/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind;

import com.google.gwt.dev.util.collect.Sets;
import com.google.gwt.uibinder.rebind.UiBinderGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class GwtResourceEntityResolver
implements EntityResolver {
    private static final Set<String> EXTERNAL_PREFIXES = Collections.unmodifiableSet(Sets.create((Object[])new String[]{"http://google-web-toolkit.googlecode.com/files/", "http://dl.google.com/gwt/DTD/", "https://dl-ssl.google.com/gwt/DTD/"}));
    private static final String RESOURCES = "com/google/gwt/uibinder/resources/";
    private final ResourceLoader resourceLoader;

    public GwtResourceEntityResolver() {
        this(new ResourceLoader(){

            public InputStream fetch(String name) {
                return UiBinderGenerator.class.getClassLoader().getResourceAsStream(name);
            }
        });
    }

    GwtResourceEntityResolver(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String matchingPrefix = this.findMatchingPrefix(systemId);
        if (matchingPrefix == null) {
            return null;
        }
        String name = RESOURCES + systemId.substring(matchingPrefix.length());
        InputStream resourceStream = this.resourceLoader.fetch(name);
        if (resourceStream == null) {
            return null;
        }
        InputSource inputSource = new InputSource(resourceStream);
        inputSource.setPublicId(publicId);
        inputSource.setSystemId(systemId);
        return inputSource;
    }

    private String findMatchingPrefix(String systemId) {
        for (String prefix : EXTERNAL_PREFIXES) {
            if (!systemId.startsWith(prefix)) continue;
            return prefix;
        }
        return null;
    }

    static interface ResourceLoader {
        public InputStream fetch(String var1);
    }
}

