/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.rebind;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.uibinder.rebind.ChildWalker;
import com.google.gwt.uibinder.rebind.NodeVisitor;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.uibinder.rebind.XMLElementProvider;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GetEscapedInnerTextVisitor
implements NodeVisitor {
    protected final StringBuffer buffer;
    protected final XMLElement.Interpreter<String> interpreter;
    protected final XMLElementProvider elementProvider;

    public static void getEscapedInnerText(Element elem, StringBuffer buffer, XMLElement.Interpreter<String> interpreter, XMLElementProvider writer) throws UnableToCompleteException {
        new ChildWalker().accept(elem, new GetEscapedInnerTextVisitor(buffer, interpreter, writer));
    }

    protected GetEscapedInnerTextVisitor(StringBuffer buffer, XMLElement.Interpreter<String> interpreter, XMLElementProvider elementProvider) {
        this.buffer = buffer;
        this.interpreter = interpreter;
        this.elementProvider = elementProvider;
    }

    @Override
    public void visitCData(CDATASection d) {
    }

    @Override
    public void visitElement(Element e) throws UnableToCompleteException {
        String replacement = this.interpreter.interpretElement(this.elementProvider.get(e));
        if (replacement != null) {
            this.buffer.append(replacement);
        }
    }

    @Override
    public void visitText(Text t) {
        String escaped = UiBinderWriter.escapeText(t.getTextContent(), this.preserveWhiteSpace(t));
        this.buffer.append(escaped);
    }

    private boolean preserveWhiteSpace(Text t) {
        Element parent = 1 == t.getParentNode().getNodeType() ? (Element)t.getParentNode() : null;
        boolean preserveWhitespace = parent != null && "pre".equals(parent.getTagName());
        return preserveWhitespace;
    }
}

