/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.uibinder.elementparsers.ElementParser;
import com.google.gwt.uibinder.elementparsers.HtmlInterpreter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLElement;
import com.google.gwt.user.client.ui.DialogBox;

public class DialogBoxParser
implements ElementParser {
    public void parse(XMLElement elem, String fieldName, JClassType type, UiBinderWriter writer) throws UnableToCompleteException {
        String autoHide = elem.consumeBooleanAttribute("autoHide", false);
        String modal = elem.consumeBooleanAttribute("modal", true);
        String caption = null;
        String body = null;
        for (XMLElement child : elem.consumeChildElements()) {
            if ("caption".equals(child.getLocalName())) {
                if (caption != null) {
                    writer.die("In %s, may have only one <%s:caption>", elem, elem.getPrefix());
                }
                HtmlInterpreter interpreter = HtmlInterpreter.newInterpreterForUiObject(writer, fieldName);
                caption = child.consumeInnerHtml(interpreter);
                continue;
            }
            if (body != null) {
                writer.die("In %s, may have only one widget, but found %s and %s", elem, body, child);
            }
            if (!writer.isWidgetElement(child)) {
                writer.die("In %s, found non-widget %s", elem, child);
            }
            body = writer.parseElementToField(child);
        }
        writer.setFieldInitializerAsConstructor(fieldName, writer.getOracle().findType(DialogBox.class.getCanonicalName()), autoHide, modal);
        if (caption != null) {
            writer.addStatement("%s.setHTML(\"%s\");", fieldName, caption);
        }
        if (body != null) {
            writer.addStatement("%s.setWidget(%s);", fieldName, body);
        }
    }
}

