/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rebind.context;

import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JType;
import com.google.gwt.core.ext.typeinfo.TypeOracleException;
import com.google.gwt.dev.util.Util;
import com.google.gwt.resources.ext.ClientBundleRequirements;
import com.google.gwt.resources.rebind.context.AbstractClientBundleGenerator;
import com.google.gwt.resources.rebind.context.AbstractResourceContext;
import com.google.gwt.resources.rebind.context.MhtmlResourceContext;

public class MhtmlClientBundleGenerator
extends AbstractClientBundleGenerator {
    private static final String BUNDLE_EXTENSION = ".cache.txt";
    private String bundleBaseIdent;
    private MhtmlResourceContext resourceContext;

    protected AbstractResourceContext createResourceContext(TreeLogger logger, GeneratorContext context, JClassType resourceBundleType) {
        this.resourceContext = new MhtmlResourceContext(logger, context, resourceBundleType);
        return this.resourceContext;
    }

    protected void doAddFieldsAndRequirements(TreeLogger logger, GeneratorContext generatorContext, AbstractClientBundleGenerator.FieldsImpl fields, ClientBundleRequirements requirements) throws UnableToCompleteException {
        JType stringType;
        JType booleanType;
        try {
            booleanType = generatorContext.getTypeOracle().parse("boolean");
            stringType = generatorContext.getTypeOracle().parse("java.lang.String");
        }
        catch (TypeOracleException e) {
            logger.log(TreeLogger.ERROR, "Expected type not in type oracle", (Throwable)e);
            throw new UnableToCompleteException();
        }
        String isHttpsIdent = fields.define(booleanType, "isHttps", "GWT.getModuleBaseURL().startsWith(\"https\")", true, true);
        this.resourceContext.setIsHttpsIdent(isHttpsIdent);
        this.bundleBaseIdent = fields.define(stringType, "bundleBase", null, true, true);
        this.resourceContext.setBundleBaseIdent(this.bundleBaseIdent);
    }

    protected void doCreateBundleForPermutation(TreeLogger logger, GeneratorContext generatorContext, AbstractClientBundleGenerator.FieldsImpl fields, String generatedSimpleSourceName) throws UnableToCompleteException {
        String partialPath = Util.computeStrongName((byte[])Util.getBytes((String)generatedSimpleSourceName)) + BUNDLE_EXTENSION;
        this.resourceContext.setPartialPath(partialPath);
        fields.setInitializer(this.bundleBaseIdent, "\"mhtml:\" + GWT.getModuleBaseURL() + \"" + partialPath + "!cid:\"");
    }

    protected void doFinish(TreeLogger logger) throws UnableToCompleteException {
        this.resourceContext.finish();
    }
}

